import { createRouter, createWebHistory } from 'vue-router';

// Definir o basePath conforme o ambiente
const basePath = process.env.NODE_ENV === 'development' ? '/crmtbtbrindes/view' : '/view';

const routes = [
    {
        path: `${basePath}/producao`,
        name: 'Producao',
        component: () => import('./ordemServico/KanbanContent.vue')
    },
    {
        path: `${basePath}/calendario-producao`,
        name: 'CalendarioProducao',
        component: () => import('./ordemServico/CalendarioProducao.vue')
    },
    {
        path: `${basePath}/comissoes`,
        name: 'Comissoes',
        component: () => import('./comissao/ComissaoContent.vue')
    },
    {
        path: `${basePath}/metricas`,
        name: 'Metricas',
        component: () => import('./metrica/Metrica.vue')
    }
    // Outras rotas podem ser adicionadas aqui
];

const router = createRouter({
    history: createWebHistory(),
    routes
  });

export default router;