import { createApp } from 'vue';
import axios from 'axios';
import router from './router'; // Importar o router

import Sidebar from './partials/Sidebar.vue';
import Navbar from './partials/Navbar.vue';

import Toast, { POSITION } from 'vue-toastification';
import "vue-toastification/dist/index.css";

// Criação da aplicação Vue
const app = createApp({});

// Configuração do Vue Toastification
const toastOptions = {
    position: POSITION.TOP_RIGHT,  // Pode personalizar conforme necessário
    timeout: 5000,
    pauseOnHover: true,
    closeOnClick: true,
    draggable: true,
    draggablePercent: 0.6,
    showCloseButtonOnHover: true,
    closeButton: 'button',
    icon: true,
    rtl: false,
};

app.use(Toast, toastOptions);

// Usar o router
app.use(router);

// Definindo a variável global
app.config.globalProperties.$path_core = '../app/Core/';

// Função para obter dados do usuário
async function fetchUser() {
    try {
        const response = await axios.get(`${app.config.globalProperties.$path_core}/User.php?action=getDadosUsuarioSessao`);
        return response.data;
    } catch (error) {
        console.error('Erro ao obter dados do usuário:', error);
        return null;
    }
}

// Obter o userLevel e definir no protótipo do Vue
fetchUser().then(user => {
    app.config.globalProperties.$userId    = user.id;
    app.config.globalProperties.$userName  = user.nome;
    app.config.globalProperties.$userLevel = user.nivel;
    app.config.globalProperties.$userEmail = user.email;
    app.config.globalProperties.$userImg   = user.img;

    // Registrar componentes
    app.component('sidebar-menu', Sidebar);
    app.component('navbar-menu', Navbar);

    // Montar a aplicação Vue
    app.mount('#app');

    setTimeout(() => {
        execLibs();
    }, 500);
});

// Função para inicializar tooltips
function execLibs() {
    $('[data-bs-toggle="tooltip"]').tooltip({
        trigger : 'hover'
    }).on('click', function () {
        $(this).tooltip('hide')
    })
}