<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Tarífas</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/css/demo.css" />

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />


    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y">
                        <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                            <h5 class="card-header">Taxas e Comissões</h5>


                            <?php
                            $tax = new App\Core\Tax;
                            $data = $tax->show();
                            ?>

                            <div class="card-body">
                                <div class="row">
                                    <div class="col-xl-4 col-lg-4 col-12 mb-3 mb-lg-0 mb-xl-0 mb-xxl-0">
                                        <div class="table-responsive text-nowrap">
                                            <table class="table table-sm table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" class="text-center">Menor Preço</th>
                                                    </tr>
                                                    <tr>
                                                        <th>Taxa <span class="float-end">%</span></th>
                                                        <th>Comissão <span class="float-end">%</span></th>
                                                    </tr>
                                                </thead>
                                                <tbody class="table-border-bottom-0">
                                                    <tr >
                                                        <td class="p-0">
                                                            <input type="hidden" id="input-menor-old-value" value="<?= $data[0]['menor_preco'] ?>">
                                                            <input value="<?= $data[0]['menor_preco'] ?>" type="number" class="form-control border-0" id="input-menor" placeholder="Informe aqui o percentual">
                                                        </td>
                                                        <td class="p-0">
                                                            <input type="hidden" id="input-menor-comissao-old-value" value="<?= $data[0]['menor_preco_comissao'] ?>">
                                                            <input value="<?= $data[0]['menor_preco_comissao'] ?>" type="number" class="form-control border-0" id="input-menor-comisao" placeholder="Informe aqui o percentual">
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-12 mb-3 mb-lg-0 mb-xl-0 mb-xxl-0">
                                        <div class="table-responsive text-nowrap">
                                            <table class="table table-sm table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" class="text-center">Condição ideal</th>
                                                    </tr>
                                                    <tr>
                                                        <th>Taxa <span class="float-end">%</span></th>
                                                        <th>Comissão <span class="float-end">%</span></th>
                                                    </tr>
                                                </thead>
                                                <tbody class="table-border-bottom-0">
                                                    <tr>
                                                        <td class="p-0">
                                                            <input type="hidden" id="condicao_ideal-old-value" value="<?= $data[0]['condicao_ideal'] ?>">
                                                            <input value="<?= $data[0]['condicao_ideal'] ?>" type="number" class="form-control border-0" id="input-ideal" placeholder="Informe aqui o percentual">
                                                        </td>
                                                        <td class="p-0">
                                                            <input type="hidden" id="input-ideal-comissao-old-value" value="<?= $data[0]['condicao_ideal_comissao'] ?>">
                                                            <input value="<?= $data[0]['condicao_ideal_comissao'] ?>" type="number" class="form-control border-0" id="input-ideal-comisao" placeholder="Informe aqui o percentual">
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-12 mb-3 mb-lg-0 mb-xl-0 mb-xxl-0">
                                        <div class="table-responsive text-nowrap">
                                            <table class="table table-sm table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th colspan="2" class="text-center">Preço com margem</th>
                                                    </tr>
                                                    <tr>
                                                        <th>Taxa <span class="float-end">%</span></th>
                                                        <th>Comissão <span class="float-end">%</span></th>
                                                    </tr>
                                                </thead>
                                                <tbody class="table-border-bottom-0">
                                                    <tr>
                                                        <td class="p-0">
                                                            <input type="hidden" id="preco_com_margem-old-value" value="<?= $data[0]['preco_com_margem'] ?>">
                                                            <input value="<?= $data[0]['preco_com_margem'] ?>" type="number" class="form-control border-0" id="input-margem" placeholder="Informe aqui o percentual">
                                                        </td>
                                                        <td class="p-0">
                                                            <input type="hidden" id="input-com-margem-old-value" value="<?= $data[0]['preco_com_margem_comissao'] ?>">
                                                            <input value="<?= $data[0]['preco_com_margem_comissao'] ?>" type="number" class="form-control border-0" id="input-com-margem-comisao" placeholder="Informe aqui o percentual">
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-4">
                                    <div class="col">
                                        <input type="hidden" id="tax-id" value="<?= $data[0]['id'] ?>">
                                        <button class="btn btn-sm btn-primary" id="btn-save-tax" type="button">Salvar</button>
                                        <button class="btn btn-sm btn-secondary" id="btn-clear-tax" type="button">Limpar campos
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Modals -->
    <!-- / Modals -->

    <!-- Core JS -->
    <!-- build:js assets/vendor_template/js/core.js -->
    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="assets/vendor_template/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/js/tax.js"></script>
    <script src="assets/js/helpers.js"></script>
    <script src="assets/vendor/fattos/alert.js"></script>
</body>

</html>