<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Nova visita</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <!-- Page CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container, .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }
    </style>

    <script src="assets/js/config.js"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container control-dark-mode dark-mode light-mode">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y">
                        <div class="card mb-3" >
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h5 class="card-title">Lançamento de visita</h5>
                                    </div>
                                </div>                        
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-xl-5 col-lg-5 col-md-12 col-sm-12">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Cliente *</label><br>
                                            <input type="text" class="form-control" id="select-customers-contact" placeholder="e.g. Afrente Soluções">
                                        </div>
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-12 col-sm-12">
                                        <div class="form-group mb-3">
                                            <label class="form-label">Contato</label>
                                            <input class="form-control" id="pessoa-contato-cliente" type="text"
                                                placeholder="Nome da pessoa que teve diálogo">
                                        </div>
                                    </div>
                                    <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12">
                                        <div class="form-group">
                                            <label class="form-label">Telefone / Celular *</label>
                                            <input class="form-control phone-contact" id="telefone-celular-contato" type="text" placeholder="Digite aqui o telefone/celular">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label class="form-label">Diálogo com cliente *</label>
                                            <textarea class="form-control" id="dialog-client-contato" rows="4" placeholder="Descreva aqui o diálogo com o cliente"></textarea>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col">
                                        <div class="form-group">
                                            <label class="form-label">Categoria</label>
                                            <select class="form-select" id="select-categoria-contato">
                                                <option value="1">Novo contato</option>
                                                <option value="2">Nova solicitação de orçamento</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div id="map" style="height: 400px; width: 100%;"></div>

                                <div id="div-solicitacao-orcamento-contato" class="d-none mb-2">
                                    <div class="row">
                                        <div class="col">
                                            <div class="form-group">
                                                <label for="" class="form-label">Descreva o pedido *</label>
                                                <textarea class="form-control" id="descricao-solicitacao-orcamento-contato" rows="2" placeholder="Descreva aqui o pedido do cliente"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col">
                                            <div class="form-group">
                                                <label for="" class="form-label">Anexo(s)</label>
                                                <input class="form-control" id="anexos-solicitacao-orcamento-contato" type="file" multiple="multiple">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <input type="hidden" id="contato-latitude">
                                <input type="hidden" id="contato-longitude">
                                <button type="button" class="btn btn-primary mt-3" onclick="saveContact()">Salvar</button>
                            </div>
                            
                        </div>
                    </div>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>

            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->


    <!-- Core JS -->
    <!-- build:js assets/vendor_template/js/core.js -->
    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/jquery-mask/jquery-mask-update.min.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/select2/select2.min.js"></script>
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/vendor/fattos/alert.js"></script>

    <script>
        const path_core = '../app/Core/';

        $('#select-uf-contato').on('change', function() {
            const uf = $(this).val();

            $('#select-cidade-contato').val('').attr('disabled', true);


            if (uf == '') {
                return;
            }

            $.ajax({
                method: 'GET',
                url: `https://servicodados.ibge.gov.br/api/v1/localidades/estados/${uf}/distritos?orderBy=nome`,
                dataType: 'JSON',
                success: (data) => {

                    $('#select-cidade-contato').attr('disabled', false);
                    $('#select-cidade-contato').html('<option value="">Selecione a cidade</option>');

                    data.forEach((city) => {
                        $('#select-cidade-contato').append(`<option value="${city.nome}">${city.nome}</option>`);
                    });

                    $('#select-cidade-contato').select2({
                        width: '100%'
                    });
                },
            })
        })

        setTimeout(() => {
            $('#select-uf-contato').val('SC').trigger('change');
        }, 1500);

        var isSolicitacaoContato = false; 
        $('#select-categoria-contato').on('change', function() {
            const categoria = $(this).val();

            isSolicitacaoContato = false; 
            $('#div-solicitacao-orcamento-contato').addClass('d-none');
            $('#descricao-solicitacao-orcamento-contato').val('');
            $('#descricao-solicitacao-orcamento-anexo').val('');

            if (categoria == '2') {
                isSolicitacaoContato = true; 
                $('#div-solicitacao-orcamento-contato').removeClass('d-none');
            }
        });


        $('.phone-contact').mask('(00) 0000-00009', {
            onKeyPress: function (val, e, field, options) {
                var mask = val.replace(/\D/g, '').length > 10 ? '(00) 0 0000-0000' : '(00) 0000-00009';
                field.mask(mask, options);
            }
        });

        function saveContact() {
            const formData = new FormData();
            const cliente = $('#select-customers-contact').val();
            const contato = $('#pessoa-contato-cliente').val();
            const telefone = $('#telefone-celular-contato').val();
            const dialogo = $('#dialog-client-contato').val();
            const categoria = $('#select-categoria-contato').val();
            const descricao = $('#descricao-solicitacao-orcamento-contato').val();
            const anexos = $('#anexos-solicitacao-orcamento-contato').prop('files');
            const latitude = $('#contato-latitude').val();
            const longitude = $('#contato-longitude').val();

            if (cliente == '' || telefone == '' || dialogo == '') {
                alert('Preencha todos os campos obrigatórios');
                return;
            }

            if (isSolicitacaoContato && descricao == '') {
                alert('Preencha a descrição da solicitação de orçamento');
                return;
            }

            if (isSolicitacaoContato) {
                anexos.forEach((anexo) => {
                    if (anexo.size > 1024 * 1024 * 5) {
                        alert('O arquivo não pode ser maior que 5MB');
                        return;
                    }
                });

                for (let i = 0; i < anexos.length; i++) {
                    formData.append('file' + i, anexos[i]);
                }
            }

            formData.append('cliente', cliente);
            formData.append('contato', contato);
            formData.append('tel', telefone);
            formData.append('dialogo', dialogo);
            formData.append('categoria', categoria);
            formData.append('descricao_solicitacao', descricao);
            formData.append('anexos', anexos);
            formData.append('latitude', latitude);
            formData.append('longitude', longitude);
            formData.append('action', 'saveContactRepresentante');

            $.ajax({
                method: 'POST',
                url: `${path_core}Contact.php`,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    fat_alert({
                        type: 'primary',
                        title: 'Successo!!!',
                        message: 'Contato lançado com sucesso!',
                        timer: 5000
                    });

                    setTimeout(() => {
                        window.location.reload(false);
                    }, 2000);
                    console.log(data);
                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function(position) {
                var lat = position.coords.latitude;
                var lon = position.coords.longitude;

                // Cria o mapa
                var map = L.map('map').setView([lat, lon], 18);

                // Define a camada do mapa
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
                }).addTo(map);

                // Adiciona um marcador para a localização atual
                L.marker([lat, lon]).addTo(map).bindPopup('Minha localização atual').openPopup();

                $('#contato-latitude').val(lat);
                $('#contato-longitude').val(lon);
            }, 
            function(error) {
                console.log("Erro ao obter localização: ", error);
            }, 
            {
                enableHighAccuracy: true
            });
        } else {
            console.log("Geolocalização não é suportada por este navegador.");
        }
    </script>

</body>

</html>