<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Personalizações</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
          rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>

    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container,
        .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }

        #select-users {
            max-height: 35px !important;
        }
    </style>
    <!-- Helpers -->
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper ">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <h5 class="card-header">Personalizações

                            <button type="button"
                                    class="btn w-px-20 h-px-20 mb-1 rounded-pill btn-icon btn-outline-secondary"
                                    title="Cadastrar nova categoria" data-bs-toggle="modal" data-bs-target="#modal-cadastra-personalizacao">
                                <span class="tf-icons bx bx-plus"></span>
                            </button>
                        </h5>

                        <div class="table-responsive text-nowrap">
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Tipo</th>
                                    <th class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0" id="table-code-info">
                                    <tr>
                                        <td colspan="2" class="text-center">Carregando...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/modal_cadastra_personalizacao.html';
include __DIR__ . '/partials/modal/modal_edita_personalizacao.html';
?>
<!-- / Modals -->

<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/select2/select2.min.js"></script>

<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/vendor/fattos/alert.js"></script>

<script src="assets/js/helpers.js"></script>

<script>
    function s() {
        fat_alert({
            type: 'dark',
            title: 'Oops...',
            message: 'Recurso em implementação',
            timer: 5000
        });
    }
    
    const path_core = '../app/Core/';

    /**
     * @var btn_add_personalizacao
     */
    const btn_add_personalizacao = $('#btn-add-personalizacao');

    btn_add_personalizacao.on('click', function() {
        const codigo = $('#modal-new-code-codigo').val();

        if (codigo == '') {
            fat_alert({
                type: 'warning',
                title: 'Oops...',
                message: 'Favor informar um nome!',
                timer: 3000
            });
            return;
        }

        btn_add_personalizacao.attr('disabled', true);

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            url: `${path_core}Personalizacao.php`,
            data: {
                nome: codigo,
                action: 'store'
            },
            success: function (data) {
                console.log(data);
                btn_add_personalizacao.attr('disabled', false);
                show().then((response) => renderInfoTable(response))

                $('.input-code').val('');

                fat_alert({
                    type: 'success',
                    title: 'Successo!!!',
                    message: 'Código cadastrado com sucesso!',
                    timer: 3000
                });

                window.location.reload(false);

            },
            error: function (xhr) {
                console.log(xhr);
                const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';

                fat_alert({
                    title: 'Erro',
                    message: errorMessage,
                    type: 'danger',
                    timer: 3000
                });

                return false;
            }
        });
    });

    async function show() {
        return await $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: `${path_core}Personalizacao.php?action=show`,
        });
    }

    /**
     * Método responsável por obter os dados do código para montar o formulário de edição
     */
    function modalEditCode(id, nome) {
        $('#modal-edit-code-id').val(id);
        $('#modal-edit-code-codigo').val(nome)
        $('#modal-edit-code-title').text('Editar código: ' + nome)
        $('#modal-edita-personalizacao').modal('show');
    }

    $('#btn-edit-code').on('click', function() {
        const id = $('#modal-edit-code-id').val();
        const code = $('#modal-edit-code-codigo').val();

        if (!code) {
            fat_alert({
                type: 'danger',
                title: 'Oops!',
                message: 'Informe o nome do código para alterar',
                timer: 3000
            });
            return;
        }

        $.ajax({
            type: 'POST',
            url: `${path_core}Personalizacao.php`,
            data: {
                action: 'atualizaNomeCodigo',
                id: id,
                nome: code
            },
            success: function (data) {
                $(`#setDinamycName-${id}`).text(code);
                fat_alert({
                    type: 'primary',
                    title: 'Sucesso!!!',
                    message: 'Código atualizado com sucesso!!!',
                    timer: 3000
                });
                $('#modal-edit-code').modal('hide');
            },
            error: function (xhr) {
                fat_alert({
                    type: 'danger',
                    title: 'Oops!',
                    message: 'Ocorreu um problema ao atualizar o código',
                    timer: 3000
                });

                console.log(xhr);
            }
        });
    });

    function renderInfoTable(data) {

        let html = '';

        if (data == '') {
            html += `
                <tr>
                    <td colspan="2" class="text-center"><small>Nenhum registro encontrado... 🤔</small></td>
                </tr>
            `;

            fat_alert({
                type: 'dark',
                title: 'Hey!!!',
                message: 'Que tal criar seu primeiro código personalizado? 🤓',
                timer: 5000
            });

            setTimeout(() => {                
                fat_alert({
                    type: 'dark',
                    title: 'Vamos lá? 💡',
                    message: 'Clique no botão "+" ao lado de "Códigos" para começar... ',
                    timer: 5000
                });
            }, 5000);
        }

        data.forEach(el => {
            htmlOtions = `
                <div class="dropdown dropstart">
                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                        <i class="bx bx-dots-vertical-rounded"></i>
                    </button>
                    <div class="dropdown-menu">
                        <a class="dropdown-item" onclick="modalEditCode(${el.id}, '${el.tipo}')"><i class="bx bx-edit-alt me-1"></i>Editar</a>
                        <a class="dropdown-item" href="javascript:void(0);"><i class="bx bx-low-vision me-1"></i>Inativar</a>
                    </div>
                </div>
            `;

            html += `
                <tr>
                    <td id="setDinamycName-${el.id}">${el.tipo}</td>
                    <td class="text-center">${htmlOtions}</td>
                </tr>
            `;
        });

        $('#table-code-info').html(html)
    }

    show().then(
        (response) => renderInfoTable(response)
    ).catch(
        (error) => console.log(error)
    );


    const getUsers = () => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}User.php`,
                data: {
                    action: 'getNameAndId'
                },
                success: function (data) {
                    resolve(data);
                },
                error: function (xhr) {
                    reject(xhr);
                }
            });
        });
    };

    getUsers()
        .then(response => {
            const users = response;

            let html = '';

            users.forEach(el => {
                html += `<option value='${el.id}'>${el.nome}</option>`
            });

            $('#select-users').html(html);
            
            $('#select-users').select2({
                dropdownParent: $('#modal-new-code'),
                width: '100%'
            });
        })
        .catch(error => {
            console.log(error);
        });

</script>

</body>

</html>