<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Nova ordem de serviço</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />

    <meta name="robots" content="noindex" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container,
        .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }

        .bs-stepper .step-trigger {
            display: -ms-inline-flexbox;
            display: inline-flex;
            -ms-flex-wrap: wrap;
            flex-wrap: wrap;
            -ms-flex-align: center;
            align-items: center;
            -ms-flex-pack: center;
            justify-content: center;
            padding: 20px;
            font-size: 1rem;
            font-weight: 700;
            line-height: 1.5;
            color: #6c757d;
            text-align: center;
            text-decoration: none;
            white-space: nowrap;
            vertical-align: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            background-color: transparent;
            border: none;
            border-radius: .25rem;
            transition: background-color .15s ease-out, color .15s ease-out
        }

        .bs-stepper .step-trigger:not(:disabled):not(.disabled) {
            cursor: pointer
        }

        .bs-stepper .step-trigger:disabled,
        .bs-stepper .step-trigger.disabled {
            pointer-events: none;
            opacity: .65
        }

        .bs-stepper .step-trigger:focus {
            color: #007bff;
            outline: none
        }

        .bs-stepper .step-trigger:hover {
            text-decoration: none;
            background-color: rgba(0, 0, 0, 0.06)
        }

        @media(max-width: 520px) {
            .bs-stepper .step-trigger {
                -ms-flex-direction: column;
                flex-direction: column;
                padding: 10px
            }
        }

        .bs-stepper-label {
            display: inline-block;
            margin: .25rem
        }

        .bs-stepper-header {
            display: -ms-flexbox;
            display: flex;
            -ms-flex-align: center;
            align-items: center
        }

        @media(max-width: 520px) {
            .bs-stepper-header {
                margin: 0 -10px;
                text-align: center
            }
        }

        .bs-stepper-line,
        .bs-stepper .line {
            -ms-flex: 1 0 32px;
            flex: 1 0 32px;
            min-width: 1px;
            min-height: 1px;
            margin: auto;
            background-color: rgba(0, 0, 0, 0.12)
        }

        @media(max-width: 400px) {

            .bs-stepper-line,
            .bs-stepper .line {
                -ms-flex-preferred-size: 20px;
                flex-basis: 20px
            }
        }

        .bs-stepper-circle {
            display: -ms-inline-flexbox;
            display: inline-flex;
            -ms-flex-line-pack: center;
            align-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            width: 2em;
            height: 2em;
            padding: .5em 0;
            margin: .25rem;
            line-height: 1em;
            color: #fff;
            background-color: #6c757d;
            border-radius: 1em
        }

        .active .bs-stepper-circle {
            background-color: #007bff
        }

        .bs-stepper-content {
            padding: 0 20px 20px
        }

        @media(max-width: 520px) {
            .bs-stepper-content {
                padding: 0
            }
        }

        .bs-stepper.vertical {
            display: -ms-flexbox;
            display: flex
        }

        .bs-stepper.vertical .bs-stepper-header {
            -ms-flex-direction: column;
            flex-direction: column;
            -ms-flex-align: stretch;
            align-items: stretch;
            margin: 0
        }

        .bs-stepper.vertical .bs-stepper-pane,
        .bs-stepper.vertical .content {
            display: block
        }

        .bs-stepper.vertical .bs-stepper-pane:not(.fade),
        .bs-stepper.vertical .content:not(.fade) {
            display: block;
            visibility: hidden
        }

        .bs-stepper-pane:not(.fade),
        .bs-stepper .content:not(.fade) {
            display: none
        }

        .bs-stepper .content.fade,
        .bs-stepper-pane.fade {
            visibility: hidden;
            transition-duration: .3s;
            transition-property: opacity
        }

        .bs-stepper-pane.fade.active,
        .bs-stepper .content.fade.active {
            visibility: visible;
            opacity: 1
        }

        .bs-stepper-pane.active:not(.fade),
        .bs-stepper .content.active:not(.fade) {
            display: block;
            visibility: visible
        }

        .bs-stepper-pane.dstepper-block,
        .bs-stepper .content.dstepper-block {
            display: block
        }

        .bs-stepper:not(.vertical) .bs-stepper-pane.dstepper-none,
        .bs-stepper:not(.vertical) .content.dstepper-none {
            display: none
        }

        .vertical .bs-stepper-pane.fade.dstepper-none,
        .vertical .content.fade.dstepper-none {
            visibility: hidden
        }

        .bs-stepper {
            border-radius: .375rem
        }

        .bs-stepper .line {
            flex: 0;
            min-width: auto;
            min-height: auto;
            background-color: rgba(0, 0, 0, 0);
            margin: 0
        }

        .bs-stepper .line i {
            font-size: 1.375rem
        }

        .bs-stepper .bs-stepper-header {
            /* padding: 1.5rem 1.5rem */
        }

        .bs-stepper .bs-stepper-header .step.crossed+.line i {
            color: #696cff
        }

        .bs-stepper .bs-stepper-header .step .step-trigger {
            padding: 0;
            flex-wrap: nowrap;
            gap: .5rem;
            font-weight: 500
        }

        .bs-stepper .bs-stepper-header .step .step-trigger .bs-stepper-label {
            margin: 0;
            max-width: 224px;
            overflow: hidden;
            text-overflow: ellipsis;
            text-align: start;
            display: inline-grid;
            font-weight: 500;
            font-size: .9375rem
        }

        .bs-stepper .bs-stepper-header .step .step-trigger .bs-stepper-label .bs-stepper-title {
            line-height: 1.375rem;
            font-weight: 500
        }

        .bs-stepper .bs-stepper-header .step .step-trigger .bs-stepper-label .bs-stepper-subtitle {
            font-size: .8125rem;
            font-weight: 400
        }

        .bs-stepper .bs-stepper-header .step .step-trigger:hover {
            background-color: rgba(0, 0, 0, 0)
        }

        @media(max-width: 991.98px) {
            .bs-stepper .bs-stepper-header .step .step-trigger {
                padding: .625rem 0
            }
        }

        .bs-stepper .bs-stepper-header .step .bs-stepper-circle {
            height: 2.375rem;
            width: 2.375rem;
            font-weight: 500;
            font-size: 1.125rem;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: .375rem
        }

        .bs-stepper .bs-stepper-header .step .bs-stepper-circle i {
            font-size: 1.375rem
        }

        .bs-stepper .bs-stepper-content {
            padding: 1.5rem 1.5rem
        }

        .bs-stepper.vertical .bs-stepper-header {
            min-width: 18rem
        }

        .bs-stepper.vertical .bs-stepper-header .step .step-trigger {
            padding: .63rem 0
        }

        .bs-stepper.vertical .bs-stepper-header .step:first-child .step-trigger {
            padding-top: 0
        }

        .bs-stepper.vertical .bs-stepper-header .step:last-child .step-trigger {
            padding-bottom: 0
        }

        .bs-stepper.vertical .bs-stepper-content {
            width: 100%
        }

        .bs-stepper.vertical .bs-stepper-content .content:not(.active) {
            display: none
        }

        .bs-stepper.vertical.wizard-icons .step {
            text-align: center;
            padding: .75rem 0
        }

        .bs-stepper.wizard-icons .bs-stepper-header .step-trigger {
            padding: 1.25rem;
            flex-direction: column;
            gap: .5rem
        }

        .bs-stepper.wizard-icons .bs-stepper-header .step-trigger .bs-stepper-icon svg {
            height: 3.5rem;
            width: 3.5rem
        }

        .bs-stepper.wizard-icons .bs-stepper-header .step-trigger .bs-stepper-icon i {
            font-size: 1.6rem
        }

        @media(min-width: 992px) {
            .bs-stepper.wizard-icons .bs-stepper-header {
                justify-content: space-around;
                gap: 1rem
            }
        }

        .bs-stepper.wizard-modern .bs-stepper-header {
            border-bottom: none !important
        }

        .bs-stepper.wizard-modern .bs-stepper-content {
            border-radius: .375rem
        }

        .bs-stepper.wizard-modern.vertical .bs-stepper-header {
            border-right: none !important
        }

        @media(min-width: 992px) {
            .bs-stepper:not(.vertical):not(.wizard-icons) .bs-stepper-header {
                gap: 1.5rem
            }
        }

        @media(max-width: 991.98px) {
            [dir=rtl] .bs-stepper.wizard-icons .bs-stepper-header .step-trigger {
                padding-right: 0
            }
        }

        @media(max-width: 991.98px) {
            html:not([dir=rtl]) .bs-stepper.wizard-icons .bs-stepper-header .step-trigger {
                padding-left: 0
            }
        }

        #wizard-create-app.vertical .bs-stepper-header {
            min-width: 15rem
        }

        .light-style .bs-stepper {
            background-color: #fff
        }

        .light-style .bs-stepper:not(.wizard-modern) {
            box-shadow: 0 .1875rem .5rem 0 rgba(34, 48, 62, .1)
        }

        .light-style .bs-stepper .bs-stepper-header {
            border-bottom: 1px solid #e4e6e8
        }

        .light-style .bs-stepper .bs-stepper-header .line i {
            color: #646e78
        }

        .light-style .bs-stepper .bs-stepper-header .bs-stepper-title,
        .light-style .bs-stepper .bs-stepper-header .bs-stepper-label {
            color: #384551
        }

        .light-style .bs-stepper .bs-stepper-header .bs-stepper-label .bs-stepper-subtitle {
            color: #646e78
        }

        .light-style .bs-stepper .bs-stepper-header .step:not(.active) .bs-stepper-circle {
            background-color: rgba(34, 48, 62, .06);
            color: #646e78
        }

        .light-style .bs-stepper .bs-stepper-header .step:not(.active) .bs-stepper-subtitle {
            color: #a7acb2
        }

        .light-style .bs-stepper .bs-stepper-header .step.crossed .step-trigger .bs-stepper-label .bs-stepper-subtitle,
        .light-style .bs-stepper .bs-stepper-header .step.crossed .step-trigger .bs-stepper-title {
            color: #a7acb2
        }

        .light-style .bs-stepper.vertical .bs-stepper-header {
            border-bottom: none
        }

        @media(max-width: 991.98px) {
            .light-style .bs-stepper.vertical .bs-stepper-header {
                border-right: none !important;
                border-left: none !important;
                border-bottom: 1px solid #e4e6e8
            }
        }

        .light-style .bs-stepper.wizard-modern {
            background-color: rgba(0, 0, 0, 0)
        }

        .light-style .bs-stepper.wizard-modern .bs-stepper-content {
            background-color: #fff;
            box-shadow: 0 .1875rem .5rem 0 rgba(34, 48, 62, .1)
        }

        .light-style .bs-stepper.wizard-icons .bs-stepper-header .bs-stepper-icon svg {
            fill: #646e78
        }

        .light-style .bs-stepper.wizard-icons .bs-stepper-header .bs-stepper-icon i {
            fill: #646e78
        }

        .light-style .bs-stepper.wizard-icons .bs-stepper-header .bs-stepper-label {
            color: #646e78
        }

        [dir=rtl] .light-style .bs-stepper.vertical .bs-stepper-header {
            border-left: 1px solid #e4e6e8
        }

        html:not([dir=rtl]) .light-style .bs-stepper.vertical .bs-stepper-header {
            border-right: 1px solid #e4e6e8
        }

        .dark-style .bs-stepper {
            background-color: #2b2c40
        }

        .dark-style .bs-stepper .bs-stepper-header {
            border-bottom: 1px solid #4e4f6c
        }

        .dark-style .bs-stepper .bs-stepper-header .line i {
            color: #b2b2c4
        }

        .dark-style .bs-stepper .bs-stepper-header .bs-stepper-label,
        .dark-style .bs-stepper .bs-stepper-header .bs-stepper-title {
            color: #d5d5e2
        }

        .dark-style .bs-stepper .bs-stepper-header .bs-stepper-label .bs-stepper-subtitle {
            color: #b2b2c4
        }

        .dark-style .bs-stepper .bs-stepper-header .step:not(.active) .bs-stepper-circle {
            background-color: rgba(230, 230, 241, .06);
            color: #b2b2c4
        }

        .dark-style .bs-stepper .bs-stepper-header .step:not(.active) .bs-stepper-subtitle {
            color: #7e7f96
        }

        .dark-style .bs-stepper .bs-stepper-header .step.crossed .step-trigger .bs-stepper-label .bs-stepper-subtitle,
        .dark-style .bs-stepper .bs-stepper-header .step.crossed .step-trigger .bs-stepper-title {
            color: #7e7f96
        }

        .dark-style .bs-stepper.vertical .bs-stepper-header {
            border-bottom: none
        }

        @media(max-width: 991.98px) {
            .dark-style .bs-stepper.vertical .bs-stepper-header {
                border-right: none !important;
                border-left: none !important;
                border-bottom: 1px solid #4e4f6c
            }
        }

        .dark-style .bs-stepper.wizard-modern {
            background-color: rgba(0, 0, 0, 0)
        }

        .dark-style .bs-stepper.wizard-modern .bs-stepper-content {
            background-color: #2b2c40;
            box-shadow: 0 .1875rem .5rem 0 rgba(20, 20, 29, .22)
        }

        .dark-style .bs-stepper.wizard-icons .bs-stepper-header .bs-stepper-icon i {
            color: #b2b2c4
        }

        .dark-style .bs-stepper.wizard-icons .bs-stepper-header .bs-stepper-icon svg {
            fill: #b2b2c4
        }

        .dark-style .bs-stepper.wizard-icons .bs-stepper-header .bs-stepper-label {
            color: #b2b2c4
        }

        [dir=rtl] .dark-style .bs-stepper.vertical .bs-stepper-header {
            border-left: 1px solid #4e4f6c
        }

        html:not([dir=rtl]) .dark-style .bs-stepper.vertical .bs-stepper-header {
            border-right: 1px solid #4e4f6c
        }

        [dir=rtl] .bs-stepper .bs-stepper-content .btn-next i,
        [dir=rtl] .bs-stepper .bs-stepper-content .btn-prev i {
            transform: rotate(180deg)
        }

        [dir=rtl] .bs-stepper.wizard-modern.vertical .bs-stepper-header {
            border-left: none !important
        }

        @media(min-width: 992px) {
            [dir=rtl] .bs-stepper .bs-stepper-header .line i {
                transform: rotate(180deg)
            }
        }

        @media(max-width: 991.98px) {
            [dir=rtl] .bs-stepper .bs-stepper-header .step .step-trigger .bs-stepper-label {
                margin-left: 0;
                margin-right: .25rem
            }
        }

        @media(max-width: 991.98px) {
            .bs-stepper .bs-stepper-header {
                flex-direction: column;
                align-items: flex-start
            }

            .bs-stepper .bs-stepper-header .step .step-trigger {
                flex-direction: row
            }

            .bs-stepper .bs-stepper-header .step .step-trigger .bs-stepper-label {
                margin-left: .35rem
            }

            .bs-stepper .bs-stepper-header .step:first-child .step-trigger {
                padding-top: 0
            }

            .bs-stepper .bs-stepper-header .step:last-child .step-trigger {
                padding-bottom: 0
            }

            .bs-stepper.vertical {
                flex-direction: column
            }

            .bs-stepper.vertical .bs-stepper-header {
                align-items: flex-start
            }

            .bs-stepper:not(.vertical) .bs-stepper-header .line i {
                display: none
            }

            .bs-stepper.wizard-icons .bs-stepper-header .step:not(:first-child) .bs-stepper-icon svg {
                margin-top: .5rem
            }
        }

        @media(max-width: 520px) {
            .bs-stepper-header {
                margin: 0
            }
        }

        #wizard-create-app.vertical .bs-stepper-header {
            min-width: 15rem
        }
    </style>

    <script src="assets/js/config.js"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container control-dark-mode dark-mode light-mode">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y">

                        <h4 class="font-weight-bold py-3 mb-4">
                            Nova ordem de serviço
                        </h4>

                        <div class="bs-stepper vertical wizard-modern wizard-modern-vertical mt-2">
                            <div class="bs-stepper-header">
                                <div class="step active" data-target="#account-details-modern-vertical">
                                    <button type="button" class="step-trigger" aria-selected="true">
                                        <span class="bs-stepper-circle">1</span>
                                        <span class="bs-stepper-label">
                                            <span class="bs-stepper-title">Account Details</span>
                                            <span class="bs-stepper-subtitle">Setup Account Details</span>
                                        </span>
                                    </button>
                                </div>
                                <div class="line"></div>
                                <div class="step" data-target="#personal-info-modern-vertical">
                                    <button type="button" class="step-trigger" aria-selected="false">
                                        <span class="bs-stepper-circle">2</span>
                                        <span class="bs-stepper-label">
                                            <span class="bs-stepper-title">Personal Info</span>
                                            <span class="bs-stepper-subtitle">Add personal info</span>
                                        </span>
                                    </button>
                                </div>
                                <div class="line"></div>
                                <div class="step" data-target="#social-links-modern-vertical">
                                    <button type="button" class="step-trigger" aria-selected="false">
                                        <span class="bs-stepper-circle">3</span>
                                        <span class="bs-stepper-label">
                                            <span class="bs-stepper-title">Social Links</span>
                                            <span class="bs-stepper-subtitle">Add social links</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                            <div class="bs-stepper-content">
                                <form onsubmit="return false">
                                    <!-- Account Details -->
                                    <div id="account-details-modern-vertical" class="content dstepper-block active">
                                        <div class="content-header mb-4">
                                            <h6 class="mb-0">Account Details</h6>
                                            <small>Enter Your Account Details.</small>
                                        </div>
                                        <div class="row g-6">
                                            <div class="col-sm-6">
                                                <label class="form-label" for="username-modern-vertical">Username</label>
                                                <input type="text" id="username-modern-vertical" class="form-control" placeholder="johndoe">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="email-modern-vertical">Email</label>
                                                <input type="email" id="email-modern-vertical" class="form-control" placeholder="john.doe@email.com" aria-label="john.doe">
                                            </div>
                                            <div class="col-sm-6 form-password-toggle">
                                                <label class="form-label" for="password-modern-vertical">Password</label>
                                                <div class="input-group input-group-merge">
                                                    <input type="password" id="password-modern-vertical" class="form-control" placeholder="············" aria-describedby="password2-modern-vertical">
                                                    <span class="input-group-text cursor-pointer" id="password2-modern-vertical"><i class="bx bx-hide"></i></span>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 form-password-toggle">
                                                <label class="form-label" for="confirm-password-modern-vertical">Confirm Password</label>
                                                <div class="input-group input-group-merge">
                                                    <input type="password" id="confirm-password-modern-vertical" class="form-control" placeholder="············" aria-describedby="confirm-password-modern-vertical2">
                                                    <span class="input-group-text cursor-pointer" id="confirm-password-modern-vertical2"><i class="bx bx-hide"></i></span>
                                                </div>
                                            </div>
                                            <div class="col-12 d-flex justify-content-between">
                                                <button class="btn btn-label-secondary btn-prev" disabled="">
                                                    <i class="bx bx-left-arrow-alt bx-sm ms-sm-n2 me-sm-2"></i>
                                                    <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                                </button>
                                                <button class="btn btn-primary btn-next">
                                                    <span class="align-middle d-sm-inline-block d-none me-sm-2">Next</span>
                                                    <i class="bx bx-chevron-right bx-sm me-sm-n2"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Personal Info -->
                                    <div id="personal-info-modern-vertical" class="content dstepper-block">
                                        <div class="content-header mb-4">
                                            <h6 class="mb-0">Personal Info</h6>
                                            <small>Enter Your Personal Info.</small>
                                        </div>
                                        <div class="row g-6">
                                            <div class="col-sm-6">
                                                <label class="form-label" for="first-name-modern-vertical">First Name</label>
                                                <input type="text" id="first-name-modern-vertical" class="form-control" placeholder="John">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="last-name-modern-vertical">Last Name</label>
                                                <input type="text" id="last-name-modern-vertical" class="form-control" placeholder="Doe">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="country-modern-vertical">Country</label>
                                                <div class="position-relative">
                                                    <div class="position-relative"><select class="select2 select2-hidden-accessible" id="country-modern-vertical" tabindex="-1" aria-hidden="true" data-select2-id="country-modern-vertical">
                                                            <option label=" " data-select2-id="54"></option>
                                                            <option>UK</option>
                                                            <option>USA</option>
                                                            <option>Spain</option>
                                                            <option>France</option>
                                                            <option>Italy</option>
                                                            <option>Australia</option>
                                                        </select><span class="select2 select2-container select2-container--default" dir="ltr" data-select2-id="53" style="width: auto;"><span class="selection"><span class="select2-selection select2-selection--single" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-country-modern-vertical-container"><span class="select2-selection__rendered" id="select2-country-modern-vertical-container" role="textbox" aria-readonly="true"><span class="select2-selection__placeholder">Select value</span></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span></div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="language-modern-vertical">Language</label>
                                                <div class="dropdown bootstrap-select show-tick w-auto"><select class="selectpicker w-auto" id="language-modern-vertical" data-style="btn-transparent" data-icon-base="bx" data-tick-icon="bx-check text-white" multiple="">
                                                        <option>English</option>
                                                        <option>French</option>
                                                        <option>Spanish</option>
                                                    </select><button type="button" tabindex="-1" class="btn dropdown-toggle bs-placeholder btn-transparent" data-bs-toggle="dropdown" role="combobox" aria-owns="bs-select-5" aria-haspopup="listbox" aria-expanded="false" title="Nothing selected" data-id="language-modern-vertical">
                                                        <div class="filter-option">
                                                            <div class="filter-option-inner">
                                                                <div class="filter-option-inner-inner">Nothing selected</div>
                                                            </div>
                                                        </div>
                                                    </button>
                                                    <div class="dropdown-menu ">
                                                        <div class="inner show" role="listbox" id="bs-select-5" tabindex="-1" aria-multiselectable="true">
                                                            <ul class="dropdown-menu inner show" role="presentation"></ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-12 d-flex justify-content-between">
                                                <button class="btn btn-primary btn-prev">
                                                    <i class="bx bx-left-arrow-alt bx-sm ms-sm-n2 me-sm-2"></i>
                                                    <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                                </button>
                                                <button class="btn btn-primary btn-next">
                                                    <span class="align-middle d-sm-inline-block d-none me-sm-2">Next</span>
                                                    <i class="bx bx-chevron-right bx-sm me-sm-n2"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Social Links -->
                                    <div id="social-links-modern-vertical" class="content">
                                        <div class="content-header mb-4">
                                            <h6 class="mb-0">Social Links</h6>
                                            <small>Enter Your Social Links.</small>
                                        </div>
                                        <div class="row g-6">
                                            <div class="col-sm-6">
                                                <label class="form-label" for="twitter-modern-vertical">Twitter</label>
                                                <input type="text" id="twitter-modern-vertical" class="form-control" placeholder="https://twitter.com/abc">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="facebook-modern-vertical">Facebook</label>
                                                <input type="text" id="facebook-modern-vertical" class="form-control" placeholder="https://facebook.com/abc">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="google-modern-vertical">Google+</label>
                                                <input type="text" id="google-modern-vertical" class="form-control" placeholder="https://plus.google.com/abc">
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="form-label" for="linkedin-modern-vertical">LinkedIn</label>
                                                <input type="text" id="linkedin-modern-vertical" class="form-control" placeholder="https://linkedin.com/abc">
                                            </div>
                                            <div class="col-12 d-flex justify-content-between">
                                                <button class="btn btn-primary btn-prev">
                                                    <i class="bx bx-left-arrow-alt bx-sm ms-sm-n2 me-sm-2"></i>
                                                    <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                                </button>
                                                <button class="btn btn-success btn-submit">Submit</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>

            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->


    <!-- Core JS -->
    <!-- build:js assets/vendor_template/js/core.js -->
    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/select2/select2.min.js"></script>
    <!-- endbuild -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/vendor/fattos/alert.js"></script>

</body>

</html>