<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Leads</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/lekat.svg"/>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <!-- Page CSS -->

    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container, .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }
    </style>

    <script src="assets/js/config.js"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container control-dark-mode dark-mode light-mode">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y">
                        <div class="card mb-3" >
                            <div class="card-header">
                                <h5 class="text-center">LEADS DO SITE</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive scrollbar">
                                    <table class="table table-sm table-bordered table-striped mb-0">
                                        <thead class="bg-200 text-900">
                                            <tr>
                                                <th class="sort white-space-nowrap">Nome</th>
                                                <th class="sort white-space-nowrap">E-mail</th>
                                                <th class="sort white-space-nowrap">Contato</th>
                                                <th class="sort white-space-nowrap">Produto(s)</th>
                                                <th class="sort white-space-nowrap">Vendedor(a)</th>
                                                <th class="sort white-space-nowrap">Origem</th>
                                                <th class="sort white-space-nowrap">URL</th>
                                                <th class="sort white-space-nowrap text-center">Cadastrado em</th>
                                            </tr>
                                        </thead>
                                        <?php $leads = new App\Core\APISite;?>

                                        <tbody class="list" id="table-orders-body">
                                            <?php

                                            foreach ($leads->getOrcamentos() as $key => $value): 

                                                $nome = isset($value['_nome']) ? $value['_nome'] : 'N/A';
                                                $email = isset($value['_email']) ? $value['_email'] : 'N/A';
                                                $vendedor = isset($value['colaborador']) ? $value['colaborador'] : 'N/A';
                                                $tel = isset($value['_telefone']) ? $value['_telefone'] : 'N/A';
                                                $createdAt = isset($value['_createdDate']) ? (new DateTime($value['_createdDate']))->modify('-3 hours')->format('d/m/Y H:i') : 'N/A';
                                                $pagePath = isset($value['_page_path']) ? substr($value['_page_path'], 0, 15) : 'N/A';
                                                $regiao = isset($value['regiao']) ? $value['regiao'] : 'N/A';

                                                $leadInfo = 'ORGÂNICO';

                                                if (!empty($value['_utm_term']) && !empty($value['_utm_source'])) {
                                                    $leadInfo = $value['_utm_source'] . ' - ' . $value['_utm_term'];
                                                    $leadInfo = strtoupper(str_replace('_', ' ', $leadInfo));
                                                } 

                                                $blur = '';
                                                // se for vendedor, só exibe certo os leads dele, senão randomiza o email, telefone e nome e adiciona outra variavel com filter blur 1px
                                                if ( ($value['id_vendedor_FK'] != $_SESSION['user']['id']) && ($_SESSION['user']['nivel'] != 8 && $_SESSION['user']['nivel'] != 9 && $_SESSION['user']['nivel'] != 3)) {
                                                    $email = substr(md5(rand()), 0, 10) . '@example.com';
                                                    $tel = '(47) 9 9999-9999';
                                                    $blur = 'style="filter: blur(2.5px)"';
                                                }

                                            ?>
                                            <tr>
                                                <td class="py-2 align-middle fs-0 fw-medium"><?= mb_convert_case(mb_strtolower($nome), MB_CASE_TITLE, "UTF-8") ?></td>
                                                <td class="py-2 align-middle fs-0 fw-medium" <?= $blur ?> ><?= mb_strtolower($email) ?></td>
                                                <td class="py-2 align-middle fs-0 fw-medium" <?= $blur ?> ><?= $tel ?> </td>
                                                <td class="py-2 align-middle fs-0 fw-medium">
                                                    <button class="btn btn-sm btn-label-primary" onclick="visualizaProdutos(<?= $value['id'] ?>)">Visualizar</button>
                                                </td>
                                                <td class="py-2 align-middle fs-0 fw-medium"><?= $vendedor ?></td>
                                                <td class="py-2 align-middle fs-0 fw-medium"><small><?= $leadInfo ?></small></td>
                                                <td class="py-2 align-middle fs-0 fw-medium"><small><?= $pagePath ?></small></td>
                                                <td class="py-2 align-middle text-center fs-0 fw-medium"><?= $createdAt ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>

            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <div class="modal fade" id="modal-visualiza-produto-solicitado" role="dialog" aria-labelledby="modalEntradaEstoqueTitle" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title">Produtos de interesse do cliente</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered table-striped mb-0">
                            <thead class="bg-200 text-900">
                                <tr>
                                    <th>#</th>
                                    <th>Cód.</th>
                                    <th>Produto</th>
                                    <th>Qtd.</th>
                                </tr>
                            </thead>
                            <tbody class="list" id="modal-visualiza-produto-solicitado-tbody">
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-label-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>



    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/jquery-mask/jquery-mask-update.min.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/vendor/fattos/alert.js"></script>

    <script>
        const path_core = '../app/Core/';

        function copyToClipboard(copyText) {
            navigator.clipboard.writeText(copyText);
            fat_alert({
                type: 'dark',
                title: 'Texto copiado',
                message: copyText,
                timer: 2500
            });
        }

        function visualizaProdutos(id) {
            $.ajax({
                type: 'GET',
                dataType: 'JSON',
                url: `${path_core}APISite.php`,
                data: {
                    id: id,
                    action: 'visualizaProdutos'
                },
                success: function(response) {

                    let htmlProdutos = '';
                    for (const key in response) {
                        if (Object.prototype.hasOwnProperty.call(response, key)) {
                            const produto = response[key];

                            htmlProdutos += `
                                <tr>
                                    <td>
                                        <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                            <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-xs pull-up">
                                                <img src='assets/file/product/${produto.foto}' onerror='this.src="assets/file/system/undraw_product.svg"' class='avatar avatar-xs pull-up rounded-circle <?= $class_foto ?>'>
                                            </li>
                                        </ul>
                                    </td>
                                    <td>${produto.id}</td>
                                    <td>${produto.nome}</td>
                                    <td>${produto.qtd}</td>
                                </tr>
                            `;
                        }
                    }
                    $('#modal-visualiza-produto-solicitado-tbody').html(htmlProdutos);

                    $('#modal-visualiza-produto-solicitado').modal('show');
                },
                error: function(xhr) {
                    console.log(xhr);
                }
            })
        }
    </script>
</body>

</html>