<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php';

if (!isset($_SESSION['user'])) {
	header('Location: /');
	exit;
}

// representante comercial (ifez login

if ($_SESSION['user']['nivel'] == 4) {
	header('Location: producao');
}

?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

	<title>Dashboard</title>

	<meta name="description" content="" />

	<!-- Favicon -->
	<link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />

	<!-- Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com" />
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
	<link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

	<!-- Icons. Uncomment required icon fonts -->
	<link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

	<!-- Core CSS -->
	<link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
	<link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
	<link rel="stylesheet" href="assets/css/demo.css" />

	<!-- vendor_templates CSS -->
	<link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />
	<link rel="stylesheet" href="assets/css/home.css" />
	<link rel="stylesheet" href="assets/css/fullcalendar-style.css">
	<style>
		
	</style>
	<!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
	<script src="assets/js/config.js"></script>
</head>

<body>
	<!-- Layout wrapper -->
	<div class="layout-wrapper layout-content-navbar">
		<div class="layout-container control-dark-mode dark-mode light-mode">
			<!-- Menu -->

			<?php include __DIR__ . '/partials/sidebar.php'; ?>
			<!-- / Menu -->

			<!-- Layout container -->
			<div class="layout-page">
				<!-- Navbar -->
				<?php include __DIR__ . '/partials/navbar.php'; ?>

				<!-- / Navbar -->

				<!-- Content wrapper -->
				<div class="content-wrapper">
					<!-- Content -->

					<div class="container-fluid flex-grow-1 container-p-y">
						<div class="alert alert-primary alert-dismissible text-center" role="alert">
							<i class='bx bx-sm bx-bot pb-1' title="FRASE DO BOT AMIGO"></i>: <?= (new App\Core\Frases())->show(); ?>
							<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
						</div>

						<div class="row">
							<div class="col-lg-7 mb-4 order-0">
								<div class="card">
									<div class="card-body">
										<div id='calendar'></div>
									</div>
								</div>
							</div>
							<div class="col">
								<div class="new-statisc">
									<div class="widbox-blak" style="height:100%">
										<div class="new-bottons px-0 pt-0 mt-0"> 
											<div class="card tip-top" title="" data-original-title="Add Clientes e Fornecedores">
												<div><i class="bx bxs-group iconBx"></i></div>
												<div>
													<div class="cardName2" id="setNClientes">Carregando...</div>
													<div class="cardName">Clientes cadastrados</div>
												</div>
											</div> 
											<div class="card tip-top" title="" data-original-title="Adicionar Produtos">
												<div><i class="bx bxs-package iconBx2"></i></div>
												<div>
													<div class="cardName2" id="setNProdutos">Carregando...</div>
													<div class="cardName">Produtos cadastrados</div>
												</div>
											</div> 
											<div class="card tip-top" title="" data-original-title="Adicionar serviços">
												<div><i class="bx bxs-chart iconBx3"></i></div>
												<div>
												<div class="cardName2" id="setMetaPercent" title="130 mil reais"><b class="text-danger">R$ 130.000,00</b></div>
													<div class="cardName">Meta em vendas</div>
												</div>
											</div> 
											<div class="card tip-top" title="" data-original-title="Adicionar OS">
												<div><i class="bx bxs-phone iconBx4"></i></div>
												<div>
													<div class="cardName2" id="setContatos">Carregando...</div>
													<div class="cardName">Contatos realizados</div>
												</div>
											</div> 
											<div class="card tip-top" title="" data-original-title="Adicionar garantia">
												<div><i class="bx bxs-cart-alt iconBx6"></i></div>
												<div>
													<div class="cardName2" id="setNVendas">Carregando...</div>
													<div class="cardName">Vendas realizadas</div>
												</div>
											</div>
											<div class="card tip-top" title="" data-original-title="Adicionar Vendas">
												<div><i class="bx bxs-bank iconBx5"></i></div>
												<div>
													<div class="cardName2" id="setVendas">Carregando...</div>
													<div class="cardName">Total vendido</div>
												</div>
											</div> 
										 </div>
										 <div class="card">
											<div class="card-body">
												<div id="calendarioLembrarMe"></div>
											</div>
										 </div>
									</div>
								</div>
							</div>

						</div>
					</div>
					<!-- / Content -->

					<div class="content-backdrop fade"></div>
				</div>
				<!-- Content wrapper -->
			</div>
			<!-- / Layout page -->
		</div>

		<!-- Overlay -->
		<div class="layout-overlay layout-menu-toggle"></div>
		<input type="hidden" id="user-id-last-access" value="<?= $_SESSION['user']['id'] ?>">
	</div>
	<!-- / Layout wrapper -->

	<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
	<script src="assets/vendor_template/libs/popper/popper.js"></script>
	<script src="assets/vendor_template/js/bootstrap.js"></script>
	<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

	<script src="assets/vendor_template/js/menu.js"></script>
	<!-- endbuild -->

	<script src='assets/vendor/fullcalendar/script.min.js'></script>
	<!-- Main JS -->
	<script src="assets/js/main.js"></script>

	<script>
		const path_core = '../app/Core/';
		const calendarEl = document.getElementById('calendar');

		const calendar = new FullCalendar.Calendar(calendarEl, {
			headerToolbar: {
				left: 'prev,next',
				center: 'title',
				right: 'dayGridMonth,timeGridWeek,timeGridDay'
			},
			buttonText: {
				month: 'Mês',
				week: 'Semana',
				day: 'Dia',
			},
			height: 590,
			locale: 'pt-br',
			eventClick: function(info) {
				console.log(info.event.id);
				viewBudget(info.event.id);
			},
			datesSet: function(dateInfo) {
				$('#calendar').find('.fc-toolbar-title').html('<label class="fs-5 text-center">Status dos orçamentos de<br><b>' + dateInfo.view.title + '</b></label>');

				const data = getInicioFinamMesCalendar(dateInfo);

				getVendasMes(data.firstDayStr, data.lastDayStr);
				getValoresVendidosMes(data.firstDayStr, data.lastDayStr);
				getContatosRealizadosMes(data.firstDayStr, data.lastDayStr);
				
				calendar.removeAllEvents();
				getItems(dateInfo.startStr, dateInfo.endStr);
				scrollToDay()
			},
		});

		function getItems(dataInicio = '', dataFim = '') {

			const sendData = {
				action: 'listaOrcamentosCalendar'
			};

			if (dataInicio && dataFim) {
				sendData.dataInicio = dataInicio;
				sendData.dataFinal = dataFim;
			}

			$.ajax({
				async: false,
				type: 'POST',
				dataType: 'JSON',
				url: `${path_core}Orcamentos.php`,
				data: sendData,
				success: function(data) {
					data.forEach(evento => {
						calendar.addEvent(evento);
					});
				},
				error: function(xhr) {
					console.log(xhr);
				}
			});
		}

		// getItems();

		calendar.render();

		$.ajax({
			type: 'POST',
			dataType: 'JSON',
			url: `${path_core}DashboardIndex.php`,
			data: {
				action: 'countCustomers'
			},
			success: function(qtd) {
				$('#setNClientes').text(qtd)
			},
			error: function(xhr) {
				$('#setNClientes').text('N/A')
			}
		});
		

		$.ajax({
			type: 'POST',
			dataType: 'JSON',
			url: `${path_core}DashboardIndex.php`,
			data: {
				action: 'countProducts'
			},
			success: function (qtd) {
				$('#setNProdutos').text(qtd)
			},
			error: function (xhr) {
				console.log(xhr);
				
				$('#setNProdutos').text('N/A')
			}
		});

		function getVendasMes(dataInicio = '', dataFim = '') {
			const sendData = {
				action: 'countSalesWonCurrentMonth'
			};

			if (dataInicio && dataFim) {
				sendData.dataInicio = dataInicio;
				sendData.dataFinal = dataFim;
			}

			$.ajax({
				type: 'POST',
				dataType: 'JSON',
				url: `${path_core}DashboardIndex.php`,
				data: sendData,
				beforeSend: function () {
					$('#setNVendas').text('Carregando...');
				},
				success: function (qtd) {
					$('#setNVendas').text(qtd ?? 0);
				},
				error: function (xhr) {
					console.log(xhr);
					$('#setNVendas').text('N/A');
				}
			});
		}

		function getValoresVendidosMes(dataInicio = '', dataFim = '') {
			const sendData = {
				action: 'sumValueSalesWonCurrentMonth'
			};

			if (dataInicio && dataFim) {
				sendData.dataInicio = dataInicio;
				sendData.dataFinal = dataFim;
			}

			$.ajax({
				type: 'POST',
				dataType: 'JSON',
				url: `${path_core}DashboardIndex.php`,
				data: sendData,
				beforeSend: function () {
					$('#setVendas').text('Carregando...');
				},
				success: function (valor) {
					$('#setVendas').text(valor.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' }))
				},
				error: function (xhr) {
					console.log(xhr);
					$('#setVendas').text('N/A')
				}
			});
		}

		function getContatosRealizadosMes(dataInicio = '', dataFim = '') {
			const sendData = {
				action: 'countContactsMadeCurrentMonth'
			};

			if (dataInicio && dataFim) {
				sendData.dataInicio = dataInicio;
				sendData.dataFinal = dataFim;
			}

			$.ajax({
				type: 'POST',
				dataType: 'JSON',
				url: `${path_core}DashboardIndex.php`,
				data: sendData,
				beforeSend: function () {
					$('#setContatos').text('Carregando...');
				},
				success: function (qtd) {
					$('#setContatos').text(qtd);
				},
				error: function (xhr) {
					console.log(xhr);
					$('#setContatos').text('N/A');
				}
			});
		}

		function getInicioFinamMesCalendar(dateInfo){
			// Converte startStr e endStr para objetos Date
			const startDate = new Date(dateInfo.startStr);
			const endDate = new Date(dateInfo.endStr);

			// Determina o mês e o ano do intervalo principal
			let month, year;
			if (startDate.getMonth() === endDate.getMonth()) {
				// O intervalo está dentro do mesmo mês
				month = startDate.getMonth();
				year = startDate.getFullYear();
			} else {
				// O intervalo cobre mais de um mês, foca no mês completo mais próximo ao início
				// Se o dia de início é maior que 15, foca no próximo mês, senão foca no mês atual
				if (startDate.getDate() > 15) {
					const nextMonth = new Date(startDate.getFullYear(), startDate.getMonth() + 1, 1);
					month = nextMonth.getMonth();
					year = nextMonth.getFullYear();
				} else {
					month = startDate.getMonth();
					year = startDate.getFullYear();
				}
			}

			// Calcula o primeiro e o último dia do mês focado
			const firstDayOfMonth = new Date(year, month, 1);
			const lastDayOfMonth = new Date(year, month + 1, 0);

			// Formata as datas para strings no formato YYYY-MM-DD
			const firstDayStr = firstDayOfMonth.toISOString().split('T')[0];
			const lastDayStr = lastDayOfMonth.toISOString().split('T')[0];

			return { firstDayStr, lastDayStr };
		}
		

		// LEMBRAR-ME SECTION

		const calendarioLembrarMeElem = document.getElementById('calendarioLembrarMe');

		const calendarLembrarMe = new FullCalendar.Calendar(calendarioLembrarMeElem, {
			headerToolbar: {
				left: 'prev,next',
				center: 'title',
				right: 'dayGridMonth,timeGridWeek,timeGridDay'
			},
			buttonText: {
				month: 'Mês',
				week: 'Semana',
				day: 'Dia',
			},
			height: 395,
			locale: 'pt-br',
			eventClick: function(info) {
				atualizaStatusContato(info.event.id);
			},
			datesSet: function(dateInfo) {
				$('#calendarioLembrarMe').find('.fc-toolbar-title').html('<label class="fs-6 text-center">Contatos para retornar em<br><b>' + dateInfo.view.title + '</b></label>');

				scrollToDay();
			}
		});

		function getItemsLembrarMe() {
			$.ajax({
				async: false,
				type: 'POST',
				dataType: 'JSON',
				url: `${path_core}Contact.php`,
				data: {
					action: 'getContatosParaRetornarCalendar'
				},
				success: function(data) {
					data.forEach(evento => {
						calendarLembrarMe.addEvent(evento);
					});
				},
				error: function(xhr) {
					console.log(xhr);
				}
			});
		}
		getItemsLembrarMe();
		calendarLembrarMe.render();

		function atualizaStatusContato(idContato) {
			let event = calendarLembrarMe.getEventById(idContato);

			let status = 0;

			if (event) { // Verifica se o evento existe
				if (event.backgroundColor === '#91030a') {
					status = 1;
					event.setProp('backgroundColor', '#206e09');
					fat_alert({
						type: 'success',
						title: 'Sucesso!!!',
						message: 'Contato ao cliente foi retornado com sucesso!',
						timer: 3000
					});
				} else if (event.backgroundColor === '#206e09') {
					event.setProp('backgroundColor', '#91030a');
					fat_alert({
						type: 'secondary',
						title: 'Status atualizado',
						message: 'Contato para retornar ao cliente!',
						timer: 3000
					});
				}
			}

			$.ajax({
				type: 'POST',
				dataType: 'JSON',
				url: `${path_core}Contact.php`,
				data: {
					action: 'atualizaStatusContatoRetorno',
					idContato: idContato,
					status: status
				},
				success: function(data) {
					console.log(data);
				},
				error: function(xhr) {
					console.log(xhr);
				}
			
			})
		}

		function scrollToDay() {
			const day = (new Date()).getDate();

			let qtdValorAjustado = 0;

			if (day <= 10) {
				qtdValorAjustado = - 250;
			} else if (day > 10 && day <= 18) {
				qtdValorAjustado = 0;
			} else {
				qtdValorAjustado = 250;
			}


			$('.fc-scroller').animate({
				scrollTop: $('.fc-day-today').offset().top + qtdValorAjustado // Ajuste o valor para posicionar melhor o elemento na tela
			}, 1000); // 500ms para a rolagem suave
		}

	</script>
</body>
</html>
