<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>


<!DOCTYPE html>

<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$filter = $_GET['filter'] ?? '';

?>
<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Clientes</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <!-- <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" /> -->


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>

    <link rel="stylesheet" type="text/css" href="assets/vendor/daterangepicker/css.min.css" />
    <!-- Helpers -->
    <script src="assets/vendor_template/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div id="body-customer" class="content-wrapper">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div id="card-customer" class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                    <div class="card-header d-flex justify-content-between">
                        <?php if($_SESSION['user']['nivel'] != 3): ?> 
                        <div class="d-flex gap-3">
                            <button 
                                data-bs-toggle="modal" 
                                data-bs-target="#modal-new-customer" 
                                id="id-modal-new-customer" 
                                class="btn btn-sm btn-primary"
                                title="Cadastrar novo cliente" 
                            >
                                <i class="bx bx-plus"></i> 
                                Novo cliente
                            </button>

                            <?php if($_SESSION['user']['nivel'] == 9): ?> 
                                <button 
                                    data-bs-toggle="modal" 
                                    data-bs-target="#modal-transferir-clientes" 
                                    class="btn btn-sm btn-primary"
                                    title="Transferir clientes" 
                                >
                                    <i class="bx bx-transfer"></i> 
                                    Transferir clientes
                                </button>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>

                        
                        <div class="gap-2 d-flex">
                            <div class="d-flex h-px-30">
                                <input 
                                    class="form-control daterange" 
                                    type="text" 
                                    id="filter-range-data-criacao" 
                                    style="height: 34px;"
                                    v-model="dateRangeFilter"
                                    value=""
                                    title="Filtrar por invertalo de data de criação"
                                    data-bs-toggle="tooltip"
                                >
                            </div>
                            <div class="d-flex position-relative">
                                <label class="me-1"></label>
                                <select class="form-select select-vendedores w-px-170" id="select-filter-vendedor">
                                    <option value="">Carregando...</option>
                                </select>
                                <span data-feature="2024-09-23" class="badge badge-flutuant position-absolute start-80 top-0 bg-label-danger translate-middle pulse-font-size-07">
                                    <u>Novidade!</u>
                                </span>
                            </div>
                            <div class="d-flex position-relative">
                                <label class="me-1"></label>
                                <select class="form-select select-origens w-px-170" id="select-filter-origem">
                                    <option value="">Carregando...</option>
                                </select>
                                <span data-feature="2024-09-23" class="badge badge-flutuant position-absolute start-80 top-0 bg-label-danger translate-middle pulse-font-size-07">
                                    <u>Novidade!</u>
                                </span>
                            </div>
                            <!-- <div class="d-flex">
                                <input style="height: 32px; border-radius: 0.375rem" title="Filtrar por último contato" data-bs-toggle="tooltip" placeholder="Filtrar por data" class="form-control" type="text" id="daterange">
                            </div> -->
                            <div class="d-flex">
                                <input 
                                    autofocus
                                    class="form-control me-1 w-px-170" 
                                    type="text" 
                                    value="<?= $filter ?>" 
                                    id="text-filter-customer" 
                                    placeholder="Buscar..."
                                >
                                <button class="btn btn-sm btn-primary" id="btn-filter-customer">Buscar</button>
                            </div>
                        </div>
                    </div>

                        <?php
                        $user = new App\Core\Customer();

                        $current_page = isset($_GET['page']) ? $_GET['page'] : 1;
                        $limit_per_page = 10;

                        $paginate_views_customer = $user->show($current_page, $limit_per_page, $filter);
                        ?>
                        <div class="table-responsive text-nowrap">
                            <table class="table table-sm">
                                <thead class="sticky-top">
                                <tr>
                                    <th>#</th>
                                    <th>Nome</th>
                                    <th class="text-center">Relacionamento</th>
                                    <th>Último contato</th>
                                    <th>Vendedor(a)</th>
                                    <th>E-mail</th>
                                    <th>CPF/CNPJ</th>
                                    <th>Telefone</th>
                                    <th>Celular</th>
                                    <th>Origem</th>
                                    <th>Data de cadastro</th>
                                    <th class="text-center  control-dark-mode-solid dark-mode-solid light-mode-solid" style="right: 86px !important;">Status</th>
                                    <?php if($_SESSION['user']['nivel'] != 3): ?> 
                                    <th class="text-center dtfc-fixed-right control-dark-mode-solid dark-mode-solid light-mode-solid" data-button-index-option
                                        style="">Ações
                                    </th>
                                    <?php endif; ?>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                <?php foreach ($paginate_views_customer['data'] as $key => $value):
                                    $status = $value['status'] == 1 ? 'ativo' : 'inativo';
                                    $status_class = $value['status'] == 1 ? 'bg-label-primary' : 'bg-label-danger';

                                    $name_user = '"' . $value['nome'] . '"';

                                    $btn_toggle_status = '';
                                    
                                    if ($_SESSION['user']['nivel'] > 8) {
                                        $btn_toggle_status = $value['status'] == 1
                                            ? "<a class='dropdown-item' onclick='modalShowStatusCustomer({$value['id']}, {$value['status']}, {$name_user})'><i class='bx bx-user-x  me-1'></i>Inativar</a>"
                                            : "<a class='dropdown-item' type='button' onclick='modalShowStatusCustomer({$value['id']}, {$value['status']}, {$name_user})'><i class='bx bx-user-check  me-1'></i>Reativar</a>";
                                    }

                                    ?>
                                    <tr>
                                        <td>
                                            <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                                <li data-bs-toggle="tooltip" data-popup="tooltip-custom"
                                                    data-bs-placement="top" class="avatar avatar-xs pull-up">
                                                    <img src="assets/file/customer/<?= $value['logo'] ?>" onclick="showImage(this.src)"
                                                         onerror='this.src="assets/file/system/undraw_profile.svg"'
                                                         alt="Avatar" class="rounded-circle"/>
                                                </li>
                                            </ul>
                                        </td>
                                        <td><?= $value['nome'] ?></td>
                                        <td class="text-center c-p">
                                            <div class="fs-80p d-flex" onclick="viewTimelineCliente(<?= $value['id'] ?>)" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Visualizar timeline (Contatos e Orçamentos)">
                                                <label class="text-decoration-underline c-p">
                                                    Visualizar
                                                </label>
                                                <div class="ms-1 text-muted w-px-30 c-p" data-bs-toggle="tooltip" data-bs-placement="top" title="Número de contatos realizados">
                                                    <i class='bx bx-phone'></i>
                                                    <label data-id-cliente-render-contato="<?= $value['id'] ?>"></label>
                                                </div>
                                                <div class="ms-1 text-muted c-p" data-bs-toggle="tooltip" data-bs-placement="top" title="Número de orçamentos realizados">
                                                    <i class='bx bx-money'></i>
                                                    <label data-id-cliente-render-orcamento="<?= $value['id'] ?>"></label>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <label class="render-ultimo-contato" data-cliente-id="<?= $value['id'] ?>">
                                                <i class='bx bx-loader-alt spinner-loader'></i>
                                            </label>
                                        </td>
                                        <td><small><?= $value['vendedor'] ?></small></td>
                                        <td><?= $value['email'] ?></td>
                                        <td><?= $value['cpf_cnpj'] ?></td>
                                        <td><small><?= $value['telefone'] ?></small></td>
                                        <td><small><?= $value['celular'] ?></small></td>
                                        <td><small><?= $value['origem_name'] ?></small></td>
                                        <td><small><?= $value['created_at'] ?></small></td>
                                        <td class="text-center control-dark-mode-solid dark-mode-solid light-mode-solid" style="right: 86px !important;"><span
                                                class="badge <?= $status_class ?> me-1"><?= $status ?></span></td>
                                        <?php if($_SESSION['user']['nivel'] != 3 && ($_SESSION['user']['id']) == $value['created_by'] || $_SESSION['user']['nivel'] > 7){ ?> 
                                        <td class="text-center  dtfc-fixed-right control-dark-mode-solid dark-mode-solid light-mode-solid" data-button-index-option>
                                            <div class="dropdown dropstart">
                                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                        data-bs-toggle="dropdown">
                                                    <i class="bx bx-dots-vertical-rounded"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item"
                                                       onclick="openModalUpdateCustomer('<?= $value['id'] ?>')"
                                                       href="javascript:void(0);"><i class="bx bx-edit-alt me-1"></i>Editar
                                                    </a>
                                                    <?= $btn_toggle_status ?>
                                                </div>
                                            </div>
                                        </td>
                                        <?php } else { echo "<td></td>"; } ?>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                            <?php
                            echo '<div class="dynamic-pagination col text-center my-3">' . $paginate_views_customer['pages'] . '</div>';
                            ?>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/customer/modal_create_customer.html';
include __DIR__ . '/partials/modal/customer/modal_transfere_cliente.html';
include __DIR__ . '/partials/modal/customer/modal_edit_customer.html';
include __DIR__ . '/partials/modal/customer/modal_enable_disable_user.html';
include __DIR__ . '/partials/modal/modal_show_image.html';
?>
<!-- / Modals -->


<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor_template/js/menu.js"></script>
<script src="assets/vendor/moment/moment-with-all-locales.min.js"></script>
<!-- endbuild -->
<script src="assets/vendor/daterangepicker/script.min.js"></script>


<!-- Main JS -->
<script src="assets/js/main.js"></script>

<!-- Page JS -->
<script src="assets/js/customer.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>


<script>

const urlSearchParam = new URLSearchParams(window.location.search);

var minDateFilter = urlSearchParam.get('startDate') ? moment(urlSearchParam.get('startDate'), 'YYYY-MM-DD') : moment('2023-01-01', 'YYYY-MM-DD');
var maxDateFilter = urlSearchParam.get('endDate') ? moment(urlSearchParam.get('endDate'), 'YYYY-MM-DD') : moment();

$("#filter-range-data-criacao").daterangepicker({
    locale: {
        "format": 'DD/MM/YYYY',
        "applyLabel": 'Confirmar',
        "cancelLabel": 'Cancelar',
        "customRangeLabel": 'Personalizado', 
        "daysOfWeek": [
            "Dom",
            "Seg",
            "Ter",
            "Qua",
            "Qui",
            "Sex",
            "Sab"
        ],
        "monthNames": [
            "Jan",
            "Fev",
            "Mar",
            "Abr",
            "Mai",
            "Jun",
            "Jul",
            "Ago",
            "Set",
            "Out",
            "Nov",
            "Dez"
        ],
        "firstDay" : 0
    },
    startDate: minDateFilter, // Define a data de início como 01/01/2023
    endDate: maxDateFilter, // Define a data de término como hoje
    ranges: {
        'Todo o período': [moment('2023-01-01', 'YYYY-MM-DD'), moment()],
        'Hoje': [moment(), moment()],
        'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Últimos 7 dias': [moment().subtract(6, 'days'), moment()],
        'Últimos 30 dias': [moment().subtract(29, 'days'), moment()],
        'Este mês': [moment().startOf('month'), moment().endOf('month')],
        'Último mês': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
});

$("#filter-range-data-criacao").on("apply.daterangepicker", function(ev, picker) {
    minDateFilter = picker.startDate;
    maxDateFilter = picker.endDate;
});
    function removeSpanFeatureApos(qtdDias = 20) {

        $('span[data-feature]').each(function () {
            const data = $(this).data('feature');
            const dataAtual = new Date();
            const dataInicial = new Date(data);

            const diff = Math.abs(dataAtual - dataInicial);
            const diffDays = Math.ceil(diff / (1000 * 60 * 60 * 24));

            if (diffDays > qtdDias) {
                $(this).remove();
            }
        });
    } removeSpanFeatureApos();

    const urlParams = new URLSearchParams(window.location.search);

    function filtrarClientefunction () {
        const text = $('#text-filter-customer').val();
        const vendedor = $('#select-filter-vendedor').val();
        const origem = $('#select-filter-origem').val();
        const startDate = minDateFilter.format('YYYY-MM-DD');
        const endDate = maxDateFilter.format('YYYY-MM-DD');

        let currentURL = window.location.href;

        currentURL = currentURL.replace(/(\?|&)page=[^&]*/, '');
        currentURL = currentURL.replace(/(\?|&)filter=[^&]*/, '');
        currentURL = currentURL.replace(/(\?|&)vendedor=[^&]*/, '');
        currentURL = currentURL.replace(/(\?|&)origem=[^&]*/, '');
        currentURL = currentURL.replace(/(\?|&)startDate=[^&]*/, '');
        currentURL = currentURL.replace(/(\?|&)endDate=[^&]*/, '');
        currentURL = currentURL.replace(/[?&]$/, '');

        currentURL += `?page=1`;

        if (text) {
            currentURL += `&filter=${text}`;
        }

        if (vendedor) {
            currentURL += `&vendedor=${vendedor}`;
        }

        if (origem) {
            currentURL += `&origem=${origem}`;
        }

        if (startDate) {
            currentURL += `&startDate=${startDate}`;
        }

        if (endDate) {
            currentURL += `&endDate=${endDate}`;
        }

        // Redirecione para a nova URL
        window.location.href = currentURL;
    }


    $('#btn-filter-customer').on('click', filtrarClientefunction);

    $('#text-filter-customer').keypress(function(event) {
        if (event.which === 13) {

            filtrarClientefunction();
        }
    });

    function viewTimelineCliente(idCliente) {
        window.location.href = `timeline.php?clienteId=${idCliente}`;
    }
    
    function renderQtdContatosPorCliente() {
        let idsClientes = [];

        $('[data-id-cliente-render-contato]').each(function () {
            idsClientes.push($(this).data('id-cliente-render-contato'));
        });

        $.ajax({
            url: `${path_core}Contact.php`,
            dataType: 'JSON',
            type: 'POST',
            data: {
                action: 'getQtdContatosClientes',
                ids: idsClientes
            },
            success: function (data) {
                data.forEach(function (item) {
                    var index = idsClientes.indexOf(item.cliente);
                    if (index !== -1) {
                        idsClientes.splice(index, 1);
                    }

                    $(`[data-id-cliente-render-contato="${item.cliente}"]`).html(`${item.qtd}`);
                });

                idsClientes.forEach(function (id) {
                    $(`[data-id-cliente-render-contato="${id}"]`).html('0');
                });
            }
        });
    }
    renderQtdContatosPorCliente();

    function renderQtdOrcamentosPorCliente() {
        let idsClientes = [];

        $('[data-id-cliente-render-orcamento]').each(function () {
            idsClientes.push($(this).data('id-cliente-render-orcamento'));
        });

        $.ajax({
            url: `${path_core}Orcamentos.php`,
            dataType: 'JSON',
            type: 'POST',
            data: {
                action: 'getQtdOrcamentosClientes',
                ids: idsClientes
            },
            success: function (data) {
                data.forEach(function (item) {
                    var index = idsClientes.indexOf(item.id_cliente_FK);
                    if (index !== -1) {
                        idsClientes.splice(index, 1);
                    }

                    $(`[data-id-cliente-render-orcamento="${item.id_cliente_FK}"]`).html(`${item.qtd}`);
                });

                idsClientes.forEach(function (id) {
                    $(`[data-id-cliente-render-orcamento="${id}"]`).html('0');
                });
            }
        });
    }
    renderQtdOrcamentosPorCliente();

    function obtemUltimoContatoCliente() {
        let clientesId = new Set();

        $('.render-ultimo-contato').each(function () {
            clientesId.add($(this).data('cliente-id').toString());
        });

        $.ajax({
            url: `${path_core}Contact.php`,
            dataType: 'JSON',
            type: 'POST',
            data: {
                action: 'getUltimoContatoClientes',
                ids: Array.from(clientesId)
            },
            success: function (data) {
                data.forEach(function (item) {
                    $(`.render-ultimo-contato[data-cliente-id="${item.idCliente}"]`).html(`<small>${item.create_at}</small>`);
                    clientesId.delete(item.idCliente.toString());
                });

                // Após a iteração, limpa os elementos que não tiveram a última interação
                clientesId.forEach(function (id) {
                    $(`.render-ultimo-contato[data-cliente-id="${id}"]`).empty();
                });
            },
            error: function (error) {
                console.log(error);
            }
        });
    }
    obtemUltimoContatoCliente();

    var allUsers = [];
    function getUsuarios() {
            $.ajax({
            method: 'GET',
            url: `${path_core}User.php?action=getUsers`,
            dataType: 'JSON',
            success: (data) => {
                let html = '<option value="">Nenhum selecionado</option>';

                data.forEach((user) => {
                    html += `<option value="${user.id}">${user.nome}</option>`;
                });

                allUsers = data;

                populaSelectVendedores(data);
                $('.select-users').html(html);
            },
            error: (xhr) => {
                console.log(xhr);
            }
        });
    }
    getUsuarios();

    function populaSelectVendedores(usuarios) {
        let html = '<option value="">Todos os vendedores</option>';

        usuarios.forEach((user) => {
            if (user.tester) {
                return;
            }

            html += `<option value="${user.id}">${user.nome}</option>`;
        });

        $('.select-vendedores').html(html);

        const vendedor = urlParams.get('vendedor');

        if (vendedor) {
            $('#select-filter-vendedor').val(vendedor);
        }
    }

    $.ajax({
        type: 'GET',
        dataType: 'JSON',
        url: `${path_core}Categorias.php?action=reorganizaCategorias`,
        success: function (data) {
            let html = '<option value="">Todas as origens</option>';

            for (let key in data) {
                if (data.hasOwnProperty(key)) {
                    html += `<optgroup label="${key}">`;

                    for (let el in data[key]) {
                        html += `<option value='${el}'>${data[key][el]}</option>`;
                    }

                    html += `</optgroup>`;
                }
            }

            $('.select-origens').html(html);

            const origem = urlParams.get('origem');

            if (origem) {
                $('#select-filter-origem').val(origem);
            }
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });


    $('#select-vendedor-de').on('change', function() {
        const idUsuario = $(this).val();

        if (!idUsuario) {
            return;
        }

        $.ajax({
            method: 'GET',
            url: `${path_core}Customer.php?action=countCustomersByUser&idUsuario=${idUsuario}`,
            dataType: 'JSON',
            success: (qtd) => {
                $('#setQtdClientesParaTransferir').text(`Ao todo, ${qtd} clientes serão transferidos.`);
            },
            error: (xhr) => {
                console.log(xhr);
            }
        });
    });

    $('#checkboxCienteTransferencia').on('change', function() {
        if ($(this).is(':checked')) {
            $('#btn-transferir-clientes').prop('disabled', false);
            return;
        } 

        $('#btn-transferir-clientes').prop('disabled', true);
    });

    $('#btn-transferir-clientes').on('click', function() {
        const idUsuario = $('#select-vendedor-de').val();
        const idUsuarioPara = $('#select-vendedor-para').val();
        const transferirLeads = $('#checkboxLeadsTransferencia').is(':checked') ? 1 : 0;

        if (!idUsuario || !idUsuarioPara) {
            fat_alert({
                title: 'Atenção',
                message: 'Selecione os vendedores para transferir os clientes.',
                type: 'warning'
            });

            return;
        }

        $(this).prop('disabled', true);
        
        $.ajax({
            method: 'POST',
            url: `${path_core}Customer.php`,
            data: {
                action: 'transferirClientes',
                idUsuarioDe: idUsuario,
                idUsuarioPara: idUsuarioPara,
                transferirLeads: transferirLeads
            },
            success: (data) => {
                fat_alert({
                    title: 'Sucesso',
                    message: 'Clientes transferidos com sucesso.',
                    type: 'success'
                });

                setTimeout(() => {
                    location.reload();
                }, 1000);
            },
            error: (xhr) => {
                console.log(xhr);
            }
        });
    });

    // var minDateFilter = "";
    // var maxDateFilter = "";
    
    // $("#daterange").daterangepicker({
    //     startDate: moment('2024-01-01'),
    //     endDate: moment(),
    //     locale: {
    //         "format": 'DD/MM/YYYY',
    //         "applyLabel": 'Confirmar',
    //         "cancelLabel": 'Cancelar',
    //         "customRangeLabel": 'Personalizado',
    //         "daysOfWeek": [
    //             "Dom",
    //             "Seg",
    //             "Ter",
    //             "Qua",
    //             "Qui",
    //             "Sex",
    //             "Sab"
    //         ],
    //         "monthNames": [
    //             "Jan",
    //             "Fev",
    //             "Mar",
    //             "Abr",
    //             "Mai",
    //             "Jun",
    //             "Jul",
    //             "Ago",
    //             "Set",
    //             "Out",
    //             "Nov",
    //             "Dez"
    //         ],
    //         "firstDay": 0
    //     },
    //     ranges: {
    //         'Hoje': [moment(), moment()],
    //         'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
    //         'Últimos 7 Dias': [moment().subtract(6, 'days'), moment()],
    //         'Últimos 30 Dias': [moment().subtract(29, 'days'), moment()],
    //         'Este Mês': [moment().startOf('month'), moment().endOf('month')],
    //         'Último Mês': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
    //         'Este Ano': [moment().startOf('year'), moment().endOf('year')],
    //     }
    // });
    
    // $("#daterange").on("apply.daterangepicker", function(ev, picker) {
    //     minDateFilter = Date.parse(moment(picker.startDate, "DD/MM/YYYY").format("YYYY-MM-DD"));
    //     maxDateFilter = Date.parse(moment(picker.endDate, "DD/MM/YYYY").format("YYYY-MM-DD"));

    //     console.log(minDateFilter, maxDateFilter);
    // }); 


    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });


    $.ajax({
        type: 'GET',
        dataType: 'JSON',
        url: `${path_core}Categorias.php?action=reorganizaCategorias`,
        success: function (data) {
            let html = '<option value="">Nenhum selecionado</option>';

            for (let key in data) {
                if (data.hasOwnProperty(key)) {
                    html += `<optgroup label="${key}">`;

                    for (let el in data[key]) {
                        html += `<option value='${el}'>${data[key][el]}</option>`;
                    }

                    html += `</optgroup>`;
                }
            }

            $('#select-origem-modal-create-customer').html(html);
            $('#select-origem-modal-edit-customer').html(html);
        },
        error: function (xhr) {
            console.log(xhr);
        }
    });
</script>
</body>

</html>