<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>


<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Tarífas</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
          rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>
    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="assets/vendor_template/js/_helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container control-dark-mode dark-mode light-mode">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <?php
                        $costs = new App\Core\Costs;
                        $data = $costs->show();
                        ?>
                        <div class="card-body">
                            <h5>Custos <b>H1</b></h5>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Imposto</label>
                                <div class="col-sm-10">
                                    <input type="hidden" id="input-imposto-old-value" value="<?= $data[0]['imposto'] ?>">
                                    <div class="input-group input-group-merge">
                                        <input value="<?= $data[0]['imposto'] ?>" type="number" class="form-control"
                                               id="input-imposto" placeholder="Informe aqui o percentual de imposto">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Custo ADM</label>
                                <div class="col-sm-10">
                                    <input type="hidden" id="input-adm-old-value" value="<?= $data[0]['custo_administrativo'] ?>">
                                    <div class="input-group input-group-merge">
                                        <input value="<?= $data[0]['custo_administrativo'] ?>" type="number"
                                               class="form-control" id="input-adm"
                                               placeholder="Informe aqui o percentual de custo administrativo">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Comissão</label>
                                <div class="col-sm-10">
                                    <input type="hidden" id="input-comissao-old-value" value="<?= $data[0]['comissao'] ?>">
                                    <div class="input-group input-group-merge">
                                        <input value="<?= $data[0]['comissao'] ?>" type="number" class="form-control"
                                               id="input-comissao" placeholder="Informe aqui o percentual de comissão">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>
                            <div class="row mb-2">
                                <label class="col-sm-2 col-form-label">Desconto financeiro</label>
                                <div class="col-sm-10">
                                    <input type="hidden" id="input-desconto-old-value" value="<?= $data[0]['desconto_financeiro'] ?>">
                                    <div class="input-group input-group-merge">
                                        <input value="<?= $data[0]['desconto_financeiro'] ?>" type="number"
                                               class="form-control" id="input-desconto"
                                               placeholder="Informe aqui o percentual de desconto">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col">
                                    <span>
                                        <small>
                                            * Fator de cálculo não está considerando a precificação (<b>%</b> incrimentado na hora do orçamento)
                                        </small>
                                    </span>
                                </div>
                            </div>
                            <div class="row d-flex mb-3">
                                <label class="col col-form-label">Subtraindo de <strong>100</strong> a soma dos valores
                                    acima: <strong id="txt-resultado">Calculando...</strong>
                                </label>
                            </div>

                            <hr>

                            <h5>Custos <b>H2</b></h5>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Imposto</label>
                                <div class="col-sm-10">
                                    <input type="hidden" id="input-imposto2-old-value" value="<?= $data[0]['imposto2'] ?>">
                                    <div class="input-group input-group-merge">
                                        <input value="<?= $data[0]['imposto2'] ?>" type="number" class="form-control"
                                               id="input-imposto2" placeholder="Informe aqui o percentual de imposto">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <label class="col-sm-2 col-form-label">Comissão</label>
                                <div class="col-sm-10">
                                    <input type="hidden" id="input-comissao2-old-value" value="<?= $data[0]['comissao2'] ?>">
                                    <div class="input-group input-group-merge">
                                        <input value="<?= $data[0]['comissao2'] ?>" type="number" class="form-control"
                                               id="input-comissao2" placeholder="Informe aqui o percentual de comissão">
                                        <span class="input-group-text">%</span>
                                    </div>
                                </div>
                            </div>

                            <label class="col col-form-label">Subtraindo de <strong>100</strong> a soma dos valores
                                acima: <strong id="txt-resultado2">Calculando...</strong>
                            </label>

                            <hr>

                            <div class="row mb-3">
                                <div class="col">
                                    <input type="hidden" id="costs-id" value="<?= $data[0]['id'] ?>">
                                    <button class="btn btn-primary" id="btn-save-costs" type="button">Salvar</button>
                                    <button class="btn btn-secondary" id="btn-clear-costs" type="button">Limpar campos
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/modal_create_tax.html';
?>
<!-- / Modals -->

<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/js/costs.js"></script>
<script src="assets/js/helpers.js"></script>
<script src="assets/vendor/fattos/alert.js"></script>
</body>

</html>