<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Contatos</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
    <link href="//cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <link href="//cdn.quilljs.com/1.3.6/quill.bubble.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <link rel="stylesheet" type="text/css" href="assets/vendor/daterangepicker/css.min.css" />

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <!-- Page CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
    <style>
        .tab-form, .tab-form-contact {
            display: none;
        }

        .step-form, .step-form-contact {
            height: 15px;
            width: 15px;
            margin: 0 2px;
            background-color: #bbbbbb;
            border: none;
            border-radius: 50%;
            display: inline-block;
            opacity: 0.5;
        }

        .step-form.active, .step-form-contact.active {
            opacity: 1;
        }

        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container, .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: 1px solid #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }
    </style>

    <script src="assets/js/config.js"></script>
    <script src="https://unpkg.com/vue@3/dist/vue.global.prod.js"></script>

</head>

<body>
    <!-- Layout wrapper -->
    <div id="app" class="layout-wrapper layout-content-navbar">
        <div class="layout-container control-dark-mode dark-mode light-mode">

            <!-- Menu -->
            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-fluid flex-grow-1 container-p-y" v-cloak>
                        <div class="card mb-3" x-data="dataTable()" x-init="fetchData()">
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button v-if="userLevel != 3 && userLevel != 0" class="ms-2 btn btn-sm btn-primary" type="button" onclick="novoContato()">
                                            <i class="bx bx-phone-incoming me-sm-1"></i> 
                                            Novo Contato
                                        </button>
                                    </div>

                                    <div class="d-flex">
                                        <div class="d-flex h-px-30 me-3">
                                            <select id="filtro-ordenacao-tabela" v-model="ordenacaoFilter" class="form-select" data-bs-toggle="tooltip" title="Ordenação dos contatos">
                                                <!-- Opções para ID Lançamento -->
                                                <option value="id:desc">Novos lançamento</option>
                                                <option value="id:asc">Antigos lançamentos</option>
                                                <!-- Opções para Data para retorno -->
                                                <option value="dtRetorno:proximos">Clientes a retornar</option>
                                            </select>
                                        </div>                                        
                                        <div v-if="userLevel > 7" class="d-flex h-px-30 me-3">
                                            <select id="tipo-filter-contact" class="form-select" v-model="tipoFilter">
                                                <option value="0">Visitas e contatos</option>
                                                <option value="1">Visitas</option>
                                                <option value="2">Contatos</option>
                                            </select>
                                        </div>
                                        <div v-if="userLevel > 7"  class="d-flex h-px-30 me-3">
                                            <select id="tipo-filter-vendedor" class="form-select" v-model="vendedorFilter">
                                                <option value="">Carregando...</option>
                                            </select>
                                        </div>
                                        <div class="d-flex h-px-30 me-3">
                                            <input 
                                                class="form-control daterange" 
                                                type="text" 
                                                id="filter-range-data-criacao" 
                                                style="height: 32px;"
                                                v-model="dateRangeFilter"
                                                value=""
                                                title="Filtrar por invertalo de data de criação"
                                                data-bs-toggle="tooltip"
                                            >
                                        </div>
                                        <div class="d-flex h-px-30">
                                            <input 
                                                autofocus
                                                class="form-control me-1" 
                                                type="text" 
                                                id="text-filter-contact" 
                                                v-model="textFilter"
                                                placeholder="Buscar..."
                                            >
                                            <button class="btn btn-sm btn-primary" @click="filtrarContato">Buscar</button>
                                        </div>
                                    </div>
                                </div>                        
                            </div>
                            <div class="card-body">
                                <div class="table-responsive scrollbar">
                                    <table class="table table-striped fs--1 mb-0 table-sm overflow-hidden">
                                        <thead class="bg-200 text-900">
                                            <tr>
                                                <th>
                                                    <div class="form-check fs-0 mb-0 d-flex align-items-center">
                                                        <input class="form-check-input" type="checkbox">
                                                    </div>
                                                </th>
                                                <th class="sort pe-1 white-space-nowrap">Ordem</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Telefone / Celular</th>
                                                <th class="sort pe-1 white-space-nowrap">Cliente</th>
                                                <th class="sort pe-1 white-space-nowrap">Diálogo</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Data contato</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Data p. retorno</th>
                                                <th v-if="userLevel > 7" class="sort pe-1 white-space-nowrap text-center">Geolocalização</th>
                                                <th class="sort pe-1 white-space-nowrap text-center">Situação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="item in items" :key="item.id">
                                                <td class="align-middle" style="width: 28px;">
                                                    <div class="form-check fs-0 mb-0 d-flex align-items-center">
                                                        <input class="form-check-input" type="checkbox" id="checkbox" data-bulk-select-row="data-bulk-select-row">
                                                    </div>
                                                </td>
                                                <td class="py-2 align-middle white-space-nowrap text-truncate">
                                                    <a href="#" @click.prevent="visualizaSolicitacao(item.id)"><strong>#{{ item.id }}</strong></a>
                                                    por 
                                                    <img 
                                                        v-if="item.imgUsuario" 
                                                        class="avatar avatar-xxs pull-up rounded-3 border" 
                                                        :src="'assets/file/user/' + item.imgUsuario"
                                                        @click="showImage('assets/file/user/' + item.imgUsuario)"
                                                        alt="Avatar" class="rounded-circle"
                                                    />
                                                    <img v-else 
                                                        class="avatar avatar-xxs pull-up rounded-3 border" 
                                                        src="assets/file/system/undraw_profile.svg"
                                                        alt="Avatar" class="rounded-circle"
                                                    />
                                                    <strong class="ms-1">{{ item.nomeUsuario }}</strong><br>
                                                </td>
                                                <td class="py-2 align-middle text-center fs-0 fw-medium text-truncate">
                                                    {{ item.tel }}
                                                    <a :href="'https://wa.me/55' + item.tel.replace(/[^0-9]/g, '')" target="_blank" class="pb-1 ms-2 bx bxl-whatsapp" style="color: #3d8518" :title="'Abrir conversa no WhatsApp com +55' + item.tel.replace(/[^0-9]/g, '')"></a>
                                                    <a :href="'tel:+55' + item.tel.replace(/[^0-9]/g, '')" target="_blank" class="ms-2 pb-3-px bx bx-phone text-primary" :title="'Discar para +55' + item.tel.replace(/[^0-9]/g, '')"></a>
                                                </td>
                                                <td>{{ item.nomeCliente }}</td>
                                                <td :class="item.dialogo.length > 29 ? 'c-h py-2 align-middle white-space-nowrap text-truncate' : ''" :data-bs-toggle="item.dialogo.length > 29 ? 'tooltip' : ''" :data-bs-placement="item.dialogo.length > 29 ? 'top' : ''" :data-bs-html="item.dialogo.length > 29 ? 'true' : ''" :title="item.dialogo.length > 29 ? item.dialogo : ''">
                                                    {{ item.dialogo.length > 29 ? item.dialogo.substring(0, 30) + '... ' : item.dialogo }}
                                                    <i v-if="item.dialogo.length > 29" class="bx bx-xs bx-copy-alt c-p" @click="copyToClipboard(item.dialogo)" title="Clique para copiar o diálogo com o cliente"></i>
                                                </td>
                                                <td class="py-2 align-middle text-center text-truncate"><small>{{ item.create_at }}</small></td>
                                                <td class="py-2 align-middle text-center" :data-retorno-ptbr="item.data_retorno"><small>{{ item.data_retorno }}</small></td>
                                                <td v-if="userLevel > 7" class="py-2 align-middle text-center">
                                                    <button type="button" class="btn btn-sm btn-primary" @click="visualizaGeolocalizacaoVisita(item.id)" v-if="item.latitude && item.longitude">Visualizar</button>
                                                </td>
                                                <td class="py-2 align-middle white-space-nowrap text-center" :data-acao-id-contato="item.id">
                                                    <i class='bx bx-loader-alt spinner-loader'></i>
                                                </td>
                                            </tr>
                                        </tbody>
                                        
                                    </table>
                                </div>
                            </div>
                            <div v-html="templatePaginate" class="dynamic-pagination col text-center mb-3"></div>
                        </div>
                    </div>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>

            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Modals -->
    <?php
    include __DIR__ . '/partials/modal/modal_create_contact.html';
    include __DIR__ . '/partials/modal/modal_show_image.html';
    include __DIR__ . '/partials/modal/modal_atende_solicitacao.html';
    ?>
    <div class="modal fade" id="modal-geolocalizacao" role="dialog" aria-hidden="true" data-bs-backdrop="static">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Visualizar no mapa</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="map" style="height: 400px; width: 100%;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>
    <!-- / Modals -->

    <!-- Core JS -->
    <!-- build:js assets/vendor_template/js/core.js -->
    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/moment/moment-with-all-locales.min.js"></script>
    <script src="assets/vendor/daterangepicker/script.min.js"></script>
    <script src="assets/vendor/jquery-mask/jquery-mask-update.min.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src='assets/vendor/fullcalendar/script.min.js'></script>
    <script src="assets/vendor/maskMoney/jquery.maskMoney.min.js"></script>
    <script src="//cdn.quilljs.com/1.3.6/quill.min.js"></script>
    <script src="assets/vendor/select2/select2.min.js"></script>
    <!-- endbuild -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/i18n/pt-BR.js"></script>

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <!-- Page JS -->
    <script src="assets/vendor/fattos/alert.js"></script>

    <script src="assets/js/budget.js"></script>
    <script src="assets/js/budget-list.js"></script>
    <script src="assets/js/contact-list.js"></script>

    <script>

        var html_clone_solicitacao = null;
        $('#modal-new-contact').on('shown.bs.modal', function () {
            if (html_clone_solicitacao == null) {
                html_clone_solicitacao = $('#group-solicitacao-ref').html();
            }
        });

        $('#adiciona-content-solicitacao').on('click', function () {
            $('#render-solicitacao-adicional').append(`
                <div data-agroupment-solicitacao>
                    <div class="row mt-3">
                        ${html_clone_solicitacao}
                    </div>
                    <div class="text-end text-danger mt-n2">
                        <small class="c-p" onclick="removeContentSolicitacao()">Remover</small>
                    </div>
                </div>
            `);

            $(".real").maskMoney({
                prefix: 'R$ ',
                thousands: '.',
                decimal: ','
            })
        });

        function removeContentSolicitacao() {
            $(event.target).closest('div[data-agroupment-solicitacao]').remove();
        }

    </script>
</body>

</html>