<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>


<?php
/**
 * @deprecated
 * @deprecated
 * ==================================================
 * @deprecated
 * 
 * * TELA DESCONTINUADA
 * 
 * @deprecated
 * ==================================================
 * @deprecated
 * @deprecated
 */
$idCliente = isset($_GET['id']) ? $_GET['id'] : '';

if (empty($idCliente)) {
    header('Location: contacts-list.php');
    exit;
}

?>
<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>Contatos</title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <!-- Page CSS -->

    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container--default.select2-container--disabled .select2-selection--multiple {
            background-color: #fff;
        }

        .select2-container, .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }
    </style>

    <script src="assets/js/config.js"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container control-dark-mode dark-mode light-mode">
            <!-- Menu -->

            <?php include __DIR__ . '/partials/sidebar.php'; ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page control-dark-mode dark-mode light-mode">
                <!-- Navbar -->
                <?php include __DIR__ . '/partials/navbar.php'; ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container-fluid flex-grow-1 container-p-y">
                        <input type="hidden" id="idClienteHidden" value="<?= $idCliente ?>">
                        <div class="card mb-3" >
                            <div class="card-header">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button class="ms-2 btn btn-sm btn-primary" type="button" onclick="history.back()">
                                            <i class="bx bx-undo me-sm-1"></i> 
                                            Voltar
                                        </button>
                                    </div>
                                    <div id="nomeClienteTitleCard">Carregando...</div>
                                    <div>
                                        <button class="ms-2 btn btn-sm btn-primary d-none" id="btn-lanca-contato" type="button" onclick="novoContato()" disabled>
                                            <i class="bx bx-phone-incoming me-sm-1"></i> 
                                            Lançar interação
                                        </button>
                                    </div>
                                </div>                        
                            </div>
                            <div class="card-body">
                                <div class="table-responsive scrollbar">
                                    <table class="table table-sm table-striped fs--1 mb-0 overflow-hidden">
                                        <thead class="bg-200 text-900">
                                            <tr>
                                                <th class="sort pe-1 white-space-nowrap">Lançado em</th>
                                                <th class="sort pe-1 white-space-nowrap">Colaborador</th>
                                                <th class="sort pe-1 white-space-nowrap">Diálogo</th>
                                                <th class="sort pe-1 white-space-nowrap">Solicitação</th>
                                                <th class="sort pe-1 white-space-nowrap">Detalhes</th>
                                                <?php if($_SESSION['user']['nivel'] != 3): ?> 
                                                <th class="sort pe-1 white-space-nowrap text-center">Ação</th>
                                                <?php endif; ?>
                                            </tr>
                                        </thead>
                                        <?php $contatos = (new App\Core\Contact)->showContatosCliente($idCliente); ?>

                                        <tbody class="list" id="table-orders-body">
                                            <?php foreach ($contatos as $key => $contato): 
                                                
                                                $button = '<i class="bx bx-check"></i>';
                                                
                                                if (!$contato['orcado'] && !empty($contato['descricao_solicitacao']) && $_SESSION['user']['nivel'] > 7) {
                                                    $button = "<button class='btn btn-sm btn-warning' onclick='novaSolicitacaoOrcamento($contato[id])'>Atender</button>";
                                                }

                                                if ($contato['orcado'] == 1 && !empty($contato['produtos'])) {
                                                    $button = "<a class='btn btn-sm btn-success' href='budgets-list.php?ref=$contato[id]'>Orçar</a>";
                                                }
                                                
                                                ?>
                                                <tr>
                                                    <td class="py-2 align-middle white-space-nowrap">
                                                        <small><?= $contato['create_at'] ?></small>
                                                    </td>
                                                    <td class="py-2 align-middle white-space-nowrap">
                                                        <?= $contato['nomeUsuario'] ?>
                                                    </td>
                                                    <td class="py-2 align-middle white-space-nowrap">
                                                        <?= $contato['dialogo'] ?>
                                                    </td>
                                                    <td class="py-2 align-middle white-space-nowrap">
                                                        <?= $contato['descricao_solicitacao'] ?>
                                                    </td>
                                                    <td class="py-2 align-middle white-space-nowrap">
                                                        <button class="btn btn-sm btn-primary" onclick="visualizaSolicitacao(<?= $contato['id'] ?>)">Ver mais</button>
                                                    </td>
                                                    <?php if($_SESSION['user']['nivel'] != 3): ?> 
                                                    <td class="py-2 align-middle white-space-nowrap text-center w-px-10">
                                                        <?= $button ?>
                                                    </td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>

            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- / Modals -->
    <?php
        include __DIR__ . '/partials/modal/modal_create_budgets.html';
        include __DIR__ . '/partials/modal/modal_create_contact.html';
        include __DIR__ . '/partials/modal/modal_show_image.html';
        include __DIR__ . '/partials/modal/modal_atende_solicitacao.html';
    ?>
    <!-- Core JS -->
    <!-- build:js assets/vendor_template/js/core.js -->
    <script src="assets/vendor_template/libs/jquery/jquery.js"></script>
    <script src="assets/vendor/jquery-mask/jquery-mask-update.min.js"></script>
    <script src="assets/vendor_template/libs/popper/popper.js"></script>
    <script src="assets/vendor_template/js/bootstrap.js"></script>
    <script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="assets/vendor/maskMoney/jquery.maskMoney.min.js"></script>
    <script src="//cdn.quilljs.com/1.3.6/quill.min.js"></script>
    <script src="assets/vendor/select2/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/i18n/pt-BR.js"></script>
    <!-- endbuild -->

    <!-- Main JS -->
    <script src="assets/js/main.js"></script>

    <script src="assets/js/budget.js"></script>
    <!-- Page JS -->
    <script src="assets/vendor/fattos/alert.js"></script>
    <script>

        // const path_core = '../app/Core/';
        const idCliente = $('#idClienteHidden').val();
        var dadosCliente;

        $.ajax({
            method: 'POST',
            url: `${path_core}Customer.php`,
            dataType: 'json',
            data: {
                action: 'getCustomer',
                idCustomer: idCliente
            },
            success: function (data) {
                if (data.is_owner) {
                    $('#btn-lanca-contato').removeClass('d-none');
                }

                dadosCliente = data;
                $('#nomeClienteTitleCard').html(`Histórico de contatos com <strong><u>${data.nome}</u></strong>`);
            },
            error: function(xhr) {
                console.log(xhr);
            }
        })

        var isSolicitacaoContato = false; 
        $('#select-categoria-contato').on('change', function() {
            const categoria = $(this).val();

            isSolicitacaoContato = false; 
            $('#div-solicitacao-orcamento-contato').addClass('d-none');
            $('#descricao-solicitacao-orcamento-contato').val('');
            $('#descricao-solicitacao-orcamento-anexo').val('');

            if (categoria == '2') {
                isSolicitacaoContato = true; 
                $('#div-solicitacao-orcamento-contato').removeClass('d-none');
            }
        });

        function novaSolicitacaoOrcamento(idContato) {
            const data = getInfoContato(idContato);


            $('#modal-atendimento-solicitacao-footer').removeClass('d-none');
            $('#modal-atendimento-solicitacao-title').text('Atender solicitação');
            $('#btn-atender-solicitacao').val(idContato);
            $('#modal-atendimento-solicitacao-cliente').val(data.nomeCliente);
            $('#modal-atendimento-solicitacao-contato').val(data.contato);
            $('#modal-atendimento-solicitacao-telefone').val(data.tel);
            $('#modal-atendimento-solicitacao-dialogo').val(data.dialogo);
            $('#modal-atendimento-solicitacao-solicitacoes').val(data.descricao_solicitacao);
            $('#resposta-solicitacao-orcamento-contato').prop('readonly', false);

            $('#div-content-exists-anexo').addClass('d-none');
            if (data.fileZip) {
                $('#div-content-exists-anexo').removeClass('d-none');
                $('#modal-atendimento-solicitacao-anexos').prop('href', `assets/file/contacts/${data.fileZip}`);
            }
            $('#modal-atendimento-solicitacao').modal('show');
        }

        function getInfoContato(idContato) {
            let response;

            $.ajax({
                async: false,
                method: 'GET',
                url: `${path_core}Contact.php?action=getInfoById&id=${idContato}`,
                dataType: 'JSON',
                success: (data) => {
                    response = data;
                },
                error: (xhr) => {
                    console.log(xhr);
                    console.log('xhr');
                }
            });

            return response;
        }

        $('#btn-atender-solicitacao').on('click', function() {
            const idContato = $(this).val();
            const resposta = $('#resposta-solicitacao-orcamento-contato').val();
            let produtos = {};

            $('.group-product-contact').each(function (i, el) {
                produtos[i] = {
                    produto: $(this).find('.select-product-contact').val(),
                    qtd_mao_obra: $(this).find('.qtd-mao-obra-contact').val()
                }
            });

            $(this).attr('disabled', true);

            $.ajax({
                method: 'POST',
                url: `${path_core}Contact.php`,
                dataType: 'json',
                data: {
                    action: 'atenderSolicitacaoOrcamentoContato',
                    resposta: resposta,
                    produtos: produtos,
                    idContato: idContato
                },
                success: function (data) {
                    fat_alert({
                        type: 'primary',
                        title: 'Successo!!!',
                        message: 'Solicitação foi atendida com sucesso!',
                        timer: 3000
                    });

                    setTimeout(() => {
                        window.location.reload(false);
                    }, 1000);
                },
                error: function(xhr) {
                    console.log(xhr);

                    fat_alert({
                        title: 'Oops...',
                        message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                        type: 'danger',
                        timer: 3000
                    });
                }
            })
        });

        function novoContato() {
            $('#select-customers-contact').prop('disabled', true);
            $('#select-customers-contact').val(idCliente).trigger('change');
            $('#modal-new-contact').modal('show');
        }

        $('#select-customers-contact').on('change', function() {
            const cliente = $(this).val();

            if ($.isNumeric(cliente)) {
                showDadosClienteFormNovoContato(cliente);
                showDialogosAnteioresClienteFormNovoContato(cliente);
            }

            $('#telefone-celular-contato, #select-uf-contato').attr('disabled', false);

        });

        function showDadosClienteFormNovoContato(idCliente) {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}Customer.php`,
                data: {
                    action: 'getCustomer',
                    idCustomer: idCliente
                },
                success: function (data) {
                    $('#telefone-celular-contato').val(data.celular || data.telefone);
                    $('#select-uf-contato').val(data.estado);
                    
                    let option = data.cidade ? `<option value="${data.cidade}">${data.cidade}</option>` : '<option value="">Nenhum selecionado</option>';
                    $('#select-cidade-contato').html(option);

                    $('#telefone-celular-contato, #select-uf-contato, #select-cidade-contato, #select-origem-modal-create-customer').attr('disabled', true);

                },
                error: function(xhr) {
                    console.log(xhr);
                }
            });
        }

        function showDialogosAnteioresClienteFormNovoContato(idCliente) {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}Contact.php`,
                data: {
                    action: 'getDialogsByCustomer',
                    idCustomer: idCliente
                },
                success: function (data) {
                    console.log(data);
                    $('#dialogos-anteriores').html('<hr> <label class="form-label">Diálogos anteriores</label><br>');

                    if (data.length == 0) {
                        $('#dialogos-anteriores').append(`<label><small>Nada encontrando...</small></label>`);
                    }

                    data.forEach((info) => {
                        $('#dialogos-anteriores').append(`<li><label class="form-label">${info.create_at}</label>: ${info.dialogo}</li>`);
                    });

                    $('#dialogos-anteriores').parent().removeClass('d-none');
                },
                error: function(xhr) {
                    console.log(xhr);
                }
            });
        }

        function activeLastedSelectProduct() {
            $('.select-product-contact:last').select2({
                language: "pt-BR",
                dropdownParent: $('#modal-atendimento-solicitacao'),
                width: '100%',
                minimumInputLength: 2,
                minimumResultsForSearch: 10,
                multiple: false, 
                ajax: {
                    url: `${path_core}Product.php`,
                    dataType: 'json',
                    type: 'POST',
                    delay: 250,
                    data: function (params) {
                        return {
                            action: 'buscarProduto',
                            search: params.term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: $.map(data, function (item) {
                                return {
                                    text: item.id + ' - ' + item.nome,
                                    id: item.id
                                }
                            })
                        };
                    }
                }
            });
        }


        const html_clone_product_contact = $("#div-item-contact-product").html();

        $('#new-product-contact').on('click', function () {
            $('#render-new-product-contact').append(
                '<div data-agroupment-product-contact><div class="row mt-3">' + html_clone_product_contact + '</div>' +
                '<div class="text-end text-danger mt-n2"><small class="c-p" onclick="removeProductContact()">Remover</small></div></div>'
            );

            activeLastedSelectProduct();
        });

        setTimeout(() => {
            activeLastedSelectProduct();
        }, 1000);

        function removeProductContact() {
            $(event.target).closest('div[data-agroupment-product-contact]').remove();
            validateDuplicateProduct();
        }

    </script>

</body>

</html>