<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>


<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Status</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/file/system/tbticon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
          rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>

    <!-- Helpers -->
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper ">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <div class="card-header">
                            <h5>Configurações gerais</h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-3 col-lg-3 col-6">
                                    <div class="form-group">
                                        <label for="" class="form-label">Tempo para perder o orçamento automaticamente</label>
                                        <div class="input-group">
                                            <input type="number" value="<?= (new \App\Core\Config)->getUltimoDiaTempoPerda() ?>" id="input-dias-perder" min="0" class="form-control">
                                            <span class="input-group-text">Dia(s)</span>
                                        </div>
                                        <button id="btn-atualiza-tempo-perder" type="button" class="btn btn-sm float-end btn-primary mt-3">Salvar</button>
                                    </div>
                                </div>
                                <div class="col-xl-3 col-lg-3 col-6">
                                    <div class="form-group">
                                        <label for="" class="form-label">Tempo para desvincular vendedor do cliente automaticamente</label>
                                        <div class="input-group">
                                            <input type="number" value="90" id="input-dias-perde-cliente" min="0" class="form-control">
                                            <span class="input-group-text">Dia(s)</span>
                                        </div>
                                        <button id="btn-atualiza-tempo-perder-cliente" type="button" class="btn btn-sm float-end btn-primary mt-3">Salvar</button>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/status/modal_create_status.html';
?>
<!-- / Modals -->

<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/vendor/fattos/alert.js"></script>

<!-- <script src="assets/js/fees.js"></script> -->
<script src="assets/js/helpers.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>

<script>
    const path_core = '../app/Core/';

    const btnAtualizaTempoPerda = $('#btn-atualiza-tempo-perder'); 

    btnAtualizaTempoPerda.on('click', function() {
        const dias = Number($('#input-dias-perder').val());

        if (dias <= 0) {
            // code
            return;
        }

        btnAtualizaTempoPerda.attr('disabled', true);

        $.ajax({
            method: 'POST',
            url: `${path_core}Config.php`,
            data: {
                dias: dias,
                action: 'atualizaTempoPerda'
            },
            success: function() {
                fat_alert({
                    type: 'primary',
                    title: 'Sucesso!',
                    message: `Perda automática do orçamento atualizada para ${dias} dias`,
                    timer: 4000
                });
            },
            complete: function() {
                btnAtualizaTempoPerda.attr('disabled', false);
            },
            error: function(xhr) {
                fat_alert({
                    type: 'primary',
                    title: 'Oops...',
                    message: `Ocorreu um problema ao atualizar a perda automática`,
                    timer: 4000
                });
                console.log(xhr);
            },
        })
    });
</script>

</body>

</html>