<?php include __DIR__ . '/../app/Core/LoginSessionValidator.php'; ?>

<!DOCTYPE html>

<html lang="pt-br" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="assets/"
      data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"/>

    <title>Códigos</title>

    <meta name="description" content=""/>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="assets/img/favicon/favicon.png"/>


    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com"/>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
          rel="stylesheet"/>

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="assets/vendor_template/fonts/boxicons.css"/>

    <!-- Core CSS -->
    <link rel="stylesheet" href="assets/vendor_template/css/core.css" class="template-customizer-core-css"/>
    <link rel="stylesheet" href="assets/vendor_template/css/theme-default.css" class="template-customizer-theme-css"/>

    <link rel="stylesheet" href="assets/vendor/select2/select2.min.css">
    <!-- vendor_templates CSS -->
    <link rel="stylesheet" href="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.css"/>

    <style>
        .select2-dropdown {
            z-index: 9001;
        }

        .select2-container,
        .select2-selection--single {
            height: 34px !important;
            color: #697a8d !important;
            border-color: #d9dee3 !important;
        }

        .select2-selection {
            color: #697a8d !important;
        }

        .select2-selection__rendered {
            color: #697a8d !important;
            line-height: 31px !important;
        }

        .select2-selection__arrow {
            height: 31px !important;
        }

        #select-users {
            max-height: 35px !important;
        }
    </style>
    <!-- Helpers -->
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="assets/js/config.js"></script>
</head>

<body>
<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->

        <?php include __DIR__ . '/partials/sidebar.php'; ?>
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page control-dark-mode dark-mode light-mode">
            <!-- Navbar -->
            <?php include __DIR__ . '/partials/navbar.php'; ?>
            <!-- / Navbar -->

            <!-- Content wrapper -->
            <div class="content-wrapper ">
                <!-- Content -->

                <div class="container-fluid flex-grow-1 container-p-y">
                    <div class="card control-dark-mode-solid dark-mode-solid light-mode-solid">
                        <div class="card-header d-flex justify-content-between">
                            <button type="button" class="btn btn-sm btn-primary" title="Cadastrar nova categoria" data-bs-toggle="modal" data-bs-target="#modal-new-code">
                                <i class="tf-icons bx bx-plus"></i>
                                Nova categoria
                            </button>
                            <span class="text-warning py-2 my-0">
                                <i class="bx bx-info-circle"></i> Sincronizado com site
                            </span>
                        </div>

                        <div class="table-responsive text-nowrap">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th>Categoria</th>
                                    <th class="text-start">NCM</th>
                                    <th class="text-center">Colaboradores</th>
                                    <th class="text-center">Ações</th>
                                </tr>
                                </thead>
                                <tbody class="table-border-bottom-0" id="table-code-info">
                                    <tr>
                                        <td colspan="4" class="text-center">Carregando...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="content-backdrop fade"></div>
            </div>
            <!-- Content wrapper -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
</div>
<!-- / Layout wrapper -->

<!-- Modals -->
<?php
include __DIR__ . '/partials/modal/modal_create_code.html';
include __DIR__ . '/partials/modal/modal_edit_code.html';
?>
<!-- / Modals -->

<!-- Core JS -->
<!-- build:js assets/vendor_template/js/core.js -->
<script src="assets/vendor_template/libs/jquery/jquery.js"></script>
<script src="assets/vendor_template/libs/popper/popper.js"></script>
<script src="assets/vendor_template/js/bootstrap.js"></script>
<script src="assets/vendor_template/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
<script src="assets/vendor/select2/select2.min.js"></script>

<script src="assets/vendor_template/js/menu.js"></script>
<!-- endbuild -->

<!-- Main JS -->
<script src="assets/js/main.js"></script>

<script src="assets/vendor/fattos/alert.js"></script>

<!-- <script src="assets/js/fees.js"></script> -->
<script src="assets/js/helpers.js"></script>

<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="https://buttons.github.io/buttons.js"></script>

<script>
    function s() {
        fat_alert({
            type: 'dark',
            title: 'Oops...',
            message: 'Recurso em implementação',
            timer: 5000
        });
    }
    
    const path_core = '../app/Core/';

    /**
     * @var btn_add_code
     */
    const btn_add_code = $('#btn-add-code');

    btn_add_code.on('click', function() {
        const codigo = $('#modal-new-code-codigo').val();
        const users  = $('#select-users').val(); 

        if (codigo == '') {
            fat_alert({
                type: 'warning',
                title: 'Oops...',
                message: 'Favor informar um nome!',
                timer: 3000
            });
            return;
        }

        btn_add_code.attr('disabled', true);

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            url: `${path_core}Codigos.php`,
            data: {
                nome: codigo,
                usuarios: users,
                action: 'store'
            },
            success: function (data) {
                console.log(data);
                btn_add_code.attr('disabled', false);
                show().then((response) => renderInfoTable(response))

                $('.input-code').val('');

                fat_alert({
                    type: 'success',
                    title: 'Successo!!!',
                    message: 'Código cadastrado com sucesso!',
                    timer: 3000
                });

                window.location.reload(false);

            },
            error: function (xhr) {
                console.log(xhr);
                const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';

                fat_alert({
                    title: 'Erro',
                    message: errorMessage,
                    type: 'danger',
                    timer: 3000
                });

                return false;
            }
        });
    });

    async function show() {
        return await $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: `${path_core}Codigos.php?action=show`,
        });
    }

    /**
     * Método responsável por obter os dados do código para montar o formulário de edição
     */
    function modalEditCode(id, nome) {
        $('#modal-edit-code-id').val(id);
        $('#modal-edit-code-codigo').val(nome)
        $('#modal-edit-code-title').text('Editar código: ' + nome)
        $('#modal-edit-code').modal('show');
    }

    $('#btn-edit-code').on('click', function() {
        const id = $('#modal-edit-code-id').val();
        const code = $('#modal-edit-code-codigo').val();

        if (!code) {
            fat_alert({
                type: 'danger',
                title: 'Oops!',
                message: 'Informe o nome do código para alterar',
                timer: 3000
            });
            return;
        }

        $.ajax({
            type: 'POST',
            url: `${path_core}Codigos.php`,
            data: {
                action: 'atualizaNomeCodigo',
                id: id,
                nome: code
            },
            success: function (data) {
                $(`#setDinamycName-${id}`).text(code);
                fat_alert({
                    type: 'primary',
                    title: 'Sucesso!!!',
                    message: 'Código atualizado com sucesso!!!',
                    timer: 3000
                });
                $('#modal-edit-code').modal('hide');
            },
            error: function (xhr) {
                fat_alert({
                    type: 'danger',
                    title: 'Oops!',
                    message: 'Ocorreu um problema ao atualizar o código',
                    timer: 3000
                });

                console.log(xhr);
            }
        });
    });

    function renderInfoTable(data) {

        let html = '';

        if (data == '') {
            html += `
                <tr>
                    <td colspan="3" class="text-center"><small>Nenhum registro encontrado... 🤔</small></td>
                </tr>
            `;

            fat_alert({
                type: 'dark',
                title: 'Hey!!!',
                message: 'Que tal criar seu primeiro código personalizado? 🤓',
                timer: 5000
            });

            setTimeout(() => {                
                fat_alert({
                    type: 'dark',
                    title: 'Vamos lá? 💡',
                    message: 'Clique no botão "+" ao lado de "Códigos" para começar... ',
                    timer: 5000
                });
            }, 5000);
        }

        data.forEach(el => {
            htmlOtions = `
                <div class="dropdown dropstart">
                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                        <i class="bx bx-dots-vertical-rounded"></i>
                    </button>
                    <div class="dropdown-menu">
                        <a class="dropdown-item" onclick="modalEditCode(${el.id}, '${el.nome}')"><i class="bx bx-edit-alt me-1"></i>Editar</a>
                        <a class="dropdown-item" href="javascript:void(0);"><i class="bx bx-low-vision me-1"></i>Inativar</a>
                    </div>
                </div>
            `;

            html += `
                <tr>
                    <td id="setDinamycName-${el.id}">${el.nome}</td>
                    <td class="text-center">
                        <div class="input-group input-group-merge w-px-200">
                            <input class="form-control form-sm ncm-mask" type="text" placeholder="Informe o NCM" value="${el.ncm}">
                            <span class=" input-group-text badge bg-label-primary c-p" data-categoria-id="${el.id}">
                                <i class="bx bx-save fs-4"></i>
                            </span>
                        </div>
                    </td>
                    <td class="text-center"><a href="code-users.php?id=${el.id}">Visualizar (${el.qtd_pessoas})</a></td>
                    <td class="text-center">${htmlOtions}</td>
                </tr>
            `;
        });

        $('#table-code-info').html(html);

        $('.ncm-mask').on('input', function() {
            var value = $(this).val().replace(/\D/g, ''); // Remove caracteres não numéricos
            if (value.length > 8) {
                value = value.slice(0, 8); // Limita o número a 8 dígitos
            }
            
            // Formatação: XXXX.XX.XX
            value = value.replace(/^(\d{4})(\d{2})(\d{0,2})$/, "$1.$2.$3");
            
            // Atualiza o valor do input
            $(this).val(value);
        });


        $('span[data-categoria-id]').on('click', function() {
            const id = $(this).data('categoria-id');
            const ncm = $(this).closest('td').find('input').val();

            if (!isValidNcm(ncm)) {
                fat_alert({
                    type: 'warning',
                    title: 'Oops...',
                    message: 'Informe um NCM válido!',
                    timer: 3000
                });
                return;
            }

            $.ajax({
                type: 'POST',
                url: `${path_core}Codigos.php`,
                data: {
                    action: 'atualizaNCM',
                    id: id,
                    ncm: ncm
                },
                success: function (data) {
                    fat_alert({
                        type: 'primary',
                        title: 'Sucesso!!!',
                        message: 'NCM atualizado com sucesso!!!',
                        timer: 3000
                    });
                },
                error: function (xhr) {
                    fat_alert({
                        type: 'danger',
                        title: 'Oops!',
                        message: 'Ocorreu um problema ao atualizar o NCM',
                        timer: 3000
                    });

                    console.log(xhr);
                }
            });
        });
    }

    show().then(
        (response) => renderInfoTable(response)
    ).catch(
        (error) => console.log(error)
    );


    const getUsers = () => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}User.php`,
                data: {
                    action: 'getNameAndId'
                },
                success: function (data) {
                    resolve(data);
                },
                error: function (xhr) {
                    reject(xhr);
                }
            });
        });
    };

    getUsers()
        .then(response => {
            const users = response;

            let html = '';

            users.forEach(el => {
                html += `<option value='${el.id}'>${el.nome}</option>`
            });

            $('#select-users').html(html);
            
            $('#select-users').select2({
                dropdownParent: $('#modal-new-code'),
                width: '100%'
            });
        })
        .catch(error => {
            console.log(error);
        });

        function isValidNcm(ncm) {
            const ncmRegex = /^\d{4}\.\d{2}\.\d{2}$/;
            return ncmRegex.test(ncm);
        }

</script>

</body>

</html>