$(`.select2`).select2({
    width: '100%',
    "language": {
        "noResults": function () {
            return "Digite a opção e pressione a tecla 'enter'";
        }
    },
    placeholder: "Informe o(s) destinatário(s)"
});

function addNameFile() {
    const archive = $('#attach-file').val().split("\\").at(-1);
    return $('#attach-file-name').text(archive);
}

function resetInputsSuportEmail() {
    $('#email-subject').val("");
    $('#email-subject-textarea').val("");
    $('#attach-file-name').text("");
}

function sendMailSupport() {
    const emailSubject = $('#email-subject').val().trim();
    const emailSubjectTextArea = $('#email-subject-textarea').val().trim();
    const archive = $('#attach-file')[0].files[0];
    let data = new FormData();

    const inputs = [emailSubject, emailSubjectTextArea]

    if (!isRequiredInputs(inputs)) return;

    data.append('emailSubject', emailSubject);
    data.append('emailSubjectTextArea', emailSubjectTextArea);
    data.append('archive', archive);
    data.append('action', 'sendMailSupport');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Support.php`,
        contentType: false,
        processData: false,
        data: data,
        beforeSend: function () {
            $('#btn-send-mail-support').prop('disabled', true)
            $('#btn-send-mail-support > span').removeClass('d-none')
            $('#btn-send-mail-support > label').text('Enviando...')
            fat_alert({
                type: 'warning',
                title: 'Aguarde',
                message: 'Enviando...',
                timer: 6000
            });
        },
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'E-mail enviado sucesso!',
                timer: 3000
            });

            setTimeout(() => {
                window.location.reload();
            }, 500);
        },
        complete: function () {
            $('#btn-send-mail-support').prop('disabled', false)
            $('#btn-send-mail-support > span').addClass('d-none')
            $('#btn-send-mail-support > label').text('Enviar')

            $('#modal_send_mail_support').modal('hide')
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.error ? xhr.responseJSON.error : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function showModalMailSupport(assunto, descricao, data, img) {
    $('#subject-modal-show-mail-support').val(assunto);
    $('#date-modal-show-mail-support').val(formatData(data));
    $('#message-modal-show-mail-support').val(descricao);

    $('#support-img').show();
    $('#support-information').removeClass('col-xl-12 col-lg-12').addClass('col-xl-6 col-lg-6');
    $('#image-modal-show-mail-support').attr('src', img);

    if (!img) {
        $('#support-img').hide();
        $('#support-information').removeClass('col-xl-6 col-lg-6').addClass('col-xl-12 col-lg-12');
    }

    $('#modal-show-mail-support').modal('show');
}


$('#attach-file').on('change', addNameFile);
$('#reset-modal-send-mail-support').on('click', function () {
    resetInputsSuportEmail();
});
$('#btn-send-mail-support').on('click', sendMailSupport);


