function recoveryPassword() {
    const email = $('#mail-recovery').val();

    if(!isEmail(email)) {
        fat_alert({
            title: 'Erro',
            message: 'E-mail inválido.',
            type: 'danger',
            timer: 3000
        });
        return;
    }

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `app/Core/RecuperacaoSenha.php`,
        data: {
            action: "requestRecovery",
            email: email,
            url: document.location.href
        },
        beforeSend: function() {
            $('#send-request-recovery').prop('disabled', true)
            $('#send-request-recovery > span').removeClass('d-none')
            $('#send-request-recovery > label').text('Enviando...')
        },
        success: function(data) {
            console.log(data)
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'E-mail de recuperação enviado!',
                timer: 3000
            });
        },
        complete: function() {
            $('#send-request-recovery').prop('disabled', false)
            $('#send-request-recovery > span').addClass('d-none')
            $('#send-request-recovery > label').text('Enviar')

            $('#mail-recovery').val('');
            $('#modal-recovery-pass').modal('hide')
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });
        }
    });
}

function validateParams() {
    const queryString = window.location.search;
    const urlParams   = new URLSearchParams(queryString);
    const recovery    = urlParams.get('recovery');

    if (urlParams.has('recovery')) {
        $('#key_validate').val(recovery);

        setTimeout(() => {
            $('#modal-recovery-pass-success').modal('show');
        }, 200);


        const url = new URL(window.location.href);
        url.searchParams.delete("recovery");
        window.history.pushState("object or string", "Title", url);
    }
}

validateParams();

function updatePass() {
    const password = $('#modal-recovery-pass-change-new-password').val().trim();
    const repeatNewPassword = $('#modal-recovery-pass-change-repeat-password').val().trim();
    const keyValidate = $('#key_validate').val();

    if(!isValidPassword(password, repeatNewPassword)) return;

    if (keyValidate.length < 10 ) {
        fat_alert({
            title: 'Erro',
            message: "Ocorreu um problema na verificação da chave de segurança para atualizar sua senha, por favor, atualize a página e tente novamente. Se o erro persistir, entre em contato com o desenvolvedor. #login_005",
            type: 'danger',
            timer: 3000
        });
        return;
    }

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `app/Core/RecuperacaoSenha.php`,
        data: {
            action: 'updatePassword',
            password: password,
            repeatNewPassword: repeatNewPassword,
            keyValidate: keyValidate,
        },
        success: function(data) {
            console.log(data)
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Senha alterada com sucesso!',
                timer: 3000
            });

            $('#modal-recovery-pass-change-new-password').val('');
            $('#modal-recovery-pass-change-repeat-password').val('');
            $('#key_validate').val('');

            $('#modal-recovery-pass-success').modal('hide');
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });
        }
    });
}

$('#update-pass').on('click', updatePass);
$('#send-request-recovery').on('click', recoveryPassword);