const path_core = '../app/Core/';

function loadMasks() {
    masksUtils('whatsapp');
}

function updateUser() {
    const id = $('#profile-id').val();
    const nome = $('#profile-name').val().trim();
    const sobrenome = $('#profile-last-name').val().trim();
    const nomeCompleto = nome + " " + sobrenome.trim();
    const image = $('.profile-image')[0].files[0];
    let data = new FormData();

    if (!isValidName(nomeCompleto)) return;
    if (!valideteSizeByTagId($('.profile-image'), (5 * 1024 * 1024))) return;

    data.append('id', id);
    data.append('nomeCompleto', nomeCompleto);
    data.append('imagem', image);
    data.append('action', 'updateCurrentUser');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Usuário cadastrado com sucesso!',
                timer: 3000
            });

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

$('#profile-zipCode').on('blur', function () {
    const infoCep = carregarEndereco($(this).val());
    console.log(infoCep)
    $('#invalid-cep').css({
        'display': 'none'
    })

    if (Object.keys(infoCep).length === 0) {
        $('#invalid-cep').css({
            'display': 'block'
        })
        $('#profile-address').val('')

        return;
    }

    $('#profile-logradouro').val(infoCep.logradouro);
    $('#profile-bairro').val(infoCep.bairro);
    $('#profile-state').val(infoCep.uf);
})

function resetInputs() {
    $('#profile-name').val('');
    $('#profile-last-name').val('');
}

function deactivateCurrentUser() {
    const id = $('#delete-user-id').val();
    const status = $('#accountActivation').is(':checked') ? 1 : 0;

    if (status === 0) {
        fat_alert({
            title: 'Erro',
            message: 'Para desativar sua conta, você deve clicar na caixa de seleção de confirmação.',
            type: 'danger',
            timer: 3000
        });

        return;
    }

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        data: {
            action: 'changeUserStatus',
            id: id,
            status: status
        },
        success: function (data) {
            console.log(data)
            setTimeout(function () {
                window.location.href = '/project-budget/index.php';
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

$('#btn-save-profile').on('click', updateUser);
$('#btn-deactivate-account').on('click', deactivateCurrentUser);
