/**
 * Main
 */


// const path_core = '../app/Core/';

'use strict';

let menu, animate;

(function () {
    // Initialize menu
    //-----------------

    const currentUrl = window.location.href;
    const menuLinks = document.querySelectorAll('.menu-link');

    menuLinks.forEach(function (link) {
        if (link.href === currentUrl) link.parentNode.classList.add('active');
    });

})();

async function getNotifications() {
    return await $.ajax({
        method: 'GET',
        dataType: 'JSON',
        url: `../app/Core/Notification.php?action=myNotifications`
    })
}


setTimeout(() => {
    getNotifications().then(data => {
        // console.log(data);
        listNotifications(data);
    }).catch(err => {
        $('#list-notifications').html(`
            <li class="list-group-item list-group-item-action dropdown-notifications-item">
                <div class="d-flex">
                    <div class="flex-grow-1 text-center">
                        <p class="mb-0 p-2 text-danger"><small>Oops, ocorreu um problema ao carregar...</small> 🔕</p>
                    </div>
                </div>
            </li>
        `);
        console.log(err);
    });
}, 1500);

function listNotifications(data) {
    if (Object.keys(data).length === 0) {
        $('#list-notifications').html(`
            <li class="list-group-item list-group-item-action dropdown-notifications-item">
                <div class="d-flex">
                    <div class="flex-grow-1 text-center">
                        <p class="mb-0 p-2">Nenhuma notificação... 🔔</p>
                    </div>
                </div>
            </li>
        `);
       
        return;
    }

    let html = '';
    data.forEach(el => {
        switch (el.categoria) {
            case 3:
                html += showCategorieThree(el);
                break;
            case 6:
                html += showCategorieSix(el);
                break;
        
            default:
                break;
        }
    });

    $('#list-notifications').html(html);
}

/**
 * CATEGORIA 3
 */
function showCategorieThree(el) {

    return `<li class="list-group-item list-group-item-action dropdown-notifications-item">
            <div class="d-flex">
                <div class="flex-shrink-0 me-3">
                    <div class="avatar">
                        <span class="avatar-initial rounded-circle bg-label-primary"><i class="bx bx-dollar-circle"></i></span>
                    </div>
                </div>
                <div class="flex-grow-1">
                    <h6 class="mb-1">${el.nome}</h6>
                    <p class="mb-0" style="font-size: 12px">Solicitou desconto em um orçamento</p>
                    <small class="text-muted">${el.tempo_passado}</small>
                </div>
                <div class="flex-shrink-0 dropdown-notifications-actions">
                    <a href="javascript:void(0)" class="dropdown-notifications-read"><span class="badge badge-dot"></span></a>
                    <a href="javascript:void(0)" class="dropdown-notifications-archive"><span class="bx bx-x"></span></a>
                </div>
            </div>
        </li>` 
}

/**
 * CATEGORIA 6
 */
function showCategorieSix(el) {

    return `<li class="list-group-item list-group-item-action dropdown-notifications-item">
            <div class="d-flex">
                <div class="flex-shrink-0 me-3">
                    <div class="avatar">
                        <span class="avatar-initial rounded-circle bg-label-primary"><i class="bx bx-dollar-circle"></i></span>
                    </div>
                </div>
                <div class="flex-grow-1">
                    <h6 class="mb-1">${el.nome}</h6>
                    <p class="mb-0" style="font-size: 12px">${el.descricao}</p>
                    <small class="text-muted">${el.tempo_passado}</small>
                </div>
                <div class="flex-shrink-0 dropdown-notifications-actions">
                    <a href="javascript:void(0)" class="dropdown-notifications-read"><span class="badge badge-dot"></span></a>
                    <a href="javascript:void(0)" class="dropdown-notifications-archive"><span class="bx bx-x"></span></a>
                </div>
            </div>
        </li>` 
}


var alertTimeout = null;

function fat_alert(prop) {
    if (alertTimeout) {
        clearTimeout(alertTimeout);
        alertTimeout = null;
    }

    if ( $('#fat-alert').length > 0) $("#fat-alert").remove();

    const icon  = prop.type == 'danger' ? 'bx-error' : 'bx-bell';

    let html = `
        <div id="fat-alert" class="bs-toast toast toast-placement-ex m-2 fade bg-${prop.type} bottom-0 end-0 show" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <i class="bx ${icon} me-2"></i>
                <div class="me-auto fw-semibold">${prop.title}</div>
                <small id="toast-error-timer-regressive"></small>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">${prop.message}</div>
        </div>`;

    $('body').append(html);

    if (prop.timer > 0 ) {
        alertTimeout = setTimeout(function() {
            $("#fat-alert").remove();
        }, prop.timer);
    }

    if (prop.callback) {
        prop.callback();
    }
}

function getContatosPendentes() {
    return $.ajax({
        method: 'GET',
        dataType: 'JSON',
        url: `../app/Core/Contact.php?action=getContatosPendentesSidebar`,
        success: function (data) {
            $('#setQtdContatosSolicitacoesRetornar').html(data.qtd);
            // console.log(data);
        },
        error: function (err) {
            $('#setQtdContatosSolicitacoesRetornar').html('0');
            console.log(err);
        }
    });
}

setTimeout(() => {
    getContatosPendentes();
}, 1000);


if (!window.location.href.includes(".com")) {
    $('.welcome-text').html('<strong>AMBIENTE DE DESENVOLVIMENTO</strong>').addClass('text-danger');
}
