function fat_alert(prop) {
    if ( $('#fat-alert').length > 0) $("#fat-alert").remove();

    const icon  = prop.type == 'danger' ? 'bx-error' : 'bx-bell';

    let html = `
        <div id="fat-alert" class="bs-toast toast toast-placement-ex m-2 fade bg-${prop.type} bottom-0 end-0 show" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <i class="bx ${icon} me-2"></i>
                <div class="me-auto fw-semibold">${prop.title}</div>
                <small id="toast-error-timer-regressive"></small>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">${prop.message}</div>
        </div>`;

    $('body').append(html);

    if (prop.timer > 0 ) {
        setTimeout(function() {
            $("#fat-alert").remove();
        }, prop.timer);
    }

    if (prop.callback) {
        prop.callback();
    }
}

function validateLogin() {
    const mail = $('#mail').val();
    const pass = $('#pass').val();

    if (!isValidEmail(mail)) return;

    if ((pass.length < 6 || pass.length > 50)) {
        fat_alert({
            title: 'Erro ao fazer login',
            message: 'A senha deve conter entre 6 e 50 caracteres',
            type: 'danger',
            timer: 3000
        });
        return;
    }

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: 'app/Core/Login.php',
        data: {
            action: "login",
            mail: mail,
            pass: pass
        },
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Login efetuado com sucesso!',
                timer: 3000
            });

            setTimeout(function () {
                window.location.href = 'view/index.php'
            }, 500);

        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

$(document).ready(function () {
    $('#show-password').click(function () {
        const passwordInput = $('#pass');
        const passwordEyeIcon = $('#show-password');
        const fieldType = passwordInput.attr('type');

        passwordInput.attr('type', 'password');
        passwordEyeIcon.find('i').removeClass('bx bx-show');
        passwordEyeIcon.find('i').addClass('bx bx-hide');

        if (fieldType === 'password') {
            passwordInput.attr('type', 'text');
            passwordEyeIcon.find('i').removeClass('bx bx-hide');
            passwordEyeIcon.find('i').addClass('bx bx-show');
        }
    });
});

$('#pass, #mail').on('keypress', function (e) {
    if (e.which == 13) {
        $('#btn-access').click();
    }
});

$('#btn-access').on('click', validateLogin);
