function order(data, order = 'ASC')
{
    if (order === 'ASC') {
        data.sort(function(a, b) {
            if (a > b) return 1;
            if (a < b) return -1;
            return 0;
        });
    
        return data;
    }

    data.sort(function(a, b) {
        if (a > b) return -1;
        if (a < b) return 1;
        return 0;
    });

    return data;
}

function activeMaskMoney() {
    $('input[data-mask-money]').maskMoney({
        prefix:'R$ ',
        allowNegative: true,
        thousands:'.', decimal:',',
        affixesStay: true
    });
}

function isValidDateTime(datetime) {
    const pattern = /^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/;
    return pattern.test(datetime);
}

function isRealValue(value) {
    const regex = /^R\$\s?\d{1,3}(\.\d{3})*(,\d{2})?$/;
    return regex.test(value);
}

function isNumber(input) {
    return /^\d+$/.test(input);
}
  
function toDollar(realValue) {
    if (!realValue) {
        return parseFloat(0).toFixed(2);
    }

    const realNumber = parseFloat(realValue.replace(/[R$.,]/g, '')) / 100;
    return realNumber.toFixed(2);
}
  
function onlyUnique(value, index, self) {
    return self.indexOf(value) === index;
}

var formatter = new Intl.NumberFormat('pt-BR', {
    style: 'currency',
    currency: 'BRL'
});

function loading(param = true) {
    const element_loading = document.getElementById("loading");

    if (param === true) {
        element_loading.style.display = "block";
        return;
    }

    element_loading.style.display = "none";
}

function isValidateImageExtension(fileName) {
    const pattern = /\.(jpeg|jpg|png|gif)$/i;
    return pattern.test(fileName);
}

function isTrue(str) {
    if (String(str).toLowerCase() == "true") {
        return 1;
    }

    return 0;
}

function defaultError() {
    loading(false);
    
    Swal.fire({
        icon: 'error',
        title: 'Oops...',
        text: 'Ocorreu um erro ao processar sua solicitação, atualize a página e tente novamente!',
        footer: '<a href="mailto:suporte@fattos.com.br">Entrar em contato com o suporte</a>'
    });
}

function isImage(filename) {
    const extensao = filename.split('.').pop().toLowerCase();

    return ['jpg', 'jpeg', 'gif', 'bmp', 'png'].indexOf(extensao) !== -1;
}

function isPdf(filename) {
    if (!filename) {
        return false;    
    }

    const extensao = filename.toString().split('.').pop().toLowerCase();

    return ['pdf'].indexOf(extensao) !== -1;
}

function getTypeFile(filename) {
    return filename.split('.').pop();
}

function sanitizeValueBr(valor) {
    const removedBR = valor.replace('R$', '');
    const valorSemPontos = removedBR.replace(/\./g, "");
    const valorFormat = valorSemPontos.replace(",", ".");
    return valorFormat;
}
  
function isAllNumbers(valor) {
    if (valor == '') {
        return false;
    }

    return !isNaN(valor) && (Number.isInteger(Number(valor)) || !Number.isNaN(parseFloat(valor)));
}

function isFile(filename) {
    if (!filename) {
        return false;
    }

    const validExtensions = ['doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', 'txt', 'csv', 'json', 'xml', 'psd', 'ai', 'eps', 'wav', 'mp3', 'mp4', 'avi', 'mkv', 'mov', 'wmv', 'zip', 'rar', '7z', 'tar', 'gz', 'bz2', 'dmg', 'iso', 'exe', 'bat', 'sh', 'jar', 'java', 'py', 'js', 'html', 'css', 'php', 'rb', 'cpp', 'c', 'h', 'hpp', 'md', 'aac', 'ac3', 'aiff', 'asf', 'asx', 'bin', 'cab', 'cbr', 'cbz', 'chm', 'class', 'conf', 'cpio', 'cr2', 'cue', 'deb', 'dll', 'dng', 'dylib', 'ear', 'eot', 'evtx', 'fnt', 'fon', 'h264', 'ico', 'ini', 'jp2', 'jpf', 'jpx', 'key', 'kml', 'kmz', 'lnk', 'm', 'mid', 'midi', 'mobi', 'mod', 'msi', 'nes', 'odg', 'otf', 'part', 'pcx', 'pdb', 'pem', 'pict', 'pkg', 'pls', 'ppm', 'pps', 'ps', 'ps1', 'pspimage', 'pyc', 'rpm', 'rss', 's7z', 'sitx', 'sql', 'svgz', 'swc', 'tar.bz2', 'tbz', 'tgz', 'tga', 'thmx', 'ttf', 'vob', 'vsd', 'webp', 'wma', 'woff', 'woff2', 'wps', 'xlr', 'xpi', 'xps', 'yaml', 'z', 'Z'];
    const extension = filename.toString().split('.').pop();

    return validExtensions.includes(extension);
}

function numberToBRLvalue(valor) {
    const valorFormatado = valor.toFixed(2).replace(".", ",");
    return valorFormatado.replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1.").replace(",", ".");
}

function isEmail(email) {
    const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return regex.test(email);
}

function getTypeColumn(tipoInfo) {
    const id = parseInt(tipoInfo);

    const paramType = {
        1:  'i', // Numérico
        2:  's', // Texto
        3:  'd', // Real BRL
        4:  's', // Texto
        5:  's', // Data
        6:  's', // Data e hora
        7:  's', // Imagem
        8:  's', // Anexos
        9:  's', // Não definido...
        10: 'i'  // Categorias
    };

    if (paramType.hasOwnProperty(id)) {
        return paramType[id];
    }

    return false;
}

function getNivelById(id) {
    switch (parseInt(id)) {
        case 1:
            return 'Cliente';
            break;
        case 2:
            return 'Vendedor(a)'
            break;
        case 3:
            return 'Arquiteto(a)'
            break;
        case 9:
            return 'Administrador(a)';
            break;
        default:
            'Erro ao processar'
    }
}


function masksUtils(mask) {
    switch (mask) {
        case 'telefone':
            $('.mask-telefone').mask('(00) 0000-0000');
            break;
        case 'whatsapp':
            $('.mask-whatsapp').mask('(00) 00000-0000');
            break;
        case 'cpf':
            $('.mask-cpf').mask('000.000.000-00');
            break;
        case 'cnpj':
            $('.mask-cnpj').mask('00.000.000/0000-00');
            break;
        case 'cep':
            $('.mask-cep').mask('00000-000');
            break;
        default:
            break;
    }
}

function isRequiredInputs(inputs) {
    let inputNotNull = true;
    $.each(inputs, function(index, input) {
        if (!input || input.length === 0 || input === "") {
            fat_alert({
                title: 'Campos obrigatórios',
                message: 'Por favor, preencha todos os campos obrigatórios.',
                type: 'danger',
                timer: 2000
            });

            inputNotNull = false;
            return false;
        }
    });

    return inputNotNull;
}

function isValidNivel(nivel) {
    if (!nivel || nivel == '') {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'Por favor, selecione o nível de acesso',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    return true;
}

function isValidName(nome) {
    if (nome.length < 5 || nome.length > 100) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'O nome do usuário deve conter entre 5 e 100 caracteres',
            type: 'danger',
            timer: 2000
        });

        return false;
    }

    return true;
}

function isValidEmail(email) {
    if (!isEmail(email)) {
        fat_alert({
            title: 'Erro!',
            message: 'Por favor, insira um endereço de e-mail válido',
            type: 'danger',
            timer: 2000
        });
        return false;
    }
    return true;
}

function isValidPassword(password, passwordAgain) {
    if ((password.length < 6 || password.length > 50)) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'A senha deve conter entre 6 e 50 caracteres',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    if (password !== passwordAgain) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'As senhas não correspondem',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    return true;
}

function valideteSizeByTagId(selector, max_size) {
    let count_size = 0;

    if (typeof $(selector)[0].files[0] !== 'undefined') {
        count_size += $(selector)[0].files[0].size ?? 0;
    }

    if (count_size > max_size) {
        fat_alert({
            type: 'danger',
            title: 'Erro ao cadastrar',
            message: `A imagem não pode ultrapassar ${(max_size / 1024 / 1024)}MB`,
            timer: 3000
        });
        return false;
    }

    return true
}

function isValidCpf(cpf) {
    const cpfRegex = /^\d{3}\.?\d{3}\.?\d{3}-?\d{2}$/;
    if (!cpfRegex.test(cpf)) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'CPF inválido.',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    cpf = cpf.replace(/\D/g, '');

    if (/^(\d)\1{10}$/.test(cpf)) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'CPF inválido.',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    let soma = 0;
    for (let i = 0; i < 9; i++) {
        soma += parseInt(cpf.charAt(i)) * (10 - i);
    }
    let resto = soma % 11;
    let digito1 = resto < 2 ? 0 : 11 - resto;

    soma = 0;
    for (let i = 0; i < 10; i++) {
        soma += parseInt(cpf.charAt(i)) * (11 - i);
    }
    resto = soma % 11;
    let digito2 = resto < 2 ? 0 : 11 - resto;

    let cpfIsValid = parseInt(cpf.charAt(9)) === digito1 && parseInt(cpf.charAt(10)) === digito2;
    if (!cpfIsValid) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'CPF inválido.',
            type: 'danger',
            timer: 3000
        });
    }

    return cpfIsValid;
}

function isValidCnpj(cnpj) {
    const cnpjRegex = /^\d{2}\.?\d{3}\.?\d{3}\/?\d{4}-?\d{2}$/;
    if (!cnpjRegex.test(cnpj)) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'CNPJ inválido.',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    cnpj = cnpj.replace(/\D/g, '');

    if (/^(\d)\1{13}$/.test(cnpj)) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'CNPJ inválido.',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    let soma = 0;
    let peso = 2;
    for (let i = 11; i >= 0; i--) {
        soma += parseInt(cnpj.charAt(i)) * peso;
        peso = peso == 9 ? 2 : peso + 1;
    }
    let resto = soma % 11;
    let digito1 = resto < 2 ? 0 : 11 - resto;

    soma = 0;
    peso = 2;
    for (let i = 12; i >= 0; i--) {
        soma += parseInt(cnpj.charAt(i)) * peso;
        peso = peso == 9 ? 2 : peso + 1;
    }
    resto = soma % 11;
    let digito2 = resto < 2 ? 0 : 11 - resto;

    let cnpjIsValid = parseInt(cnpj.charAt(12)) === digito1 && parseInt(cnpj.charAt(13)) === digito2;
    if (!cnpjIsValid) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'CNPJ inválido.',
            type: 'danger',
            timer: 3000
        });
    }

    return cnpjIsValid;
}

function carregarEndereco(cep) {
    let info = {};
    cep = cep.replace(/\D/g, '');

    if (cep.length !== 8) {
        console.log('CEP inválido');
        return {};
    }

    const url = `https://viacep.com.br/ws/${cep}/json/`;

    $.ajax({
        async: false,
        url: url,
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            console.log(data)
            if (data.erro) return {};
            info = data;
        },
        error: function (xhr) {
            console.log('Erro na requisição');
            return {};
        }
    });

    return info;
}

function formatData(data) {
    const dataObj = new Date(data);
    const dia = String(dataObj.getDate()).padStart(2, '0');
    const mes = String(dataObj.getMonth() + 1).padStart(2, '0');
    const ano = dataObj.getFullYear();
    return dia + '/' + mes + '/' + ano;
}

function showImage(image) {
    $('#modal-show-img').modal('show');
    $('#show-image').attr('src', image);
}

