const path_core = '../app/Core/';

function loadMasks() {
    masksUtils('telefone');
    masksUtils('whatsapp');
    masksUtils('cep');
    toggleMaskCpfCnpj();
}

function createCustomer() {
    const nome = $('#nome-modal-create-customer').val().trim();
    const email = $('#email-modal-create-customer').val().trim();
    const cpfCnpj = $('#cpf-cnpj-modal-create-customer').val().trim();
    const cep = $('#zip-code-modal-create-customer').val().trim();
    const bairro = $('#bairro-modal-create-customer').val().trim();
    const endereco = $('#logradouro-modal-create-customer').val().trim();
    const cidade = $('#cidade-modal-create-customer').val().trim();
    const estado = $('#state-modal-create-customer').val().trim();
    const numero = $('#number-modal-create-customer').val().trim();
    const complemento = $('#complement-modal-create-customer').val().trim();
    const inscricaoEstadual = $('#inscricao-estadua-modal-create-customer').val().trim();
    const pessoaJuridica = $('#cpf-cnpj-checked-box-create').is(':checked') ? 1 : 0;
    let regimeTributario = $('#select-regime-tributario-modal-create-customer').val();
    const telefone = $('#telefone-modal-create-customer').val().trim();
    const celular = $('#celular-modal-create-customer').val().trim();
    const linkRedeSocial = $('#link-rede-social-modal-create-customer').val().trim();
    const redeSocial = $("#select-rede-social-modal-create-customer").val();
    const logo = $('#logo-modal-create-customer')[0].files[0];
    const origem = $('#select-origem-modal-create-customer').val();
    let data = new FormData();

    const inputsRequired = [nome];
    const addressArray = [cep, bairro, endereco, cidade, estado, numero];

    if (!isRequiredInputs(inputsRequired)) return;
    if (!isValidName(nome)) return;
    // if (!isValidEmail(email)) return;

    if ($('#cpf-cnpj-checked-box-create').is(':checked') && cpfCnpj.length > 0) {
        if (!isValidCnpj(cpfCnpj)) return;
    }

    if (!$('#cpf-cnpj-checked-box-create').is(':checked')) {
        regimeTributario = '';
    }

    if (!$('#cpf-cnpj-checked-box-create').is(':checked') && cpfCnpj.length > 0) {
        if (!isValidCpf(cpfCnpj)) return;
    }

    if (!validateAddressFields(addressArray)) return;
    if (!isValidContact(telefone, celular)) return;
    if (!isValidSocialMedia(linkRedeSocial)) return;
    if (!valideteSizeByTagId($('#logo-modal-create-customer'), (5 * 1024 * 1024))) return;

    data.append('nome', nome);
    data.append('email', email);
    data.append('cpfCnpj', cpfCnpj);
    data.append('cep', cep);
    data.append('bairro', bairro);
    data.append('endereco', endereco);
    data.append('cidade', cidade);
    data.append('estado', estado);
    data.append('numero', numero);
    data.append('complemento', complemento);
    data.append('inscricaoEstadual', inscricaoEstadual);
    data.append('pessoaJuridica', pessoaJuridica);
    data.append('regimeTributario', regimeTributario);
    data.append('telefone', telefone);
    data.append('celular', celular);
    data.append('linkRedeSocial', linkRedeSocial);
    data.append('redeSocial', redeSocial);
    data.append('logo', logo);
    data.append('origemCliente', origem);
    data.append('action', 'store');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Customer.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Cliente cadastrado com sucesso!',
                timer: 3000
            });

            $('#modal-new-customer').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON ? xhr.responseJSON : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function openModalUpdateCustomer(id) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Customer.php`,
        data: {
            action: 'getCustomer',
            idCustomer: id
        },
        success: function (data) {
            loadMasks();
            renderVendedores(function() {
                $('.render-vendedores').val(data.created_by).trigger('change');
            });

            $('#modal-edit-customer-id').val(id);
            $('#nome-modal-edit-customer').val(data.nome);
            $('#email-modal-edit-customer').val(data.email);
            
            $('#cpf-cnpj-checked-box-edit').prop('checked', false);

            if (data.pessoa_juridica === 1) {
                masksUtils('cnpj');
                $('#cpf-cnpj-checked-box-edit').prop('checked', true);
                $('#div-regime-tributario-modal-edit-customer').show();
                $('#div-inscricao-estadua-modal-edit-customer').show();
                $('#cpf-cnpj-modal-edit-customer').val(data.cpf_cnpj);
                $('#select-regime-tributario-modal-edit-customer').val(data.regime);
                $('#inscricao-estadua-modal-edit-customer').val(data.insc_estadual);
            } else {
                masksUtils('cpf');
                $('#cpf-cnpj-checked-box-edit').prop('checked', false);
                $('#cpf-cnpj-modal-edit-customer').val(data.cpf_cnpj)
                $('#select-regime-tributario-modal-edit-customer').val('');
                $('#inscricao-estadua-modal-edit-customer').val('');
                $('#div-regime-tributario-modal-edit-customer').hide();
                $('#div-inscricao-estadua-modal-edit-customer').hide();
            }


            $('#select-origem-modal-edit-customer').val(data.origem);
            $('#telefone-modal-edit-customer').val(data.telefone);
            $('#celular-modal-edit-customer').val(data.celular);
            $('#zip-code-modal-edit-customer').val(data.cep);
            $('#bairro-modal-edit-customer').val(data.bairro);
            $('#cidade-modal-edit-customer').val(data.cidade);
            $('#logradouro-modal-edit-customer').val(data.endereco);
            $('#state-modal-edit-customer').val(data.estado);
            $('#number-modal-edit-customer').val(data.numero);
            $('#complement-modal-edit-customer').val(data.complemento);
            $('#link-rede-social-modal-edit-customer').val(data.link_rede_social);
            $('#select-rede-social-modal-edit-customer').val(data.rede_social);

            $('#modal-edit-customer').modal('show');
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
        }
    });
}

function updateCustomer() {
    const id = $('#modal-edit-customer-id').val();
    const pessoaJuridica = $('#cpf-cnpj-checked-box-edit').is(':checked') ? 1 : 0;
    const nome = $('#nome-modal-edit-customer').val();
    const email = $('#email-modal-edit-customer').val().trim();
    const cpfCnpj = $('#cpf-cnpj-modal-edit-customer').val();
    const cep = $('#zip-code-modal-edit-customer').val();
    const bairro = $('#bairro-modal-edit-customer').val();
    const endereco = $('#logradouro-modal-edit-customer').val();
    const cidade = $('#cidade-modal-edit-customer').val();
    const estado = $('#state-modal-edit-customer').val();
    const numero = $('#number-modal-edit-customer').val();
    const complemento = $('#complement-modal-edit-customer').val();
    const inscricaoEstadual = $('#inscricao-estadua-modal-edit-customer').val();
    let regimeTributario = $('#select-regime-tributario-modal-edit-customer').val();
    const telefone = $('#telefone-modal-edit-customer').val();
    const celular = $('#celular-modal-edit-customer').val();
    const redeSocial = $('#select-rede-social-modal-edit-customer').val();
    const linkRedeSocial = $('#link-rede-social-modal-edit-customer').val();
    const logo = $('#logo-modal-edit-customer')[0].files[0];
    const origem = $('#select-origem-modal-edit-customer').val();
    const idVendedor = $('#select-vendedor-modal-edit-customer').val();

    let data = new FormData();

    const inputs = [nome];
    const addressArray = [cep, bairro, endereco, cidade, estado, numero];

    if (!isRequiredInputs(inputs)) return;
    if (!isValidName(nome)) return;
    // if (!isValidEmail(email)) return;

    if (pessoaJuridica === 0) {
        regimeTributario = '';
        // if (!isValidTaxRegime(regimeTributario)) return;
    }

    if (pessoaJuridica === 1 && cpfCnpj.length > 0) {
        if (!isValidCnpj(cpfCnpj)) return;
    }

    if (pessoaJuridica === 0 && cpfCnpj.length > 0) {
        if(!isValidCpf(cpfCnpj)) return;
    }

    // if (!validateAddressFields(addressArray)) return;
    if (!isValidContact(telefone, celular)) return;
    // if (!isValidSocialMedia(linkRedeSocial)) return;
    if (!valideteSizeByTagId($('#logo-modal-edit-customer'), (5 * 1024 * 1024))) return;

    data.append('id', id);
    data.append('pessoaJuridica', pessoaJuridica);
    data.append('nome', nome);
    data.append('email', email);
    data.append('cpfCnpj', cpfCnpj);
    data.append('cep', cep);
    data.append('bairro', bairro);
    data.append('endereco', endereco);
    data.append('cidade', cidade);
    data.append('estado', estado);
    data.append('numero', numero);
    data.append('complemento', complemento);
    data.append('inscricaoEstadual', inscricaoEstadual);
    data.append('regimeTributario', regimeTributario);
    data.append('telefone', telefone);
    data.append('celular', celular);
    data.append('redeSocial', redeSocial);
    data.append('linkRedeSocial', linkRedeSocial);
    data.append('idVendedor', idVendedor);
    data.append('logo', logo);
    data.append('origemCliente', origem);
    data.append('action', 'update');

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Customer.php`,
        contentType: false,
        processData: false,
        data: data,
        success: function (data) {
            console.log(data);
            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Cliente atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-edit-customer').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            const errorMessage = xhr.responseJSON && xhr.responseJSON ? xhr.responseJSON : 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.';
            fat_alert({
                title: 'Erro',
                message: errorMessage,
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function modalShowStatusCustomer(id, status, name) {
    if (status === 1) {
        $('#modal-customer-toggle-status-title').html('Desativar usuário');
        $('#modal-customer-toggle-status-message').html('Você quer realmente desativar o cliente <b>' + name + '</b>?');
    } else if (status === 0) {
        $('#modal-customer-toggle-status-title').html('Ativar usuário');
        $('#modal-customer-toggle-status-message').html('Você quer realmente ativar o cliente <b>' + name + '</b>?');
    }

    $('#modal-customer-status-id').val(id);
    $('#modal-customer-status-current-status').val(status);
    $('#modal-customer-status-name').val(name);
    $('#modal-customer-status').modal('show')
}

function toggleStatusUser() {
    const id = $('#modal-customer-status-id').val();
    const status = $('#modal-customer-status-current-status').val();
    const name = $('#modal-customer-status-name').val();

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Customer.php`,
        data: {
            action: 'changeCustomerStatus',
            id: id,
            status: status
        },
        success: function (data) {
            console.log(data)
            let liText = (data.status === 1) ? "Desativar" : "Reativar";
            let liOption = `<button class='dropdown-item' type='button' onclick='modalShowStatusCustomer(${id}, ${data.status}, "${name}")'>${liText}</button>`;

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Status atualizado com sucesso!',
                timer: 3000
            });

            $('#modal-customer-status').modal('hide');

            setTimeout(function () {
                window.location.reload();
            }, 500);
        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });

            return false;
        }
    });
}

function isValidTaxRegime(regimeTributario) {
    if (regimeTributario === "" || regimeTributario.length !== 2) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'Selecione o regime tributário',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    return true;
}

function isValidSocialMedia(redeSocial) {
    if (redeSocial.length > 30) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'O limite máximo é de 30 caracteres..',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    return true;
}

function validateAddressFields(addressArray) {
    const filledFields = addressArray.filter(field => field.trim() !== '');
    if (filledFields.length > 0 && filledFields.length !== addressArray.length) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'Todos os campos de endereço são obrigatórios',
            type: 'danger',
            timer: 3000
        });
        return false;
    }

    return true;
}

function isValidContact(telefone, celular) {
    if (telefone.length > 1 && telefone.length !== 14) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'O numero de telefone está incorreto.',
            type: 'danger',
            timer: 3000
        });

        return false;
    }

    if (celular.length > 1 && celular.length !== 15) {
        fat_alert({
            title: 'Erro ao cadastrar',
            message: 'O numero de celular está incorreto.',
            type: 'danger',
            timer: 3000
        });
        return false;

    }

    return true;
}

$('.zip-code-input').on('blur', function () {
    const infoCep = carregarEndereco($(this).val());

    $('.invalid-cep').css({
        'display': 'none'
    });

    if (Object.keys(infoCep).length === 0) {
        $('.invalid-cep').css({
            'display': 'block'
        });

        $('.logradouro-input').val('');
        $('.bairro-input').val('');
        $('.city-input').val('');
        $('.state-input').val('');

        return;
    }

    $('.logradouro-input').val(infoCep.logradouro);
    $('.bairro-input').val(infoCep.bairro);
    $('.city-input').val(infoCep.localidade);
    $('.state-input').val(infoCep.uf);
});

$('#modal-new-customer').on('hidden.bs.modal', function () {
    $('input, select').val('');
    $('.invalid-cep').css({
        'display': 'none'
    });
});


function toggleMaskCpfCnpj(modal) {
    const cpfCnpjCheckedBox = modal === 'create' ? $('#cpf-cnpj-checked-box-create') : $('#cpf-cnpj-checked-box-edit');
    const regimeTributarioDiv = modal === 'create' ? $('#div-regime-tributario-modal-create-customer') : $('#div-regime-tributario-modal-edit-customer');
    const inscricaoEstadualDiv = modal === 'create' ? $('#div-inscricao-estadua-modal-create-customer') : $('#div-inscricao-estadua-modal-edit-customer');

    $('#cpf-cnpj-modal-create-customer').val('');
    $('#cpf-cnpj-modal-edit-customer').val('');

    if (cpfCnpjCheckedBox.is(':checked')) {
        masksUtils('cnpj');
        regimeTributarioDiv.show();
        inscricaoEstadualDiv.show();
        return;
    }

    masksUtils('cpf');
    regimeTributarioDiv.hide();
    inscricaoEstadualDiv.hide();
    $('#select-regime-tributario-modal-create-customer').val('');
    $('#inscricao-estadua-modal-create-customer').val('');
}

$('#cpf-cnpj-checked-box-create').on('change', function() {
    toggleMaskCpfCnpj('create');
});

$('#cpf-cnpj-checked-box-edit').on('change', function() {
    toggleMaskCpfCnpj('edit');
});
$('#id-modal-new-customer').on('click', loadMasks);
$('#btn-add-edit-customer').on('click', updateCustomer);
$('#btn-modal-customer-status').on('click', toggleStatusUser);


function renderVendedores(callback = null) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}User.php`,
        data: {
            action: 'getNameAndId'
        },
        success: function (data) {
            let html = '';

            data.forEach(vendedor => {
                html += `<option value='${vendedor.id}'>${vendedor.nome}</option>`;
            });

            $('.render-vendedores').html(html);

            if (callback) {
                callback();
            }
        },
        error: function (xhr) {
            console.log(xhr);
            defaultError();
        }
    });
}