const { createApp } = Vue;

createApp({
    data() {
        return {
            items: [],
            userLevel: 0,
            templatePaginate: '',
            currentPage: 1,
            textFilter: '',
            tipoFilter: 0,
            vendedorFilter: '',
            ordenacaoFilter: 'id:desc',
            dateRangeFilter: `01/10/2023 - ${this.formatDate(new Date())}`,
            filters: {}
        };
    },
    created() {
        this.fetchUserLevel();
        this.fetchData();
    },
    methods: {
        fetchUserLevel() {
            $.ajax({
                url: `${path_core}/User.php?action=getDadosUsuarioSessao`,
                method: 'GET',
                dataType: 'JSON',
                success: (response) => {
                    this.userLevel = response.nivel;
                },
                error: (xhr, status, error) => {
                    console.error('Erro ao buscar nível do usuário:', error);
                }
            });
        },
        fetchData(page = 1, filters = this.filters) {
            const { text, tipo, vendedor, ordenacao, startDate, endDate } = filters;
            let url = `${path_core}Contact.php?action=show&page=${page}&limit=10`;

            if (text) url += `&filter=${text}`;
            if (tipo) url += `&tipo=${tipo}`;
            if (vendedor) url += `&vendedor=${vendedor}`;
            if (ordenacao) url += `&order=${ordenacao}`;
            if (startDate && endDate) url += `&startDate=${startDate}&endDate=${endDate}`;

            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'JSON',
                success: (response) => {
                    this.templatePaginate = response.pages;
                    this.items = response.data;
                    this.currentPage = page;
                    this.$nextTick(() => {
                        this.bindPaginationEvents();
                        this.colorirDataRetornoParaDiaAtual();
                        setActions();
                    });
                },
                error: (xhr, status, error) => {
                    console.error('Erro ao buscar dados:', error);
                }
            });
        },
        changePageDynamic(page) {
            this.fetchData(page);
        },
        viewContactCliente(idCliente) {
            window.location.href = `contact.php?id=${idCliente}`;
        },
        showImage(image) {
            $('#modal-show-img').modal('show');
            $('#show-image').attr('src', image);
        },
        copyToClipboard(copyText) {
            navigator.clipboard.writeText(copyText);
            fat_alert({
                type: 'dark',
                title: 'Texto copiado',
                message: copyText,
                timer: 2500
            });
        },
        bindPaginationEvents() {
            document.querySelectorAll('.dynamic-btn-page').forEach(button => {
                button.addEventListener('click', (event) => {
                    const page = event.target.getAttribute('data-page');
                    this.changePageDynamic(page);
                });
            });
        },
        filtrarContato() {
            const picker = $('#filter-range-data-criacao').data('daterangepicker');
            const startDate = moment(picker.startDate).format('YYYY-MM-DD');
            const endDate = moment(picker.endDate).format('YYYY-MM-DD');

            this.filters = {
                text: this.textFilter,
                tipo: this.tipoFilter,
                vendedor: this.vendedorFilter,
                ordenacao: this.ordenacaoFilter,
                startDate: startDate,
                endDate: endDate,
            };

            this.fetchData(1, this.filters);
        },
        colorirDataRetornoParaDiaAtual() {
            $('td[data-retorno-ptbr]').each((i, el) => {
                const dataRetorno = $(el).attr('data-retorno-ptbr');
                const dataAtual = moment().format('DD/MM/YYYY');

                if (dataRetorno == dataAtual) {
                    const conteudoOriginal = $(el).find('small').html();
                    $(el).find('small').html(`<span style="background-color: yellow;"><strong>${conteudoOriginal}</strong></span>`);
                }
            });
        },
        formatDate(date) {
            const d = new Date(date);
            let day = '' + d.getDate();
            let month = '' + (d.getMonth() + 1);
            const year = d.getFullYear();

            if (day.length < 2) day = '0' + day;
            if (month.length < 2) month = '0' + month;

            return [day, month, year].join('/');
        },
        visualizaSolicitacao(idContato) {
        
            const response = getInfoContatoRetornado(idContato);

            $('#modal-atendimento-solicitacao-footer').addClass('d-none');
            $('#modal-atendimento-solicitacao-title').text('Visualizar solicitação');
            $('#modal-atendimento-solicitacao-cliente').val(response.data.nomeCliente);
            $('#modal-atendimento-solicitacao-contato').val(response.data.contato);
            $('#modal-atendimento-solicitacao-telefone').val(response.data.tel);
            $('#modal-atendimento-solicitacao-dialogo').val(response.data.dialogo);
            $('#modal-atendimento-solicitacao-solicitacoes').val(response.data.descricao_solicitacao);
            $('#modal-atendimento-solicitacao-destino-uso').val(response.data.destino_uso);

            var ptbrMoney = new Intl.NumberFormat('pt-BR', {
                style: 'currency',
                currency: 'BRL'
            });

            let htmlProdutos = '';
            response.produtos.forEach((produto) => {
                htmlProdutos +=  `
                    <div class="border border-1 p-2 rounded-1 mb-3">
                        <div class="row">
                            <div class="col-1">
                                <div class="form-group">
                                    <label for="" class="form-label">Qtd</label>
                                    <input readonly type="number" class="form-control" value="${produto.qtd_solicitado}">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group
                                ">
                                    <label for="" class="form-label">Descrição do item</label>
                                    <input readonly type="text" class="form-control" value="${produto.descricao_solicitado}">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group
                                ">
                                    <label for="" class="form-label">Produto retornado</label>
                                    <input readonly type="text" class="form-control" value="${produto.nomeProdutoRetornado}">
                                </div>
                            </div>
                            <div class="col-2">
                                <div class="form-group
                                ">
                                    <label for="" class="form-label">Tipo de personalização</label>
                                    <input readonly type="text" class="form-control" value="${produto.nomePersonalizacao}">
                                </div>
                            </div>
                            <div class="col-2">
                                <div class="form-group
                                ">
                                    <label for="" class="form-label">Valor objetivo</label>
                                    <input readonly type="text" class="form-control real" value="${ptbrMoney.format(produto.valor_objetivo_solicitado)}">
                                </div>
                            </div>
                        </div>
                    </div>
                `;

            });

            $('#modal-atendimento-solicitacao-renderiza-produtos-solicitados').html(htmlProdutos);

            $('#resposta-solicitacao-orcamento-contato').prop('readonly', true);

            $('#div-content-exists-anexo').addClass('d-none');

            if (response.data.fileZip) {
                $('#div-content-exists-anexo').removeClass('d-none');
                $('#modal-atendimento-solicitacao-anexos').prop('href', `assets/file/contacts/${response.data.fileZip}`);
            }

            $('#modal-atendimento-solicitacao').modal('show');
        }
    }
}).mount('#app');

const urlSearchParam = new URLSearchParams(window.location.search);

var minDateFilter;
var maxDateFilter;

$("#filter-range-data-criacao").daterangepicker({
    locale: {
        "format": 'DD/MM/YYYY',
        "applyLabel": 'Confirmar',
        "cancelLabel": 'Cancelar',
        "daysOfWeek": [
        "Dom",
        "Seg",
        "Ter",
        "Qua",
        "Qui",
        "Sex",
        "Sab"
    ],
        "monthNames": [
        "Jan",
        "Fev",
        "Mar",
        "Abr",
        "Mai",
        "Jun",
        "Jul",
        "Ago",
        "Set",
        "Out",
        "Nov",
        "Dez"
        ],
        "firstDay" : 0
    }
});

/**
 * Método responsável por abrir modal personalizado para converter um contato em orçamento
 * 
 * acredito que não estava sendo utilizado
 */
// function novoContatoParaOrcamento(idContato) {

//     const data = getInfoContato(idContato);

//     $('#dialog-client').val(data.dialogo);
//     $('#pessoa-contato').val(data.contato)
//     $('#select-customers').val(data.cliente).trigger('change');
//     $('#is-contact-to-budget').val(idContato);

//     if (html_clone_product == null) {
//         html_clone_product = $("#div-item").html();
//     }

//     $('.select-product').select2({
//         dropdownParent: $("#modal-new-budget"),
//         width: '100%'
//     });

//     $('#prevBtn').removeClass('d-none');
//     $('#modal-new-budget').modal('show');
// }

function getInfoContato(idContato) {
    let response;

    $.ajax({
        async: false,
        method: 'GET',
        url: `${path_core}Contact.php?action=getInfoByIdAndProducts&id=${idContato}`,
        dataType: 'JSON',
        success: (data) => {
            response = data;
        },
        error: (xhr) => {
            console.log('xhr');
        }
    });

    return response;
}

function getInfoContatoRetornado(idContato) {
    let response;

    $.ajax({
        async: false,
        method: 'GET',
        url: `${path_core}Contact.php?action=getInfoByIdAndProductsRetorno&id=${idContato}`,
        dataType: 'JSON',
        success: (data) => {
            response = data;
        },
        error: (xhr) => {
            console.log(xhr);
            
            console.log('xhr');
        }
    });

    return response;
} 

function novoContato() {
    if (html_clone_product == null) {
        html_clone_product = $("#div-item").html();
    }

    $('.select-product').select2({
        dropdownParent: $("#modal-new-contact"),
    });

    $('#prevBtnContact').removeClass('d-none');
    $('#modal-new-contact').modal('show');

    $('.select-product').select2({
        dropdownParent: $("#modal-new-contact"),
        width: '100%'
    });

    fat_alert({
        type: 'dark',
        title: 'Atenção 🧐',
        message: "Todos os campos com '*' são obrigatórios",
        timer: 4000
    });
}


$('#select-uf-contato').on('change', function() {
    const uf = $(this).val();

    $('#select-cidade-contato').val('').attr('disabled', true);


    if (uf == '') {
        return;
    }

    $.ajax({
        method: 'GET',
        url: `https://servicodados.ibge.gov.br/api/v1/localidades/estados/${uf}/distritos?orderBy=nome`,
        dataType: 'JSON',
        success: (data) => {

            $('#select-cidade-contato').attr('disabled', false);
            $('#select-cidade-contato').html('<option value="">Selecione a cidade</option>');

            data.forEach((city) => {
                $('#select-cidade-contato').append(`<option value="${city.nome}">${city.nome}</option>`);
            });

            $('#select-cidade-contato').select2({
                dropdownParent: $("#modal-new-contact"),
                width: '100%'
            });
        },
    })
})


$('#select-customers-contact').on('change', function() {
    const cliente = $(this).val();

    if ($.isNumeric(cliente)) {
        showDadosClienteFormNovoContato(cliente);
        showDialogosAnteioresClienteFormNovoContato(cliente);
        return;
    }

    $('#telefone-celular-contato, #select-uf-contato, #select-origem-modal-create-customer')
        .attr('disabled', false)
        .val('');

});

function showDadosClienteFormNovoContato(idCliente) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Customer.php`,
        data: {
            action: 'getCustomer',
            idCustomer: idCliente
        },
        success: function (data) {
            $('#telefone-celular-contato').val(data.celular || data.telefone);
            $('#select-uf-contato').val(data.estado);
            
            let option = data.cidade ? `<option value="${data.cidade}">${data.cidade}</option>` : '<option value="">Nenhum selecionado</option>';
            $('#select-cidade-contato').html(option);

            $('#telefone-celular-contato, #select-uf-contato, #select-cidade-contato, #select-origem-modal-create-customer').attr('disabled', true);

        },
        error: function(xhr) {
            console.log(xhr);
        }
    });
}

function showDialogosAnteioresClienteFormNovoContato(idCliente) {
    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Contact.php`,
        data: {
            action: 'getDialogsByCustomer',
            idCustomer: idCliente
        },
        success: function (data) {
            console.log(data);
            $('#dialogos-anteriores').html('<hr> <label class="form-label">Diálogos anteriores</label><br>');

            if (data.length == 0) {
                $('#dialogos-anteriores').append(`<label><small>Nada encontrando...</small></label>`);
            }

            data.forEach((info) => {
                $('#dialogos-anteriores').append(`<li><label class="form-label">${info.create_at}</label>: ${info.dialogo}</li>`);
            });

            $('#dialogos-anteriores').parent().removeClass('d-none');
        },
        error: function(xhr) {
            console.log(xhr);
        }
    });
}

/**
 * Redireciona para a página de contatos do cliente
 */
function viewContactCliente(idCliente) {
    window.location.href = `contact.php?id=${idCliente}`;
}

var isSolicitacaoContato = false; 
$('#select-categoria-contato').on('change', function() {
    const categoria = $(this).val();

    isSolicitacaoContato = false; 
    $('#div-solicitacao-orcamento-contato').addClass('d-none');
    $('#descricao-solicitacao-orcamento-contato').val('');
    $('#descricao-solicitacao-orcamento-anexo').val('');

    if (categoria == '2') {
        isSolicitacaoContato = true; 
        $('#div-solicitacao-orcamento-contato').removeClass('d-none');
    }
});

function setActions() {
    let idsFilter = [];

    $('td[data-acao-id-contato]').each((i, el) => {
        const idCliente = parseInt($(el).attr('data-acao-id-contato'));

        idsFilter.push(idCliente);
    });

    $.ajax({
        method: 'POST',
        url: `${path_core}Contact.php`,
        data: {
            action: 'getActions',
            ids: idsFilter
        },
        dataType: 'JSON',
        success: (res) => {      

            console.log(res);
            
            let data = res.data;

            data.forEach((info) => {
                idsFilter = idsFilter.filter(id => id !== info.id);

                if (info.status_contato == 1 && (res.userLevel == 8 || res.userLevel == 9)) {
                    $(`td[data-acao-id-contato="${info.id}"]`).html(`
                        <a href="#" onclick="novaSolicitacaoOrcamento(${info.id})">
                            <label class="form-label text-danger c-p">
                                <i class="bx bx-error-circle"></i>
                                <small><u><b>Solicitação<br> não atendida</b></u></small>
                            </label>
                        </a>
                    `);
                }

                else if (info.status_contato == 1 && res.userLevel < 3) {
                    $(`td[data-acao-id-contato="${info.id}"]`).html(`
                        <label class="form-label text-danger c-p">
                            <i class="bx bx-error-circle"></i>
                            <small><u><b>Aguarde a solicitação<br> ser atendida</b></u></small>
                        </label>
                    `);
                }

                else if (info.status_contato == 2) {
                    $(`td[data-acao-id-contato="${info.id}"]`).html(`
                        <a href="budgets-list.php?ref=${info.id}"">
                            <label class="form-label text-warning c-p">
                                <i class="bx bx-error-circle"></i>
                                <small><u><b>Orçamento<br>pendente</b></u></small>
                            </label>
                        </a>
                    `);
                }

                else {
                    $(`td[data-acao-id-contato="${info.id}"]`).html(`<i class="bx bx-check"></i>`);
                }

            });

            // Ids que estão todos em dia
            idsFilter.forEach((id) => {
                $(`td[data-acao-id-contato="${id}"]`).html(`<i class="bx bx-check"></i>`);
            });

            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        },
        error: (xhr) => {
            console.log(xhr);
        }
    });
}

var map;
function visualizaGeolocalizacaoVisita(idOrcamento) {
    $.ajax({
        method: 'GET',
        url: `${path_core}Contact.php?action=getGeolocalizacao&id=${idOrcamento}`,
        dataType: 'JSON',
        success: (data) => {
            var lat = data.latitude;
            var lon = data.longitude;

            $('#modal-geolocalizacao').on('shown.bs.modal', function () {
                if (map != undefined) { 
                    map.remove(); 
                }

                // Cria o mapa
                map = L.map('map').setView([lat, lon], 20);

                // Define a camada do mapa
                L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                    attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
                }).addTo(map);

                // Adiciona um marcador para a localização atual
                L.marker([lat, lon]).addTo(map).bindPopup('Localização do representante').openPopup();
            });

            $('#modal-geolocalizacao').modal('show');
        },
        error: (xhr) => {
            console.log(xhr);
        }
    });
}

function getUsuarios() {
    $.ajax({
        method: 'GET',
        url: `${path_core}User.php?action=getUsers`,
        dataType: 'JSON',
        success: (data) => {
            let html = '<option value="">Todos os vendedores</option>';

            data.forEach((user) => {
                html += `<option value="${user.id}">${user.nome}</option>`;
            });

            $('#tipo-filter-vendedor').html(html);

            if (urlSearchParam.has('vendedor')) {
                $('#tipo-filter-vendedor').val(urlSearchParam.get('vendedor'));
            }
        },
        error: (xhr) => {
            console.log(xhr);
        }
    });
}
getUsuarios();


 function novaSolicitacaoOrcamento(idContato) {
    const response = getInfoContato(idContato);

    $('#modal-atendimento-solicitacao-footer').removeClass('d-none');
    $('#modal-atendimento-solicitacao-title').text('Atender solicitação');
    $('#btn-atender-solicitacao').val(idContato);
    $('#modal-atendimento-solicitacao-cliente').val(response.data.nomeCliente);
    $('#modal-atendimento-solicitacao-contato').val(response.data.contato);
    $('#modal-atendimento-solicitacao-telefone').val(response.data.tel);
    $('#modal-atendimento-solicitacao-dialogo').val(response.data.dialogo);

    $('#modal-atendimento-solicitacao-destino-uso').val(response.data.destino_uso);

    let htmlProdutos = '';
    var cloneContentRetornaSolicitacao = '';

    $('#modal-atendimento-solicitacao-renderiza-produtos-solicitados').html('');

    response.produtos.forEach((produto, i) => {

        var ptbrMoney = new Intl.NumberFormat('pt-BR', {
            style: 'currency',
            currency: 'BRL'
        });
        
        htmlProdutos = `
            <div class="border border-2 p-2 rounded-1 mb-4 group-product-contact">
                <div class="row">
                    <div class="col">
                        <h6>Solicitado por ${response.data.nomeVendedor}</h6>
                    </div>
                </div>
                <div class="row">
                    <div class="col-1">
                        <div class="form-group">
                            <label for="" class="form-label">Qtd *</label>
                            <input readonly type="number" class="form-control" value="${produto.qtd_solicitado}">
                        </div>
                    </div>
                    <div class="col">
                        <div class="form-group">
                            <label for="" class="form-label">Descrição do item *</label>
                            <input readonly type="text" class="form-control" value="${produto.descricao_solicitado}">
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <label for="" class="form-label">Tipo de personalização</label>
                            <input readonly type="text" class="form-control" value="${produto.nomePersonalizacao}">
                        </div>
                    </div>
                    <div class="col-2">
                        <div class="form-group">
                            <label for="" class="form-label">Valor objetivo</label>
                            <input readonly type="text" class="form-control real" value="${ptbrMoney.format(produto.valor_objetivo_solicitado)}">
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col">
                        <h6>A serem retornado(s) por você</h6>
                    </div>
                </div>
                <div data-id-contato-solicitacao="${produto.id}">
                    <div class="row" data-clone-content-retorna-solicitacao data-content-product>
                        <div class="col">
                            <div class="form-group">
                                <label class="form-label" style="margin-bottom: 5px">Produto a retornar</label>
                                <select class="form-select select-product-contact">
                                    <option value="">Nenhum selecionado</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label for="" class="form-label">Tipo de personalização</label>
                                <select class="form-select select-tipo-personalizacao-retorno-solicitacao">
                                </select>
                            </div>
                        </div>
                        <div class="col-2">
                            <div class="form-group">
                                <label for="" class="form-label">QTD. Serviços</label>
                                <input type="number" class="form-control qtd-servico-retorno-solicitacao">
                            </div>
                        </div>
                    </div>
                    <div class="renderiza-content-adicionar-mais-produtos-retorno"></div>
                    <div class="row">
                        <div class="col">
                            <label class="form-label text-primary c-p btn-renderiza-mais-produtos-retorno"><u>Adicionar mais</u></label>
                        </div>
                    </div>
                </div>
            </div>
        `;

        $('#modal-atendimento-solicitacao-renderiza-produtos-solicitados').append(htmlProdutos);

        if (i == 0) {
            cloneContentRetornaSolicitacao = $('div[data-clone-content-retorna-solicitacao]').html();
        }
    });

    insereNovoProdutoRetornoSolicitacao();

    $('.btn-renderiza-mais-produtos-retorno').on('click', function() {

        const randomHash = Math.random().toString(36).substring(10);

        $(this)
            .closest('.group-product-contact')
            .find('.renderiza-content-adicionar-mais-produtos-retorno')
            .append(`<div class="row" data-content-product data-hash="${randomHash}">${cloneContentRetornaSolicitacao}</div>`);

        $(`div[data-hash="${randomHash}"]`).find('.select-product-contact:last').select2({
            language: "pt-BR",
            dropdownParent: $('#modal-atendimento-solicitacao'),
            width: '100%',
            minimumInputLength: 2,
            minimumResultsForSearch: 10,
            multiple: false, 
            ajax: {
                url: `${path_core}Product.php`,
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function (params) {
                    return {
                        action: 'buscarProduto',
                        search: params.term
                    };
                },
                processResults: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.id + ' - ' + item.nome,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
        
        $(`div[data-hash="${randomHash}"]`).find('.select-tipo-personalizacao-retorno-solicitacao:last').html(todosTiposPersonalizacaoOption);
    });


    $('#resposta-solicitacao-orcamento-contato').prop('readonly', false);
    $('#div-content-exists-anexo').addClass('d-none');

    if (response.data.fileZip) {
        $('#div-content-exists-anexo').removeClass('d-none');
        $('#modal-atendimento-solicitacao-anexos').prop('href', `assets/file/contacts/${response.data.fileZip}`);
    }

    $('#modal-atendimento-solicitacao').modal('show');
}


function activeLastedSelectProduct() {
    $('.select-product-contact:last').select2({
        language: "pt-BR",
        dropdownParent: $('#modal-atendimento-solicitacao'),
        width: '100%',
        minimumInputLength: 2,
        minimumResultsForSearch: 10,
        multiple: false, 
        ajax: {
            url: `${path_core}Product.php`,
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (params) {
                return {
                    action: 'buscarProduto',
                    search: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.id + ' - ' + item.nome,
                            id: item.id
                        }
                    })
                };
            }
        }
    });
}

function removeProductContact() {
    $(event.target).closest('div[data-agroupment-product-contact]').remove();
    validateDuplicateProduct();
}

$('#btn-atender-solicitacao').on('click', function() {
    const idContato = $(this).val();
    // const resposta = $('#resposta-solicitacao-orcamento-contato').val()
    let produtos = {};

    $('div[data-content-product]').each(function (i, el) {
        const idSolicitacao = $(this).closest('div[data-id-contato-solicitacao]').data('id-contato-solicitacao');
        
        if (!produtos[idSolicitacao]) {
            produtos[idSolicitacao] = [];
        }

        const produto = $(this).find('.select-product-contact:last').val() != '' ? parseInt($(this).find('.select-product-contact:last').val()) : '';
        const tipoPersonalizacao = $(this).find('.select-tipo-personalizacao-retorno-solicitacao:last').val() != '' ? parseInt($(this).find('.select-tipo-personalizacao-retorno-solicitacao:last').val()) : '';
        const qtdServicos = $(this).find('.qtd-servico-retorno-solicitacao:last').val() != '' ? parseInt($(this).find('.qtd-servico-retorno-solicitacao:last').val()) : 1;

        produtos[idSolicitacao].push({
            produto: produto,
            qtdServico: qtdServicos,
            tipoPersonalizacao: tipoPersonalizacao 
        });
    });


    $(this).attr('disabled', true);
    

    $.ajax({
        method: 'POST',
        url: `${path_core}Contact.php`,
        dataType: 'json',
        data: {
            action: 'atenderSolicitacaoOrcamentoContato',
            produtos: produtos,
            idContato: idContato
        },
        success: function (data) {
            
            fat_alert({
                type: 'primary',
                title: 'Successo!!!',
                message: 'Solicitação foi atendida com sucesso!',
                timer: 3000
            });

            setTimeout(() => {
                window.location.reload(false);
            }, 1000);
        },
        error: function(xhr) {
            console.log(xhr);

            fat_alert({
                title: 'Oops...',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });
        }
    })
});

$.ajax({
    type: 'GET',
    dataType: 'JSON',
    url: `${path_core}Categorias.php?action=reorganizaCategorias`,
    success: function (data) {
        let html = '<option value="">Nenhum selecionado</option>';

        for (let key in data) {
            if (data.hasOwnProperty(key)) {
                html += `<optgroup label="${key}">`;

                for (let el in data[key]) {
                    html += `<option value='${el}'>${data[key][el]}</option>`;
                }

                html += `</optgroup>`;
            }
        }

        $('#select-origem-modal-create-customer').html(html).select2({
            width: '100%',
            dropdownParent: $("#modal-new-contact")
        });
    },
    error: function (xhr) {
        console.log(xhr);
    }
});

var todosTiposPersonalizacaoOption = '';
$.ajax({
    type: 'GET',
    dataType: 'JSON',
    url: `${path_core}Personalizacao.php?action=show`,
    success: function (data) {
        let html = '<option value="">Nenhum selecionado</option>';

        data.forEach((el) => {
            if (el.ativo == 0) {
                return;
            }

            html += `<option value='${el.id}'>${el.tipo}</option>`;
        });

        $('.tipo-personalizacao-solicitacao-contato').html(html);
        todosTiposPersonalizacaoOption = html;
    },
    error: function (xhr) {
        console.log(xhr);
    }
})

function insereNovoProdutoRetornoSolicitacao() {
    $('.select-product-contact').select2({
        language: "pt-BR",
        dropdownParent: $('#modal-atendimento-solicitacao'),
        width: '100%',
        minimumInputLength: 2,
        minimumResultsForSearch: 10,
        multiple: false, 
        ajax: {
            url: `${path_core}Product.php`,
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (params) {
                return {
                    action: 'buscarProduto',
                    search: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.id + ' - ' + item.nome,
                            id: item.id
                        }
                    })
                };
            }
        }
    });

    $('.select-tipo-personalizacao-retorno-solicitacao').html(todosTiposPersonalizacaoOption);

    $(".real").maskMoney({
        prefix: 'R$ ',
        thousands: '.',
        decimal: ','
    });
}


setTimeout(() => {
    $(".real").maskMoney({
        prefix: 'R$ ',
        thousands: '.',
        decimal: ','
    })
}, 500);