const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
});

const path_core = '../app/Core/';

var html_clone_product = null;
var calendarEl = document.getElementById('calendar');

if (calendarEl) {
    var calendar = new FullCalendar.Calendar(calendarEl, {
        customButtons: {
            
            novoOrcamento: {
                text: 'Cadastrar novo orçamento',
                click: function () {


                    modalCreateSanitizeInputs();
                    $('#is-contact-to-budget').val(0);
                    $('#id-ref-contact').val(0);

                    if (html_clone_product == null) {
                        html_clone_product = $("#div-item").html();
                    }
    
                    $('.select-product').select2({
                        dropdownParent: $("#modal-new-budget"),
                        width: '100%'
    
                    });
    
                    $('#prevBtn').removeClass('d-none');
                    $('#modal-new-budget').modal('show');
    
                    fat_alert({
                        type: 'muted',
                        title: 'Atenção 🧐',
                        message: "Todos os campos com '*' são obrigatórios",
                        timer: 4000
                    });
    
                    $('#type-modal, #id-budget-update').val(0);
    
                    setTimeout(() => {
                        $('#select-customers').select2('open');
                    }, 500);
                }
            },
            novoContato: {
                text: 'Cadastrar novo contato',
                click: function () {
                    if (html_clone_product == null) {
                        html_clone_product = $("#div-item").html();
                    }
    
                    $('.select-product').select2({
                        dropdownParent: $("#modal-new-contact"),
                    });
    
                    $('#prevBtnContact').removeClass('d-none');
                    $('#modal-new-contact').modal('show');
    
                    $('.select-product').select2({
                        dropdownParent: $("#modal-new-contact"),
                        width: '100%'
                    });

                    fat_alert({
                        type: 'muted',
                        title: 'Atenção 🧐',
                        message: "Todos os campos com '*' são obrigatórios",
                        timer: 4000
                    });
    
                    $('#id-contact-update').val(0);
                }
            },
            visualizaCores: {
                text: '',
                click: function() {
                    $('#modal-help-calendar').modal('show');
                }
            }
        },
        headerToolbar: {
            left: 'prev,next',
            center: 'title',
            right: 'visualizaCores dayGridMonth,timeGridWeek,timeGridDay'
        },
        buttonText: {
            month: 'Mês',
            week: 'Semana',
            day: 'Dia',
        },
        locale: 'pt-br',
        eventClick: function (info) {
            viewBudget(info.event.id);
        },
        eventContent: function(arg) {
            let label = document.createElement('label')
            const spinner = `
                <div class="spinner-grow text-light w-h-10-px mx-1" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>`;

            if (arg.event.extendedProps.isUrgent) {
              label.innerHTML = spinner + arg.event.title;
            } else {
              label.innerHTML = arg.event.title;
            }
          
            return { domNodes: [ label ] }
          }
    });

    function getItems() {
        $.ajax({
            async: false,
            type: 'POST',
            dataType: 'JSON',
            url: `${path_core}Budgets.php`,
            data: {
                action: 'show'
            },
            success: function (data) {
                data.forEach(evento => {
                    calendar.addEvent(evento);
                });
            },
            error: function (xhr) {
                console.log(xhr);
            }
        });
    }
    
    getItems();
    
    calendar.render();

    $('#calendar .fc-visualizaCores-button').html('<i class="bx bx-help-circle" title="Ajuda"></i>');
}

function showModalChangeStatusDesconto(id, valor_total, desconto_valor, is_manager = false) {
    const valorTotalDescontado = parseFloat(valor_total);
    const valorDesconto = parseFloat(desconto_valor);
    const total = valorTotalDescontado + valorDesconto;

    if (!is_manager) {
        $('#modal-approve-discount-div-observacao').remove();
        $('#modal-approve-discount-footer').remove();
    }

    $('#modal-approve-discount-id-hidden').val(id);
    $('#idApproveDiscount').text(id);
    $('#modalApproveTotalBruto').text(formatFloatToBrCoin(total.toFixed(2)))
    $('#modalApproveValorDesconto').text('- ' + formatFloatToBrCoin(valorDesconto.toFixed(2)));
    $('#modalApproveTotalDescontado').text(formatFloatToBrCoin(valorTotalDescontado.toFixed(2)));

    $('#modal-approve-discount').modal('show');
}

$('#select-customers-contact').select2({
    tags: true,
    dropdownParent: $("#modal-new-contact"),
    language: "pt-BR",
    width: 'resolve',
    minimumInputLength: 2,
    minimumResultsForSearch: 10,
    multiple: false,
    ajax: {
        url: `${path_core}Customer.php`,
        dataType: 'JSON',
        type: 'POST',
        delay: 250,
        data: function(params) {
            return {
                action: 'getNameAndIdFiltered',
                search: params.term
            };
        },
        processResults: function(data) {

            return {
                results: $.map(data, function(el) {

                    if (!el.status) {
                        return;
                    }
        
                    const concatUF = el.estado ? ` - ${el.estado}` : '';
                    let concat4UltimosDigitosContatoNumero = el.celular ? ` - ${el.celular.slice(-4)}` : '';
        
                    if (concat4UltimosDigitosContatoNumero == '') {
                        concat4UltimosDigitosContatoNumero = el.telefone ? ` - ${el.telefone.slice(-4)}` : '';
                    }
        
                    return {
                        text: el.nome + concatUF + concat4UltimosDigitosContatoNumero,
                        id: el.id
                    };
                })
            };
        }
    }
});

// Área de carregamento das informações para geração de orçamento

// Clientes

const pathParts = window.location.pathname.split('/');
const lastPart = pathParts[pathParts.length - 1];

if (lastPart !== 'contacts-list.php') {
    const getCustomers = () => {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                dataType: 'JSON',
                url: `${path_core}Customer.php`,
                data: {
                    action: 'getNameAndId'
                },
                success: function (data) {
                    resolve(data);
                },
                error: function (xhr) {
                    reject(xhr);
                }
            });
        });
    };

    getCustomers().then(response => {
        const customers = response;
        let html = '<option value="">Nenhum selecionado</option>';

        customers.forEach(el => {
            html += `<option value='${el.id}'>${el.nome}</option>`
        });

        $('#select-customers, #select-customers-contact').html(html);

        $('#select-customers').select2({
            dropdownParent: $("#modal-new-budget"),
            width: 'resolve'
        });

        // $('#select-customers-contact').select2({
        //     tags: true,
        //     dropdownParent: $("#modal-new-contact"),
        //     width: 'resolve'
        // });
    })
    .catch(error => {
        console.log(error);
    });
}

getStatus().then(response => {
    let html = '';

    response.forEach(el => {
        selected = el.ativo ? 'selected' : '';
        html += `<option value='${el.id}' ${selected}>${el.nome}</option>`
    });

    $('#select-status').html(html);

    $('#select-status').select2({
        dropdownParent: $("#modal-new-budget"),
        width: '100%'
    });
})

async function getStatus() {
    return await $.ajax({
        type: 'GET',
        dataType: 'JSON',
        url: `${path_core}Status.php?action=show`,
    });
}

// Produtos
const getProducts = () => {
    return new Promise((resolve, reject) => {
        $.ajax({
            async: false,
            type: 'POST',
            dataType: 'JSON',
            url: `${path_core}Product.php`,
            data: {
                action: 'getNameAndId'
            },
            success: function (data) {
                resolve(data);
            },
            error: function (xhr) {
                reject(xhr);
            }
        });
    });
};

getProducts()
    .then(response => {
        const products = response;
        let html = '<option value="">Nenhum selecionado</option>';

        products.forEach(el => {
            html += `<option value='${el.id}'>${el.id} - ${el.nome}</option>`
        });

        $('.select-product').html(html);
    })
    .catch(error => {
        console.log(error);
    });


// Juros
const getFees = () => {
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            url: `${path_core}Fees.php`,
            data: {
                action: 'get'
            },
            success: function (data) {
                resolve(data);
            },
            error: function (xhr) {
                reject(xhr);
            }
        });
    });
};

getFees().then(response => {
        const fees = response;
        let html = '<option value="">Nenhum selecionado</option>';
        fees.forEach(el => {
            let vezes = el.vezes != 0 ? el.vezes + 'x' : 'À Vista';
            // let juros = parseFloat(el.juros) != 0 ? el.juros + ' %' : 'Sem juros';

            html += `<option value='${el.vezes}-${el.juros}'>${vezes}</option>`
        });

        $('#select-fees').html(html);
    })
    .catch(error => {
        console.log(error);
    });

const getPersonalizacao = () => {
    return new Promise((resolve, reject) => {
        $.ajax({
            type: 'GET',
            dataType: 'JSON',
            url: `${path_core}Personalizacao.php?action=show`,
            success: function (data) {
                resolve(data);
            },
            error: function (xhr) {
                reject(xhr);
            }
        });
    });
};

getPersonalizacao().then(response => {
    const personalizacao = response;
    let html = '<option value="">Nenhum selecionado</option>';

    personalizacao.forEach(el => {
        if (el.ativo == 0) {
            return;
        }

        html += `<option value='${el.id}'>${el.tipo}</option>`
    });

    $('.select-personalizacao').html(html);
})
        
var currentTab = 0;

function showTab(n) {
    try {
        let x = document.getElementsByClassName("tab-form");
        x[n].style.display = "block";
    
        document.getElementById("prevBtn").style.display = "inline";
        if (n == 0) {
            document.getElementById("prevBtn").style.display = "none";
        }
    
        document.getElementById("nextBtn").innerHTML = "Próximo";
    
        if (n == (x.length - 3)) {
            document.getElementById("nextBtn").innerHTML = "Pré-visualizar";
        }
    
        if (n == (x.length - 2)) {
            document.getElementById("nextBtn").innerHTML = "Salvar";
        }
    
        if (n == (x.length - 1)) {
            document.getElementById("nextBtn").innerHTML = "Sair";
            $('#prevBtn').addClass('d-none');
            console.log('último');
        }
    
        fixStepIndicator(n)
    } catch (error) {
        
    }
}

/**
 * Anterior/Próxima página do orçamento
 */
function nextPrev(n) {
    let x = document.getElementsByClassName("tab-form");


    if ((currentTab + n) == 3) {
        if (!makeBudget(true)) return;
    }

    if ((currentTab + n) == 4) {
        if (!makeBudget()) return;
    }

    if ((currentTab + n) == 5) {
        setTimeout(() => {
            window.location.href = window.location.origin + window.location.pathname;
        }, 1000);

        return;
    }

    x[currentTab].style.display = "none";
    currentTab = currentTab + n;


    if (currentTab >= x.length) {
        x[--currentTab].style.display = "inline";
        return false;
    }

    showTab(currentTab);
}

function fixStepIndicator(n) {
    let i, x = document.getElementsByClassName("step-form");

    for (i = 0; i < x.length; i++) {
        x[i].className = x[i].className.replace(" active", "");
    }

    x[n].className += " active";
}

/**
 * Irá realizar o orçamento ou pré-visualiza-lo
 */
function makeBudget(preview = false) {

    if (!validateFormBudget()) {
        fat_alert({
            title: 'Atenção',
            message: 'Todos os campos com `*` são obrigatórios.',
            type: 'danger',
            timer: 5000
        });

        return;
    }

    if (!$('#select-status').val()) {
        fat_alert({
            type: 'warning',
            title: 'Oops..',
            message: 'Por favor, informe um status',
            timer: 4000
        });
        return;
    }

    const cliente = $('#select-customers').val();
    const pessoa = $('#pessoa-contato').val();
    const dialogo = $('#dialog-client').val();
    const data_retorno = $('#data-retorno').val();

    const entrada_pgto = $('#entrada-pgto').val() ? parseFloat($('#entrada-pgto').val()) : 0;
    const entrada_tipo = $('#entrada-tipo').val();

    const desconto_pgto = $('#desconto-pgto').val() ? parseFloat($('#desconto-pgto').val()) : 0;
    const desconto_tipo = $('#desconto-tipo').val();

    const valor_adicional = parseFloat($('#valor-adicional').maskMoney('unmasked')[0])
    const juros = $('#select-fees').val();
    const prazo = $('#prazo-entrega').val();
    const tipo_frete = $('#tipo-frete').val();
    const observacao = quill_observacao_produto.root.innerHTML != '<p><br></p>' ? quill_observacao_produto.root.innerHTML : ''; // estudar segurança
    const valor_frete = parseFloat($('#valor-frete').maskMoney('unmasked')[0]);
    const status_user = $('#select-status').val();

    const contactToBudget = $('#is-contact-to-budget').val();

    let products = {};

    $('.group-product-budget').each(function (i, el) {
        products[i] = {
            qtd: $(this).find('.qtd-produto').val(),
            produto: $(this).find('.select-product').val(),
            id_personalizacao: $(this).find('.select-personalizacao').val(),
            precificacao: $(this).find('.select-tax').val(),
            qtd_mao_obra: $(this).find('.qtd-mao-obra').val(),
        }

        if ($(this).find('.checkbox-valor-manual').is(':checked')) {
            products[i].valor_manual = $(this).find('.valor-manual').val() ? parseFloat($(this).find('.valor-manual').maskMoney('unmasked')[0]) : 0;
        }
    });

    let route = '';

    if (preview) {
        route = 'preview';
    } else if ($('#type-modal').val() == '1') {
        route = 'update';
    } else {
        route = 'store';
    }

    const send_data = {
        action: route,
        cliente: cliente,
        pessoa: pessoa,
        dialogo: dialogo,
        data_retorno: data_retorno,
        produtos: products,
        entrada_pgto: entrada_pgto,
        entrada_tipo: entrada_tipo,
        desconto_pgto: desconto_pgto,
        desconto_tipo: desconto_tipo,
        valor_adicional: valor_adicional,
        juros: juros,
        prazo: prazo,
        tipo_frete: tipo_frete,
        valor_frete: valor_frete,
        observacao: observacao,
        status_user: status_user,
        contactToBudget: contactToBudget
    };

    const ref = $('#id-ref-contact').val();
    if (ref && ref != 0) {
        send_data.ref = ref;
    }

    if (route === 'update') {
        send_data.id_orcamento = $('#id-budget-update').val();
    }

    let bool = true

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Budgets.php`,
        data: send_data,
        beforeSend: function () {
            const msgBefore = preview ? 'Estamos efetuando o cálculo' : 'Estamos realizando o orçamento!';

            fat_alert({
                type: 'info',
                title: 'Aguarde',
                message: msgBefore,
                timer: 4000
            });

        },
        success: function (res) {
            
            console.log(res);

            if (res.preview) {
                fat_alert({
                    type: 'primary',
                    title: 'Pré-visualização do orçamento gerada 🤓',
                    message: 'Clique em <u><strong>salvar</strong></u> para gerar o orçamento ou em <u><strong>anterior</strong></u> para fazer alguma alteração',
                    timer: 5000
                });
                makePreviewBudget(res);
                return;
            }

            stageBudget = 1;

            if (res.desconto_pgto > 0) {
                $('#modal-new-budget').modal('hide');
                fat_alert({
                    type: 'primary',
                    title: 'Successo!!!',
                    message: 'Orçamento cadastrado com sucesso, aguarde a aprovação do desconto para visualizar o PDF!',
                    timer: 3000
                });
                return;
            }

            $('#set-pdf').prop('src', 'assets/file/budgets/' + res.pdf);

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Orçamento cadastrado com sucesso!',
                timer: 3000
            });

        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 5000
            });

            bool = false;
        }
    });

    return bool;
}

/** 
 * Responsável por formatar o valor de ponto flutuante para Real Brasileiro
 */
function formatFloatToBrCoin(valor) {
    return parseFloat(valor).toLocaleString('pt-BR', {
        style: 'currency',
        currency: 'BRL'
    });
}

/**
 * Irá montar a tabela para pré-visualizar o orçamento que está sendo realizado
 */
function makePreviewBudget(data) {
    let html_produtos = '';

    console.log(data);
    
    let valorTotalSemJuros = 0;

    for (const [key, el] of Object.entries(data.produtos)) {

        html_produtos += `
            <tr class="border-top-hidden">
                <td>${el.qtd}</td>
                <td><strong>${el.cod_produto}</strong> - ${el.nome}</td>
                <td class="text-end">${formatFloatToBrCoin(el.valor_unitario_final)}</td>
                <td class="text-end">${formatFloatToBrCoin(el.valor_final)}</td>
            </tr>
        `;
        valorTotalSemJuros += el.valor_final;
    }


    html_produtos += `
        <tr style="border-left: hidden; border-right: hidden">
            <td colspan="4"><label class="float-end"><small>Subtotal</small> ${formatFloatToBrCoin(valorTotalSemJuros.toFixed(2))}<label></td>
        </tr>
    `;

    valorTotalSemJuros += data.valor_frete;
    valorTotalSemJuros -= data.valor_desconto;

    html_produtos += `
        <tr>
            <td colspan="4"> Frete<label class="float-end">${formatFloatToBrCoin(data.valor_frete.toFixed(2))}</label></td>
        </tr>
        <tr class="border-top-hidden">
            <td colspan="4"> Desconto<label class="float-end text-danger">- ${formatFloatToBrCoin(data.valor_desconto.toFixed(2))}</label></td>
        </tr>
        <tr style="border-left: hidden; border-right: hidden; border-bottom: hidden;">
            <td colspan="4"> <label class="float-end"><small>Total</small> ${formatFloatToBrCoin(valorTotalSemJuros.toFixed(2))}</label></td>
        </tr>
    `

    $('#render-budget-preview-entrada').html(data.entrada > 0 ? '<strong>-</strong> ' + formatFloatToBrCoin(data.entrada.toFixed(2)) : '')
    $('#render-preview-products-budget').html(html_produtos);
    $('#render-budget-preview-parcelas').text(data.n_parcelas > 0 ? data.n_parcelas + 'x de ' + formatFloatToBrCoin(data.valor_por_parcela.toFixed(2)) : '');

    $('#render-budget-preview-valor-total').text(formatFloatToBrCoin(data.valor_total.toFixed(2)));
}

/**
 * Irá validar do lado do cliente o formulário de realização de orçamento
 */
function validateFormBudget() {
    let bool = true;

    $('.validate-require').each(function (i, el) {
        if ($(el).val() == '') {
            console.log(el);
            bool = false;
        }
    });

    return bool;
}

showTab(currentTab);

setTimeout(() => {
    $(".real").maskMoney({
        prefix: 'R$ ',
        thousands: '.',
        decimal: ','
    })
}, 500);

$('#tipo-frete').on('change', function () {
    $('#div-cif').addClass('d-none');

    if ($(this).val() == 'CIF') {
        $('#div-cif').removeClass('d-none');
        return;
    }

    $('#valor-frete').val('');
});

/**
 * Irá adicionar uma nova linha para adicionar mais um produto ao orçamento
 */
$('#new-product-budget').on('click', function () {
    $('#render-new-product-budget').append(
        '<div data-agroupment-budget><div class="row mt-3">' + html_clone_product + '</div>' +
        '<div class="text-end text-danger mt-n2"><small class="c-p" onclick="removeBudgetProduct()">Remover</small></div></div>'
    );

    $('.select-product').select2({
        dropdownParent: $("#modal-new-budget"),
        width: '100%'
    });

    $(".real").maskMoney({
        prefix: 'R$ ',
        thousands: '.',
        decimal: ','
    })

    validateDuplicateProduct();
    activeCheckboxValorManual();
});



$('#new-contact-product-budget').on('click', function () {
    console.log('s');
    $('#render-contact-product-budget').append(
        '<div data-agroupment-budget><div class="row mt-3">' + html_clone_product + '</div>' +
        '<div class="text-end text-danger mt-n2"><small class="c-p" onclick="removeBudgetProduct()">Remover</small></div></div>'
    );

    $('.select-product').select2({
        dropdownParent: $("#modal-new-contact"),
        width: '100%'
    });

    validateDuplicateProduct();
});

/**
 * Irá verificar produtos duplicados na hora de orçar e remove-los
 */
function validateDuplicateProduct() {
    let valores = [];

    // $('.select-product').each(function () {
    //     if ($(this).val() == '') return false;

    //     if (valores.includes($(this).val())) {

    //         fat_alert({
    //             type: 'info',
    //             title: 'Atenção',
    //             message: 'Produto já selecionado!!!',
    //             timer: 5000
    //         });

    //         $(this).val('').trigger('change');
    //         return;
    //     }

    //     valores.push($(this).val());
    // });
}

/**
 * Remove a linha atual do produto que está sendo orçado
 */
function removeBudgetProduct() {
    $(event.target).closest('div[data-agroupment-budget]').remove();
    validateDuplicateProduct();
}

/**
 * Responsável por alterar a cor de fundo de um evento via id
 */
function changeEventBackgroundColor(eventId, newColor) {
    calendar.getEventById(eventId).setProp('backgroundColor', newColor);
}

/**
 * Irá atualizar o status do orçamento para ganho ou perdido
 */
function toggleBudgetStatus(id, status = 1, callback = false) {

    $.ajax({
        async: false,
        type: 'POST',
        dataType: 'JSON',
        url: `${path_core}Budgets.php`,
        data: {
            action: 'toggle',
            id: id,
            status: status
        },
        beforeSend: function () {
            fat_alert({
                type: 'info',
                title: 'Atualizando 😊',
                message: 'Aguarde enquanto o status do orçamento é atualizado!',
            });
        },
        success: function (data) {
            console.log(data);
            $('#modal-view-budget').modal('hide');

            if (status === 1) {
                fat_alert({
                    type: 'success',
                    title: 'Parabéns 😁',
                    message: 'Este orçamento foi um sucesso!!!',
                    timer: 5000
                });

                changeEventBackgroundColor(id, '#206e09')
                return;
            }

            $('#modal-loser-budget').modal('hide');

            fat_alert({
                type: 'dark',
                title: 'Não foi dessa vez 😕',
                message: 'Status do orçamento atualizado!',
                timer: 5000
            });

            changeEventBackgroundColor(id, '#e04a04')
        },
        error: function (xhr) {
            fat_alert({
                type: 'error',
                title: 'Oops... 😕',
                message: 'Ocorreu um problema ao salvar esta informação. Atualize a página e tente novamente!',
                timer: 6000
            });
        }
    });

    if (callback) {
        callback();
    }
}


/**
 * Abre o modal perder (Para setar o motivo da perda do orçamento)
 */
$('#loserBudget').on('click', function () {
    $('#modal-loser-budget').modal('show');
});

/**
 * Renderiza PDF em modal para visualização (Pós orçamento realizado)
 */
$('#modal-view-pdf-budget-after').on('click', function () {
    $('#modal-set-pdf-view').attr('src', 'assets/file/budgets/' + $(this).attr('data-source-pdf'));
    $('#modal-view-pdf-budget').modal('show');
});

/**
 * Botão vencer (Orçamento ganho com sucesso)
 */
$('#btn-winner').on('click', function () {
    const btn = $(this);
    const id_budget = parseInt($('#modal-view-id-budget').val());

    if (!id_budget) {
        fat_alert({
            type: 'warning',
            title: 'Oops... 😕',
            message: 'Aparentemente ocorreu um erro interno, atualize a página e tente novamente!',
            timer: 10000
        });
        return;
    }

    btn.prop('disabled', true);
    toggleBudgetStatus(id_budget, 1);
});

$('#btn-loser').on('click', function () {
    const btn = $(this);
    const id_budget = parseInt($('#modal-view-id-budget').val());

    if (!id_budget) {
        fat_alert({
            type: 'warning',
            title: 'Oops... 😕',
            message: 'Aparentemente ocorreu um erro interno, atualize a página e tente novamente!',
            timer: 10000
        });
        return;
    }

    btn.prop('disabled', true);
    toggleBudgetStatus(id_budget, -1);
});

$('.desenv-alert').on('click', function () {
    fat_alert({
        type: 'dark',
        title: 'Recurso em manutenção 👨‍🔧🧐',
        message: 'Volte daqui algumas horas!',
        timer: 3000
    });
});

var stageBudget = 0;

$('#modal-new-budget').on('hidden.bs.modal', function () {
    if (stageBudget == 1) {
        window.location.href = window.location.origin + window.location.pathname;
    }
});

// -----------------------------------------------------------------------

function saveContact() {
    const cliente = $('#select-customers-contact').val();
    const contato = $('#pessoa-contato-cliente').val();
    const tel = $('#telefone-celular-contato').val();
    const dialogo = $('#dialog-client-contato').val();
    const estado = $('#select-uf-contato').val();
    const cidade = $('#select-cidade-contato').val();
    const dataLembrarMe = $('#data-retorno-contato').val();
    const origem = $('#select-origem-modal-create-customer').val();

    const destinoUso = $('#destino-uso-contato').val();
    const dataSolicitadaParaEntregar = $('#data-solicitada-para-entrega-contato').val();

    // 0 para mensagem; 1 para ligação
    const tipoContatoRealizado = parseInt($('input[name="tipo-dialogo-contato-cliente"]:checked').val());

    if (!cliente) {
        fat_alert({
            type: 'erro',
            title: 'Oops',
            message: 'Preencha todos os campos obrigatórios!',
            timer: 3000
        });

        return;
    }

    if (!$.isNumeric(cliente) && (!contato || !tel || !dialogo || !origem || !estado || !cidade)) {
        fat_alert({
            type: 'erro',
            title: 'Oops',
            message: 'Preencha todos os campos obrigatórios!',
            timer: 3000
        });
        
        return;
    }

    let data = new FormData();

    let itensSolicitados = [];
    let anexos = {};

    if (isSolicitacaoContato) {
        try {
            const result = obtemItensSolicitadosContato();
            itensSolicitados = result.itensSolicitados;
            anexos = result.anexos;

            // Aqui fazemos o append dos anexos dos itens com base no índice
            for (let index in anexos) {
                data.append('anexo_item_' + index, anexos[index]);
            }
        } catch (error) {
            fat_alert({
                type: 'danger',
                title: 'Oops',
                message: error.message,
                timer: 4000
            });

            return;
        }

        let files = $('#anexos-solicitacao-orcamento-contato').prop('files');
    
        // Adiciona cada arquivo ao FormData
        for (let i = 0; i < files.length; i++) {
            data.append('file' + i, files[i]);
        }
    }

    const params = {
        cliente: cliente,
        origem: origem,
        contato: contato,
        tel: tel,
        dialogo: dialogo,
        estado: estado,
        cidade: cidade,
        dataRetorno: dataLembrarMe,
        tipoContatoRealizado: tipoContatoRealizado,
        destinoUso: destinoUso,
        dataSolicitadaParaEntregar: dataSolicitadaParaEntregar,
        itensSolicitados: itensSolicitados,
        isSolicitacao: isSolicitacaoContato ? 1 : 0
    };

    data.append('params', JSON.stringify(params))
    data.append('action', 'store');

    $.ajax({
        type: 'POST',
        url: `${path_core}Contact.php`,
        contentType: false,
        processData: false,
        data: data,
        beforeSend: function () {
            $('#btn-save-contact').attr('disabled', true);
        },
        success: function (data) {

            $('#modal-new-contact').attr('disabled', false);

            fat_alert({
                type: 'success',
                title: 'Successo!!!',
                message: 'Contato lançado com sucesso!',
                timer: 3000
            });

            setTimeout(() => {
                window.location.reload(false);
            }, 1000);
        },
        complete: function() {
            $('#modal-new-contact').modal('hide');
            $('#btn-save-contact').attr('disabled', false);
        },
        error: function (xhr) {
            console.log(xhr);
            fat_alert({
                title: 'Erro',
                message: 'Ocorreu um erro durante a operação. Por favor, tente novamente mais tarde.',
                type: 'danger',
                timer: 3000
            });
        }
    });
}

$('#btn-save-contact').on('click', saveContact);

function obtemItensSolicitadosContato() {
    let itensSolicitados = [];
    let anexos = {};

    // Limite de peso do anexo em MB
    const limitePesoAnexo = 2; // 2 MB

    $('div[data-agroupment-solicitacao]').each(function (i, el) {
        console.log(i);
        
        const qtd = $(this).find('.qtd-solicitacao-contato').val() ? parseInt($(this).find('.qtd-solicitacao-contato').val()) : 0;
        const descricaoItem = $(this).find('.descricao-item-solicitacao-contato').val();
        const tipoPersonalizacao = $(this).find('.tipo-personalizacao-solicitacao-contato').val() ? parseInt($(this).find('.tipo-personalizacao-solicitacao-contato').val()) : 0;
        const valorObjetivo = $(this).find('.valor-objetivo-solicitacao-contato').maskMoney('unmasked')[0];
        const anexo = $(this).find('.anexo-solicitacao-contato')[0].files[0];

        if (qtd === 0) {
            throw new Error("Quantidade é um campo obrigatório!");
        }

        if (!descricaoItem) {
            throw new Error("Descrição do item é um campo obrigatório!");
        }

        if (tipoPersonalizacao === 0) {
            throw new Error("Tipo de personalização é um campo obrigatório!");
        }

        // if (!valorObjetivo) {
        //     throw new Error("Valor objetivo é um campo obrigatório!");
        // }

        if (anexo && anexo.size > limitePesoAnexo * 1024 * 1024) { // 2MB em bytes
            throw new Error(`O anexo do item <b>${descricaoItem}</b> ultrapassa o limite de ${limitePesoAnexo}MB!`);
        }

        itensSolicitados.push({
            index: i,
            qtd: qtd,
            descricaoItem: descricaoItem,
            tipoPersonalizacao: tipoPersonalizacao,
            valorObjetivo: valorObjetivo,
        });

        if (anexo) {
            anexos[i] = anexo;
        }
    });

    return { itensSolicitados, anexos };
}

$('.phone-contact').mask('(00) 0000-00009', {
    onKeyPress: function (val, e, field, options) {
        var mask = val.replace(/\D/g, '').length > 10 ? '(00) 0 0000-0000' : '(00) 0000-00009';
        field.mask(mask, options);
    }
});
try {
    var quill_observacao_produto = new Quill('#observacao-produto', {
        modules: {
          toolbar: [
            [{ header: [2, false] }],
            ['bold', 'italic', 'underline', 'strike'],
            ['link'],
            [{ list: 'ordered' }, { list: 'bullet' }],
            [{ script: 'sub' }, { script: 'super' }],
            [{ color: [] }, { background: [] }],
            ['clean']
          ]
        },
        placeholder: 'Descreva aqui as observações do pedido...',
        theme: 'snow' 
    });
} catch (error) {
    console.info('Quill não iniciado', error);
}

$('#btn-approve-discount').on('click', function() {
    const id = $('#modal-approve-discount-id-hidden').val();

    $.ajax({
        method: 'POST',
        url: `${path_core}Orcamentos.php`,
        data: {
            idOrcamento: id,
            action: 'aprovarDesconto'
        },
        success: function() {
            fat_alert({
                type: 'primary',
                title: 'Sucesso',
                message: 'Desconto aprovado! 💰📝💸',
                timer: 3000
            });

            $('#modal-approve-discount').modal('hide');
        },
        complete: function() {

        },
        error: function(xhr) {
            console.log(xhr);
        }
    })

});

function modalCreateSanitizeInputs() {
    $('#modal-title-budget').text('Novo orçamento');
    $('#type-modal').val(0);
    $('#select-customers').val('').trigger('change');
    $('#pessoa-contato').val('');
    $('#dialog-client').val('');
    $('#data-retorno').val('');
    $('#entrada-pgto').val('');
    $('#entrada-tipo').val('%');
    $('#desconto-pgto').val('');
    $('#desconto-tipo').val('%');
    $('#valor-adicional').val('');
    $('#select-fees').val('');
    $('#prazo-entrega').val('');
    $('#tipo-frete').val('');
    $('#valor-frete').val('');

    $('#render-new-product-budget').empty();

    $('.qtd-produto').val('');
    $('.qtd-mao-obra').val('1');
    $('.select-tax').val('condicao_ideal');
    $('.select-product').val('').trigger('change');
    
    getStatus().then(response => {
        let html = '';

        response.forEach(el => {
            selected = el.ativo ? 'selected' : '';
            html += `<option value='${el.id}' ${selected}>${el.nome}</option>`
        });

        $('#select-status').html(html);

        $('#select-status').select2({
            dropdownParent: $("#modal-new-budget"),
            width: '100%'
        });
    })

    try {
        quill_observacao_produto.clipboard.dangerouslyPasteHTML('');
    } catch (er) {
        console.log('quill não iniciado', er);
    }
}

// Necessário garantiar a clonagem do html do produto
setTimeout(() => {
    if (html_clone_product == null) {
        html_clone_product = $("#div-item").html();
    }
}, 1000);