/**
 * Seletor do botão enviar orçamento
 * 
 * @var btnSendDialog
 */
const btnSendDialog = $('#btn-send-dialog');

/**
 * Evento responsável por cadastrar um novo diálogo na base de dados
 */
btnSendDialog.on('click', function() {

    const id = $('#modal-view-id-budget').val();
    const message = $('#text-send-dialog').val();

    // Se não estiver nenhuma mensagem para enviar
    if (message == '') {
        // editar com o nossoa alerta padrão
        alert('Preencher a mensagem');
        return;
    }

    $.ajax({
        method: 'POST',
        url: `${path_core}BudgetDialogs.php`,
        data: {
            action: 'store',
            message: message,
            idOrcamento: id
        },
        beforeSend: function() {
            btnSendDialog.attr('disabled', true);
        },
        success: function() {
            const cards = addCardsDialog(getDialogs(id));
            $('#cards-dialog-view-budget').html(cards);

            // Rolar o scroll até o final da div
            const chatDiv = $('#cards-dialog-view-budget');
            chatDiv.scrollTop(chatDiv[0].scrollHeight);
            $('#text-send-dialog').val('');
        },
        error: function(xhr) {
            console.log(xhr);
        },
        complete: function() {
            btnSendDialog.attr('disabled', false);
        }
    });
});

function getDialogs(idOrcamento) {
    let data = [];

    $.ajax({
        async: false,
        method: 'GET',
        url: `${path_core}BudgetDialogs.php?action=getDialogosById&idOrcamento=${idOrcamento}`,
        dataType: 'JSON',
        success: function(res) {
            data = res;
        },
        error: function(xhr) {
            console.log(xhr);
        },
    });

    return data;
}

function addCardsDialog(data) {
    let cards = '';


    data.forEach(info => {

        cards += `
        <div class="row" style="margin: 0px 10px 10px 0px !important">
            <div class="card ${ info.is_my_user ? 'bg-dark' : 'bg-primary' } text-white">
                <div class="card-body" style="padding: 0.5rem 1.5rem;">
                    <div class="d-flex ms-n5 ps-3">
                        <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                            <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-xs pull-up">
                                <img src="assets/file/user/${info.img}" onerror='this.src="assets/file/system/undraw_profile.svg"' alt="Avatar" class="rounded-circle"/>
                            </li>
                        </ul>
                        <label class="form-label text-white pt-2 ps-2" >${ info.is_my_user ? 'Eu' : info.nome }</label>
                    </div>
                    <p class="card-text">${info.message}</p>
                    <p class="card-text text-end mt-n2">
                        <small class="text-white" style="font-size: 11px;">${info.data_envio}</small>
                    </p>
                </div>
            </div>
        </div>`
    });

    return cards;
}