(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("cleave.js"), require("vue"));
	else if(typeof define === 'function' && define.amd)
		define("VueCleave", ["cleave.js", "vue"], factory);
	else if(typeof exports === 'object')
		exports["VueCleave"] = factory(require("cleave.js"), require("vue"));
	else
		root["VueCleave"] = factory(root["Cleave"], root["Vue"]);
})(this, (__WEBPACK_EXTERNAL_MODULE__144__, __WEBPACK_EXTERNAL_MODULE__976__) => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 144:
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__144__;

/***/ }),

/***/ 976:
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE__976__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ src)
});

// EXTERNAL MODULE: external {"commonjs":"cleave.js","commonjs2":"cleave.js","amd":"cleave.js","root":"Cleave"}
var external_commonjs_cleave_js_commonjs2_cleave_js_amd_cleave_js_root_Cleave_ = __webpack_require__(144);
var external_commonjs_cleave_js_commonjs2_cleave_js_amd_cleave_js_root_Cleave_default = /*#__PURE__*/__webpack_require__.n(external_commonjs_cleave_js_commonjs2_cleave_js_amd_cleave_js_root_Cleave_);
// EXTERNAL MODULE: external {"commonjs":"vue","commonjs2":"vue","amd":"vue","root":"Vue"}
var external_commonjs_vue_commonjs2_vue_amd_vue_root_Vue_ = __webpack_require__(976);
;// CONCATENATED MODULE: ./src/component.js


/* harmony default export */ const component = ((0,external_commonjs_vue_commonjs2_vue_amd_vue_root_Vue_.defineComponent)({
  name: 'cleave',
  compatConfig: {
    MODE: 3
  },
  render() {
    return (0,external_commonjs_vue_commonjs2_vue_amd_vue_root_Vue_.h)('input', {
      type: 'text',
      value: this.cleave ? this.cleave.properties.result : this.modelValue,
      // Cleave.js will set this as initial value
      onBlur: this.onBlur
    });
  },
  props: {
    modelValue: {
      default: null,
      required: true,
      validator(value) {
        return value === null || typeof value === 'string' || value instanceof String || typeof value === 'number';
      }
    },
    // https://github.com/nosir/cleave.js/blob/master/doc/options.md
    options: {
      type: Object,
      default: () => ({})
    },
    // Set this prop as `false` to emit masked value
    raw: {
      type: Boolean,
      default: true
    }
  },
  emits: ['blur', 'update:modelValue'],
  data() {
    return {
      // cleave.js instance
      cleave: null,
      // callback backup
      onValueChangedFn: null
    };
  },
  mounted() {
    /* istanbul ignore if */
    if (this.cleave) return;
    this.cleave = new (external_commonjs_cleave_js_commonjs2_cleave_js_amd_cleave_js_root_Cleave_default())(this.$el, this.getOptions(this.options));
  },
  methods: {
    /**
     * Inject our method in config options
     */
    getOptions(options) {
      // Preserve original callback
      this.onValueChangedFn = options.onValueChanged;
      return Object.assign({}, options, {
        onValueChanged: this.onValueChanged
      });
    },
    /**
     * Watch for value changed by cleave and notify parent component
     */
    onValueChanged(event) {
      let value = this.raw ? event.target.rawValue : event.target.value;
      this.$emit('update:modelValue', value);

      // Call original callback method
      if (typeof this.onValueChangedFn === 'function') {
        this.onValueChangedFn.call(this, event);
      }
    },
    onBlur() {
      this.$emit('blur', this.modelValue);
    }
  },
  watch: {
    /**
     * Watch for any changes in options and redraw
     */
    options: {
      deep: true,
      handler(newOptions) {
        this.cleave.destroy();
        this.cleave = new (external_commonjs_cleave_js_commonjs2_cleave_js_amd_cleave_js_root_Cleave_default())(this.$el, this.getOptions(newOptions));
        this.cleave.setRawValue(this.modelValue);
      }
    },
    /**
     * Watch for changes from parent component and notify cleave instance
     */
    modelValue(newValue) {
      /* istanbul ignore if */
      if (!this.cleave) return;

      // when v-model is not masked (raw)
      if (this.raw && newValue === this.cleave.getRawValue()) return;
      //  when v-model is masked (NOT raw)
      if (!this.raw && newValue === this.$el.value) return;
      // Lastly set newValue
      this.cleave.setRawValue(newValue);
    }
  },
  beforeUnmount() {
    /* istanbul ignore if */
    if (!this.cleave) return;
    this.cleave.destroy();
    this.cleave = null;
    this.onValueChangedFn = null;
  }
}));
;// CONCATENATED MODULE: ./src/index.js

const src_plugin = (app, params) => {
  let name = 'cleave';
  /* istanbul ignore else */
  if (typeof params === 'string') name = params;
  app.component(name, component);
};
component.install = src_plugin;
/* harmony default export */ const src = (component);
})();

__webpack_exports__ = __webpack_exports__["default"];
/******/ 	return __webpack_exports__;
/******/ })()
;
});