<?php

namespace App\Core\Utilities;

use App\Core\Helpers\Helper;

trait Update {
    protected $updateQuery = "";

    protected function bindParams($stmt, $params) {
        $types = "";
        foreach ($params as $param) {
            if (is_int($param)) {
                $types .= "i";
            } elseif (is_float($param)) {
                $types .= "d";
            } elseif (is_string($param)) {
                $types .= "s";
            } else {
                $types .= "b";
            }
        }

        $paramsRef = array();
        foreach($params as $key => $value) {
            $paramsRef[$key] = &$params[$key];
        }

        array_unshift($paramsRef, $types);

        call_user_func_array(array($stmt, 'bind_param'), $paramsRef);
    }

    protected function buildUpdateQuery($table, $data, $where) {
        $params = [];
        $set = "";
        $whereClause = "";

        foreach ($data as $key => $value) {
            $set .= "`$key` = ?, ";
            $params[] = $value;
        }

        foreach ($where as $key => $value) {
            $whereClause .= "`$key` = ? AND ";
            $params[] = $value;
        }

        $set = rtrim($set, ", ");
        $whereClause = rtrim($whereClause, "AND ");

        $this->updateQuery = "UPDATE $table SET $set WHERE $whereClause";

        return $params;
    }

    public function updateQuery($table, $data, $where) {
        $params = $this->buildUpdateQuery($table, $data, $where);

        $stmt = $this->conn->prepare($this->updateQuery);
        $this->bindParams($stmt, $params);
        $stmt->execute();

        return $stmt->affected_rows;
    }
}