<?php
namespace App\Core\Utilities;

use App\Core\Conn;

trait Insert
{
    /**
     * Trait responsável por dar um insert na base de dados
     * 
     * @param array $attributes - recebe o nome da coluna + valor
     * @param ?string $url - url para redirecionamento pós execução
     * @param ?string $message_get - devolve uma informação via parâmetro get
     * @param ?bool $get_id - se true, devolve o id do insert
     * 
     * @return mixed
     * 
     * @todo Implementar Try Catch
     */
    public function Insert(
        array $attributes, 
        string $table
    ): mixed {
        $columns         = implode(',', array_keys($attributes));
        $interrogations  = substr(str_replace('?', '?,', str_repeat('?', count( array_keys($attributes) ))), 0, -1);
        $bind_types      = implode('', array_map(function($v) {

            if (is_string($v) || is_null($v)) {
                return 's';
            } else if (is_int($v)) {
                return 'i';
            } else if (is_double($v)) {
                return 'd';
            }

            return false;
        }, array_values($attributes)));

        $query  = "INSERT INTO {$table} ({$columns}) VALUES ({$interrogations})";
        $create = $this->conn->prepare($query);
        $create->bind_param($bind_types, ...array_values($attributes));

        if ($create->execute()) {
            return (int)$this->conn->insert_id;
        }

        return false;
    }
}
