<?php

namespace App\Core;
require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Middlewares\AuthenticationMiddleware;
use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Conn, RenderTable, FileManager, Paginate};
use App\Core\Helpers\Helper;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


class Support
{
    use Create, PreparedQuery, Update;

    private $conn = null;
    private string $table = '';
    private ?int $id_usuario = null;

    public function __construct()
    {
        $this->conn  = Conn::openConn();
        $this->table = RenderTable::table('suporte');
        $this->id_usuario = $_SESSION['user']['id'];
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }

    /**
     * Método responsável por criar um novo usuário
     *
     * @param array $info (recebe uma request com os dados do formulário)
     * @param ?array $photo (recebe a imagem do usuário)
     *
     * @return void
     *
     * @todo Implementar Try Catch
     */
    public function store(array $info, null|array $photo): void
    {
        if (isset($photo)) {
            $name_file = FileManager::uploadFile('support/', $photo);
        }

        $user = $this->getNameAndEmailUser();
        $sendedEmail = $this->sendMailToSupport($user, $info, $name_file);

        if(!$sendedEmail) {
            Helper::jsonResponse([
                'error' => 1,
                'message' => 'Erro ao enviar o e-mail ao suporte.'
            ], 400);

            return;
        }

        self::Create([
            'id_usuario_FK' => $this->id_usuario,
            'assunto'       => htmlspecialchars(addslashes(str_replace(["\n", "<br>", "\r", "\t"], "", $info['emailSubject']))),
            'descricao'     => htmlspecialchars(addslashes(str_replace(["\n", "<br>", "\r", "\t"], "", $info['emailSubjectTextArea']))),
            'img'           => $name_file ?? null
        ]);

        Helper::jsonResponse(1);
    }

    public function show(int $current_page, int $limit_per_page): array
    {
        $paginate = new Paginate($this->getCountSupport(), $current_page, $limit_per_page);

        $sql = " SELECT id, id_usuario_FK, assunto, descricao, img, created_at";
        $sql .= " FROM " . RenderTable::table('suporte') . " WHERE id_usuario_FK=" . $this->id_usuario ;
        $sql .= " ORDER BY created_at DESC";
        $sql .= " LIMIT " . $paginate->getLimitOffset();

        return [
            'data' => self::PreparedQuery($sql),
            'pages' => $paginate->generatePaginationData($current_page)
        ];
    }

    /**
     * Método responsável por obter a contagem total de clientes cadastrados no sistema.
     * @return int A quantidade total de clientes cadastrados.
     */
    public function getCountSupport(): int
    {
        $data = self::preparedQuery("SELECT COUNT(*) AS qtd FROM {$this->table} WHERE id_usuario_FK= {$this->id_usuario}");
        return !empty($data[0]['qtd']) ? (int)$data[0]['qtd'] : 0;
    }

    private function getNameAndEmailUser() {
        $sql = "SELECT nome, email FROM " . RenderTable::table('usuarios') . " WHERE id= ?";
        return $verify_user = self::PreparedQuery($sql,[$this->id_usuario]);
    }

    private function sendMailToSupport(array $user, array $info, null|string $photo) {
        $message = $this->renderMessageMail($user[0]['nome'], $user[0]['email'], $info['emailSubject'] , $info['emailSubjectTextArea'], $photo);
        $mail = new PHPMailer();
        $mail->isSMTP();
        $mail->Host = 'mail.fattos.com.br';
        $mail->From = 'suporte@fattos.com.br';
        $mail->FromName = 'suporte@fattos.com.br';
        $mail->SMTPAuth = true;
        $mail->SMTPSecure = 'tls';
        $mail->Username = 'suporte@fattos.com.br';
        $mail->Password = 'd3[cNaVAeH]A';
        $mail->Port = 587;
        $mail->Encoding = 'base64';
        $mail->CharSet = 'UTF-8';

        $mail->setFrom('suporte@fattos.com.br');
        $mail->addAddress("suporte@fattos.com.br");
        $mail->addReplyTo('suporte@fattos.com.br');
        $mail->isHTML(true);
        //VERIFICAR EM PROD(INICIO)
        if ($_SERVER['REMOTE_ADDR'] == '127.0.0.1') {
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true,
                )
            );
        }
        //VERIFICAR EM PROD(FIM)
        $mail->Subject = 'Chamado ao suporte';
        $mail->Body = $message;
        $mail->SMTPOptions = array(
            'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            )
        );

        if (!$mail->send()) {
            Helper::jsonResponse([
                'error' => 1,
                'message' => 'Erro ao enviar o e-mail ao suporte.'
            ]);
            return false;
        }

        return true;
    }

    public function renderMessageMail(string $name, string $email, string $subject, string $description, null|string $photo): string
    {
        $message = "
        <html>
            <head>
                <style>
                    .title {
                        font-size: 20px;
                        font-weight: bold;
                        margin-bottom: 10px;
                    }
        
                    .content {
                        margin-bottom: 20px;
                    }
                </style>
            </head>
            <body>
                <div style='font-size: 20px; font-weight: bold; margin-bottom: 10px;'>Boa tarde, equipe de suporte!</div>
                <div style='margin-bottom: 20px;'>Um chamado foi aberto pelo usuário {$name} ({$email}).</div>
                <div style='margin-bottom: 20px;'><b>Assunto:</b> {$subject}</div>
                <div style='margin-bottom: 20px;'><b>Descrição:</b> {$description}</div>
            ";

            if ($photo) {
                $imagePath = __DIR__ . '/../../view/assets/file/support/' . $photo;

                $imageData = file_get_contents($imagePath);

                if ($imageData !== false) {
                    $imageBase64 = base64_encode($imageData);
                    $imageSrc = 'data:image/jpeg;base64,' . $imageBase64;

                    $message .= "<div style='margin-bottom: 20px;'><b>Imagem:</b></div>";
                    $message .= "<div style='margin-bottom: 20px;'><img src='{$imageSrc}' alt='Imagem' width='400' height='400'></div>";
                }
            }

            $message .= "<div style='margin-bottom: 20px;'>Por favor, revisem o chamado e forneçam a assistência necessária o mais rápido possível.</div>";
            $message .= "<div style='margin-bottom: 20px;'>Agradecemos antecipadamente por sua atenção e suporte contínuo.</div>";
            $message .= "<div style='margin-bottom: 20px;'>Atenciosamente,</div>";
            $message .= "<div style='margin-bottom: 20px;'>Equipe de Suporte</div>";
            $message .= "</body>
        </html>";

        return $message;
    }


    /**
     * Método responsável por retornar a função solicitada pelo front-end
     *
     * @param string $route
     *
     * @return void
     */
    private function route(string $route): void
    {
        $auth_middleware = new AuthenticationMiddleware;

        match ($route) {
            'sendMailSupport' => $auth_middleware->handle(
                fn() => $this->store($_REQUEST, $_FILES['archive'] ?? null),
            ),
        };
    }


    public function setRoute(string $route): void
    {
        $this->route($route);
    }

}

if (isset($_POST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Support')
{
    $instance = new Support();
    $instance->setRoute($_REQUEST['action']);
}