<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Controller, RenderTable};
use App\Core\Helpers\Helper;
use Exception;

class Status extends Controller
{
    use Create, PreparedQuery, Update;

    private string $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = RenderTable::table('status');
    }

    /**
     * Método responsável por criar um novo registro na tabela Status no banco de dados
     * 
     * @param string $nome nome do status
     * @param string $descricao descrição do status
     * @param string $color cor do background do status
     */
    public function store(string $nome, ?string $descricao = null, string $cor_fundo, string $cor_fonte, int $ativo)
    {
        try {
            if ($ativo) {
                self::updateQuery($this->table, ['ativo' => 0], ['ativo' => 1]);
            }

            self::Create([
                'nome' => $nome,
                'descricao' => $descricao,
                'cor_fundo' => $cor_fundo,
                'cor_fonte' => $cor_fonte,
                'ativo' => (int)$ativo
            ]);

            Helper::jsonResponse(1);
        } catch (\Throwable $e) {
            Helper::jsonResponse('Erro ao cadastrar: ' . $e->getMessage(), 400);
        }
    }

    /**
     * @todo desenv...
     */
    public function show()
    {
        Helper::jsonResponse(
            self::PreparedQuery("SELECT * FROM " . $this->table)
        );
    }

    public function showList() {
        return self::PreparedQuery("SELECT * FROM " . $this->table);
    }



    /**
     * Método responsável por retornar a função solicitada pelo front-end
     *
     * @param string $route
     *
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'store' => $this->store(
                $_POST['nome'],
                $_POST['descricao'],
                $_POST['fundo'],
                $_POST['fonte'],
                $_POST['ativo']
            ),
            'show' => $this->show()
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Status') {
    $instance = new Status();
    $instance->setRoute($_REQUEST['action']);
}