<?php
namespace App\Core; 

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Middlewares\AuthenticationMiddleware;
use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Conn, RenderTable, FileManager};
use App\Core\Helpers\Helper;
use App\Core\Interfaces\StandardClassInterface;

class Punctuation implements StandardClassInterface
{
    use Create, PreparedQuery, Update;

    private $conn = null;

    private string $table = '';

    private ?int $id_empresa = null;

    private ?int $id_usuario = null;


    public function __construct()
    {
        $this->conn  = Conn::openConn();
        $this->table = RenderTable::table('config_pontuacao');
        $this->id_empresa = $_SESSION['user']['id_empresa'];
        $this->id_usuario = $_SESSION['user']['id'];
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }

    public function store(array $info): void
    {

    }

    /**
     * Método responsável por listar usuários do sistema
     * @return array users 
     */
    public function show(): array
    {
        return self::PreparedQuery("SELECT id, nome, email, nivel, img FROM {$this->table} WHERE id_empresa_FK = ? ORDER BY nome ASC", [$this->id_empresa]);
    }

    public function update(array $info)
    {
        $data_update = [
            'valor' => $info['valor'],
            'pontos' => $info['ponto']
        ];

        $rowsAffected = self::updateQuery($this->table, $data_update, [
            'id' => (int) $info['id'],
            'id_empresa_FK' => $this->id_empresa 
        ]);

        Helper::jsonResponse(['success' => $rowsAffected]);
    }

    public function getPunctuationActual()
    {
        return self::PreparedQuery("SELECT id, valor, pontos FROM {$this->table} WHERE id_empresa_FK = ? ORDER BY id DESC", [$this->id_empresa]);
    }

    public function getMySumPoints()
    {
        $sql  = ' SELECT SUM(v.pontuacao) AS pontuacao';
        $sql .= " FROM " . RenderTable::table('vendas') . " AS v";
        $sql .= ' WHERE v.id_empresa_FK = ? AND v.id_usuario_FK = ?';

        return self::PreparedQuery($sql, [$this->id_empresa, $this->id_usuario]);
    }

    public function getMyPoints()
    {
        $sql  = ' SELECT hp.pontos, hp.create_at';
        $sql .= " FROM " . RenderTable::table('historico_pontuacao') . " AS hp"; 
        $sql .= ' WHERE hp.id_empresa_FK = ? AND hp.id_usuario_FK = ?';

        return self::PreparedQuery($sql, [$this->id_empresa, $this->id_usuario]);
    }
    /**
     * Método responsável por retornar a função solicitada pelo front-end
     * @param string $route
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'store' => $this->store($_REQUEST),
            'update' => $this->update($_REQUEST)
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_POST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Punctuation') 
{
    $instance = new Punctuation();
    $instance->setRoute($_REQUEST['action']);
}
