<?php

namespace App\Core\Precificacao\Interfaces;

/**
 * @package App\Core\Precificacao
 */
interface CalculoValorAdicionalInterface
{
    /**
     * Interface responsável por aplicar o valor adicional em cada produto de forma proporcional
     * 
     * @param array $produtos - Produtos a serem calculados
     * @param float $valorAdicional - Valor adicional a ser aplicado
     * @param float $valorTotal - Valor total dos produtos
     * 
     * @return array Produtos com valor adicional aplicado
     */
    public function calcular(array $produto, float $valorAdicional, float $valorTotal): array;
}