<?php 

namespace App\Core\Precificacao\Formulas;

use App\Core\Helpers\Helper;
use App\Core\Precificacao\Interfaces\CalculoJurosParcelamentoInterface;

/**
 * @package App\Core\Precificacao
 */
class CalculoJurosParcelamentoOrcamento implements CalculoJurosParcelamentoInterface
{
    /**
     * Método responsável por calcular o valor total acrescido de juros
     * 
     * @param int $parcelas - Quantidade de parcelas
     * @param float $juros - Juros a ser aplicado (em porcentagem)
     * @param float $valorTotal - Valor Total antes de aplicar o juros
     * 
     * @return array - Array com informações das parcelas, juros e valor total
     */
    public function calcular(int $parcelas, float $juros, float $valorTotal): array
    {
        $valorTotalComJuros = Helper::ensureEvenDecimal(
            $valorTotal + ($valorTotal * ($juros / 100))
        );
        $valorPorParcela = Helper::ensureEvenDecimal(($valorTotalComJuros / $parcelas));

        // Para fazer com que o valor total seja exato, multiplicamos o valor da parcela pelo número de parcelas
        $valorTotalComJuros = $valorPorParcela * $parcelas;

        return [
            'valorTotal' => $valorTotalComJuros,
            'valorPorParcela' => Helper::ensureEvenDecimal($valorPorParcela),
            'NParcelas' => $parcelas
        ];
    }
}