<?php 

namespace App\Core\Precificacao\Formulas;

use App\Core\Precificacao\Interfaces\CalculoDescontoInterface;

class CalculoDescontoOrcamento implements CalculoDescontoInterface
{
    /**
     * Método responsável por calcular o valor total com desconto
     * 
     * @param string $tipoDeDesconto - Tipo de desconto a ser aplicado (R$ ou %)
     * @param float $valorDesconto - Valor do desconto
     * @param float $valorTotal - Valor Total antes de aplicar o desconto
     * 
     * @return array - Informações do valor total com desconto e o valor a ser descontado
     */
    public function calcular(string $tipoDeDesconto, float $valorDesconto, float $valorTotal): array
    {
        $valorDescontado = 0;
        if ($tipoDeDesconto == 'R$') {
            $valorDescontado = $valorDesconto;
        }
        
        if ($tipoDeDesconto == '%') {
            $valorDescontado = ($valorDesconto / 100) * $valorTotal;
        }

        return [
            'valorDescontado' => $valorDescontado,
            'valorTotalComDesconto' => $valorTotal -= $valorDescontado
        ];

        throw new \Exception('Tipo de desconto inválido');
    }
}