<?php 
namespace App\Core\Precificacao;

require_once __DIR__ . '/../../../bootstrap.php';

/**
 * Classe abstrata responsável por calcular o orçamento de um determinado produto com base na regra de negócio
 * 
 * @package App\Core\Precificacao
 */
abstract class CalculoOrcamentoAbstract
{
    /**
     * @var array $dadosOrcamento
     */
    protected array $dadosOrcamento;

    /**
     * @var array $custos
     */
    protected array $custos;

    public function __construct(array $dadosOrcamento)
    {
        $this->dadosOrcamento = $dadosOrcamento;
        $this->custos = $dadosOrcamento['custos'];
    }
}