<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Controller};
use App\Core\Helpers\Helper;

class Personalizacao extends Controller
{
    use Create, PreparedQuery, Update;

    private string $table = 'personalizacoes';

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Método responsável por criar um novo registro na tabela Personalizacoes no banco de dados
     * 
     */
    public function cadastrarCodigo(string $nome)
    {
        try {
            self::Create([
                'tipo' => strtoupper($nome),
                'created_by' => $_SESSION['user']['id']
            ]);

            return true;
        } catch (\Throwable $e) {
            Helper::jsonResponse('Erro ao cadastrar: ' . $e->getMessage(), 400);
        }
    }


    public function listarTodos()
    {
        return self::PreparedQuery("SELECT p.* FROM personalizacoes AS p");
    }

    public function atualizaNomeCodigo(int $id, string $nome)
    {
        try {
            self::updateQuery(
                'personalizacoes', 
                [
                    'tipo' => $nome,
                    'updated_by' => $_SESSION['user']['id']
                ], 
                ['id'   => $id]
            );

            return true;
        } catch (\Throwable $th) {
            throw $th;
        }
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     *
     * @param string $route
     *
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'store' => Helper::jsonResponse($this->cadastrarCodigo($_POST['nome'])),
            'show'  => Helper::jsonResponse($this->listarTodos()),
            'atualizaNomeCodigo' => Helper::jsonResponse($this->atualizaNomeCodigo($_POST['id'], $_POST['nome'])),
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Personalizacao') {
    $instance = new Personalizacao();
    $instance->setRoute($_REQUEST['action']);
}