<?php
namespace App\Core\Interfaces; 

require_once __DIR__ . '/StandardClassInterface.php';

interface UserInterface extends StandardClassInterface
{
    /**
     * Método responsável por cadastrar um novo usuário na base de d ados
     * 
     * @param array $info - informações do usuário recebidas via POST
     * @param ?array $photo - foto do usuário
     * 
     * @return void
     */
    public function store(array $info, ?array $photo): void;

    /**
     * Método responsável todos os usuários cadastrados na base
     * 
     * @return array
     */
    public function show(int $current_page, int $limit_per_page): array;
}