<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Conn, RenderTable, Tax};
use App\Core\Helpers\Helper;
use Exception;

class FeesHistory
{
    use Create, PreparedQuery, Update;

    private $conn = null;
    private string $table = '';
    private ?int $id_usuario = null;

    public function __construct()
    {
        $this->conn = Conn::openConn();
        $this->table = RenderTable::table('historico_juros');
        $this->id_usuario = $_SESSION['user']['id'];
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }

    public function saveOldInfo(array $data): bool
    {
        try {
            self::Create([
                'id_juros'      => $data['id'],
                'vezes'         => $data['vezesValorAnterior'],
                'juros'         => $data['jurosValorAnterior'],
                'created_by'    => $this->id_usuario,
            ]);

            return true;
        } catch (\Throwable $e) {
            Helper::jsonResponse($e->getMessage(), $e->getCode() ?? 400);
            return false;
        }
    }
}