<?php 

namespace App\Core\Exceptions;

require_once __DIR__ . '/../../bootstrap.php';

class PermissionException extends \Exception
{
    /**
     * Exception responsável por informar que o usuário não tem permissão para realizar a ação
     * 
     * @param string $message - mensagem de erro
     * @param int $code - código do erro (Padrão: 403 FORBIDDEN)
     * @param \Exception $previous - exceção anterior
     * 
     * @return void
     */
    public function __construct($message = "Você não tem permissão para realizar esta ação", $code = 403, \Exception $previous = null) {
        parent::__construct($message, $code, $previous);
    }

    /**
     * Método responsável por retornar a mensagem de erro
     * 
     * @return string
     */
    public function __toString() {
        return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
    }
}
