<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Conn};
use App\Core\Helpers\Helper;
use Exception;

class Costs
{
    use Create, PreparedQuery, Update;

    private $conn = null;

    private string $table = '';
    private ?int $id_usuario = null;

    public function __construct()
    {
        $this->conn = Conn::openConn();
        $this->table = 'config_custos';
        $this->id_usuario = $_SESSION['user']['id'];
    }

    public function __destruct()
    {
        $this->conn->close();
        $this->conn = null;
    }


    /**
     *
     * @todo refatorar o id
     */
    public function show(): array
    {
        return self::PreparedQuery("SELECT * FROM config_custos");
    }

    public function update(array $data)
    {
        try {
            $costs = [
                // h1
                'imposto' => Helper::formatFloatToAbsValue($data['imposto']),
                'custo_administrativo' => Helper::formatFloatToAbsValue($data['custoAdm']),
                'comissao' => Helper::formatFloatToAbsValue($data['comissao']),
                'desconto_financeiro' => Helper::formatFloatToAbsValue($data['desconfoFinanceiro']),

                // h2
                'imposto2' => Helper::formatFloatToAbsValue($data['imposto2']),
                'comissao2' => Helper::formatFloatToAbsValue($data['comissao2']),
                
                'updated_by' => $this->id_usuario,
            ];

            $rowsAffected = self::updateQuery($this->table, $costs, ['id' => (int)$data['id']]);

            if ($rowsAffected === false) {
                Helper::jsonResponse("Erro ao atualizar.", 400);
            }

            if ($rowsAffected === 0) {
                Helper::jsonResponse("Nenhum valor foi atualizado.", 200);
            }

            $costsHistory = new CostsHistory();
            if (!$costsHistory->saveOldInfo($data)) {
                throw new Exception("Erro ao salvar histórico", 400);
            }

            Helper::jsonResponse('Os dados foram atualizados com sucesso.');
        } catch (\Throwable $e) {
            Helper::jsonResponse($e->getMessage(), $e->getCode() ?? 400);
        }
    }

    public function get()
    {
        $data = self::PreparedQuery("SELECT * FROM config_custos");
        return $data[0];
    }

    public function calculate()
    {
        try {
            return self::PreparedQuery(
                "SELECT 
                    (imposto + custo_administrativo + comissao + desconto_financeiro) AS h1,
                    (imposto2 + comissao2) AS h2 
                FROM config_custos
            ")[0];
        } catch (\Throwable $e) {
            Helper::jsonResponse($e->getMessage(), 400);
        }
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     * @param string $route
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'update' => $this->update($_POST),
//             'store' => $this->store($_REQUEST),
//             'preparedModalStore' => $this->preparedModalStore()
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

// testar futuramente end(get_declared_classes())

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Costs') {
    $instance = new Costs();
    $instance->setRoute($_REQUEST['action']);
}
