<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\{Controller, RenderTable};
use App\Core\Helpers\Helper;

class Config extends Controller
{
    use Create, PreparedQuery, Update;

    private string $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = '';
    }

    public function getUltimoDiaTempoPerda()
    {
        $tblConfigOrcamentos = RenderTable::table('config_orcamentos');
        return self::PreparedQuery("SELECT dias FROM $tblConfigOrcamentos ORDER BY id DESC LIMIT 1")[0]['dias'];
    }

    private function atualizaTempoPerda(int $dias)
    {
        $this->table = RenderTable::table('config_orcamentos');

        try {
            self::Create(['dias' => $dias]);
        } catch (\Throwable $th) {
            Helper::jsonResponse($th->getMessage(), 400);
        }
    }

    /**
     * Método responsável por retornar a função solicitada pelo front-end
     *
     * @param string $route
     *
     * @return void
     */
    private function route(string $route): void
    {
        match ($route) {
            'atualizaTempoPerda' => $this->atualizaTempoPerda($_POST['dias']),
            'obtemEmojiRandomico' => Helper::jsonResponse(Helper::getRandomEmoji()),
            'obtemSaudacoes' => Helper::jsonResponse(Helper::getGreeting()),
            'obtemNomeNivel' => Helper::jsonResponse(Helper::printNivel($_SESSION['user']['nivel'])),
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Config') {
    $instance = new Config();
    $instance->setRoute($_REQUEST['action']);
}