<?php

namespace App\Core;

require_once __DIR__ . '/../../bootstrap.php';

use App\Core\Utilities\{Create, PreparedQuery, Update};
use App\Core\Middlewares\AuthenticationMiddleware;
use App\Core\{Controller, RenderTable};
use App\Core\Helpers\Helper;

class Categorias extends Controller
{
    use Create, PreparedQuery, Update;


    private string $table = '';

    public function __construct()
    {
        parent::__construct();
        $this->table = 'categoria';
    }

    /**
     * Método responsável por obter as categorias e seus `pais` como assim nomeados
     * 
     * @return array
     */
    public function getCategorias(): array
    {
        $query =
            "SELECT
                c.id,
                c.nome as categoria,
                co.nome as pai
            FROM categoria AS c
            LEFT JOIN categoria_origem AS co
                ON c.id_categoria_origem_FK = co.id
        ";

        return self::PreparedQuery($query);
    }

    /**
     * Método responsável por reorganizar as categorias e seus `pais`
     * 
     * @return array
     */
    public function reorganizaCategorias(): array
    {
        $categorias = $this->getCategorias();

        $categorias = array_map(function ($categoria) {
            return [
                'id' => $categoria['id'],
                'categoria' => $categoria['categoria'],
                'pai' => $categoria['pai']
            ];
        }, $categorias);

        $categorias = array_reduce($categorias, function ($acc, $categoria) {
            $acc[$categoria['pai']][$categoria['id']] = $categoria['categoria'];
            return $acc;
        }, []);

        return $categorias;
    }

    /**
     * Método responsável por obter a rota do ajax e retornar a funçao
     * 
     * @param string $route nome da rota
     */
    private function route(string $route): void
    {
        $auth_middleware = new AuthenticationMiddleware;
        
        match ($route) {
            'reorganizaCategorias' => $auth_middleware->handle(
                fn() => Helper::jsonResponse($this->reorganizaCategorias()),
            ),
        };
    }

    public function setRoute(string $route): void
    {
        $this->route($route);
    }
}

if (isset($_REQUEST['action']) && Helper::validateRequest($_SERVER['REQUEST_URI']) == 'Categorias') {
    $instance = new Categorias();
    $instance->setRoute($_REQUEST['action']);
}